/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.citizen;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.ai.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.ai.combat.threat.ThreatTable;
import com.minecolonies.api.entity.ai.statemachine.AIOneTimeEventTarget;
import com.minecolonies.api.entity.ai.statemachine.states.CitizenAIState;
import com.minecolonies.api.entity.ai.statemachine.states.EntityState;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenColonyHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenExperienceHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenInventoryHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenJobHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSleepHandler;
import com.minecolonies.api.entity.citizen.happiness.ExpirationBasedHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.StaticHappinessSupplier;
import com.minecolonies.api.eventbus.events.colony.citizens.CitizenDiedModEvent;
import com.minecolonies.api.eventbus.events.colony.citizens.CitizenRemovedModEvent;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.inventory.container.ContainerCitizenInventory;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.client.gui.WindowInteraction;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.colony.eventhooks.citizenEvents.CitizenDiedEvent;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.colony.jobs.JobKnight;
import com.minecolonies.core.colony.jobs.JobNetherWorker;
import com.minecolonies.core.colony.jobs.JobRanger;
import com.minecolonies.core.datalistener.DiseasesListener;
import com.minecolonies.core.debug.DebugPlayerManager;
import com.minecolonies.core.entity.ai.minimal.EntityAICitizenChild;
import com.minecolonies.core.entity.ai.minimal.EntityAIFloat;
import com.minecolonies.core.entity.ai.minimal.EntityAIInteractToggleAble;
import com.minecolonies.core.entity.ai.minimal.LookAtEntityGoal;
import com.minecolonies.core.entity.ai.minimal.LookAtEntityInteractGoal;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIBasic;
import com.minecolonies.core.entity.ai.workers.CitizenAI;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIGuard;
import com.minecolonies.core.entity.citizen.CitizenCombatTracker;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenColonyHandler;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenExperienceHandler;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenInventoryHandler;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenJobHandler;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenSleepHandler;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.entity.pathfinding.navigation.MovementHandler;
import com.minecolonies.core.event.EventHandler;
import com.minecolonies.core.event.TextureReloadListener;
import com.minecolonies.core.network.messages.client.ItemParticleEffectMessage;
import com.minecolonies.core.network.messages.client.VanillaParticleMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyViewCitizenViewMessage;
import com.minecolonies.core.network.messages.client.colony.PlaySoundForCitizenMessage;
import com.minecolonies.core.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.core.util.TeleportHelper;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityCitizen
extends AbstractEntityCitizen
implements IThreatTableEntity {
    private static final int CALL_HELP_CD = 100;
    private static final float GUARD_BLOCK_DAMAGE = 0.5f;
    private static final double MAX_SPEED_FACTOR = 0.5;
    private static final int CALL_TO_HELP_AMOUNT = 2;
    private int citizenId = 0;
    private ICitizenData citizenData;
    private ICitizenExperienceHandler citizenExperienceHandler;
    private ICitizenInventoryHandler citizenInventoryHandler;
    private ICitizenColonyHandler citizenColonyHandler;
    private ICitizenJobHandler citizenJobHandler;
    private ICitizenSleepHandler citizenSleepHandler;
    private final CitizenCombatTracker combatTracker;
    private boolean child = false;
    private int callForHelpCooldown = 0;
    private float lastDistanceWalked = 0.0f;
    private ICitizenDataView citizenDataView;
    private ILocation location = null;
    private ChunkPos lastChunk;
    private final ThreatTable threatTable = new ThreatTable<EntityCitizen>(this);
    private int interactionCooldown = 0;
    private ITickRateStateMachine<IState> citizenAI = new TickRateStateMachine<CitizenAIState>(CitizenAIState.IDLE, e -> {}, 5);
    private int maxAir = 300;
    private boolean isGlowing;

    public EntityCitizen(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
        this.citizenExperienceHandler = new CitizenExperienceHandler(this);
        this.citizenInventoryHandler = new CitizenInventoryHandler(this);
        this.citizenColonyHandler = new CitizenColonyHandler(this);
        this.citizenJobHandler = new CitizenJobHandler(this);
        this.citizenSleepHandler = new CitizenSleepHandler(this);
        this.combatTracker = new CitizenCombatTracker(this);
        this.moveControl = new MovementHandler((Mob)this);
        this.setPersistenceRequired();
        this.setCustomNameVisible((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).alwaysRenderNameTag.get());
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.INIT, () -> true, this::initialize, 40));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_CLIENT, () -> {
            this.citizenColonyHandler.updateColonyClient();
            return false;
        }, () -> null, 1));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_CLIENT, this::shouldBeInactive, () -> EntityState.INACTIVE, 20));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_CLIENT, this::refreshCitizenDataView, () -> null, 20));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_SERVER, this::updateHealing, () -> null, 100));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_SERVER, this::updateVisualData, () -> null, 200));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_SERVER, this::onServerUpdateHandlers, () -> null, 20));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_SERVER, this::onTickDecrements, () -> null, 1));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_SERVER, this::shouldBeInactive, () -> EntityState.INACTIVE, 20));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_SERVER, () -> {
            this.citizenAI.tick();
            return false;
        }, () -> null, 1));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.ACTIVE_SERVER, this::decreaseIdleSaturation, () -> null, 1200));
        this.entityStateController.addTransition(new TickingTransition<IState>(EntityState.INACTIVE, () -> ((EntityCitizen)this).isAlive(), () -> EntityState.INIT, 100));
    }

    private boolean shouldBeInactive() {
        if (this.citizenData == null && this.citizenDataView == null) {
            return true;
        }
        return !this.isAlive();
    }

    private EntityState initialize() {
        if (CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).isClientSide) {
            IColonyView colonyView;
            this.citizenColonyHandler.updateColonyClient();
            if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.level().dimension())) != null) {
                this.citizenDataView = colonyView.getCitizen(this.citizenId);
                if (this.citizenDataView != null) {
                    this.initTasks();
                    return EntityState.ACTIVE_CLIENT;
                }
            }
        } else {
            this.citizenColonyHandler.registerWithColony(this.citizenColonyHandler.getColonyId(), this.citizenId);
            if (this.citizenData != null && this.isAlive() && this.citizenColonyHandler.getColonyOrRegister() != null) {
                this.initTasks();
                return EntityState.ACTIVE_SERVER;
            }
        }
        return null;
    }

    private void initTasks() {
        new CitizenAI(this);
        int priority = 0;
        this.goalSelector.addGoal(priority, (Goal)new EntityAIFloat((Mob)this));
        this.goalSelector.addGoal(priority, (Goal)new EntityAIInteractToggleAble(this, EntityAIInteractToggleAble.FENCE_TOGGLE, EntityAIInteractToggleAble.TRAP_TOGGLE, EntityAIInteractToggleAble.DOOR_TOGGLE));
        this.goalSelector.addGoal(++priority, (Goal)new LookAtEntityInteractGoal((Mob)this, Player.class, 3.0f, 0.2f));
        this.goalSelector.addGoal(++priority, (Goal)new LookAtEntityInteractGoal((Mob)this, EntityCitizen.class, 5.0f, 0.02f));
        this.goalSelector.addGoal(++priority, (Goal)new LookAtEntityGoal((Mob)this, LivingEntity.class, 6.0f));
    }

    @NotNull
    public InteractionResult checkAndHandleImportantInteractions(Player player, @NotNull InteractionHand hand) {
        IColonyView iColonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)player.level().dimension());
        if (iColonyView != null && !iColonyView.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
            return InteractionResult.FAIL;
        }
        if (!ItemStackUtils.isEmpty(player.getItemInHand(hand)) && player.getItemInHand(hand).is(Items.NAME_TAG)) {
            return super.checkAndHandleImportantInteractions(player, hand);
        }
        InteractionResult result = this.directPlayerInteraction(player, hand);
        if (result != null) {
            return result;
        }
        if (CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).isClientSide && iColonyView != null) {
            if (player.isShiftKeyDown() && !this.isInvisible()) {
                new OpenInventoryMessage(iColonyView, this.getName().getString(), this.getId()).sendToServer();
            } else {
                ICitizenDataView citizenDataView = this.getCitizenDataView();
                if (citizenDataView != null && !this.isInvisible()) {
                    new WindowInteraction(citizenDataView).open();
                }
            }
        }
        if (!this.level().isClientSide && this.getCitizenData() != null) {
            this.citizenData.setInteractedRecently(player.getUUID());
            ColonyViewCitizenViewMessage message = new ColonyViewCitizenViewMessage((Colony)this.getCitizenData().getColony(), this.getCitizenData());
            message.sendToPlayer((ServerPlayer)player);
            if (DebugPlayerManager.hasDebugEnabled(player)) {
                this.getCitizenAI().setHistoryEnabled(true, 20);
                if (this.getCitizenJobHandler().getColonyJob() != null) {
                    this.getCitizenJobHandler().getWorkAI().getStateAI().setHistoryEnabled(true, 20);
                }
            } else {
                if (this.citizenData.getJob() != null) {
                    ((AbstractEntityAIBasic)this.citizenData.getJob().getWorkerAI()).setDelay(60);
                }
                this.getNavigation().stop();
                this.getLookControl().setLookAt((Entity)player);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult directPlayerInteraction(Player player, InteractionHand hand) {
        boolean isSick;
        if (player.isShiftKeyDown()) {
            return null;
        }
        ItemStack usedStack = player.getItemInHand(hand);
        if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).enableInDevelopmentFeatures.get()).booleanValue() && usedStack.getItem() instanceof BlockItem && ((BlockItem)usedStack.getItem()).getBlock() instanceof AbstractBlockHut) {
            BuildingEntry entry = ((AbstractBlockHut)((BlockItem)usedStack.getItem()).getBlock()).getBuildingEntry();
            for (BuildingEntry.ModuleProducer moduleProducer : entry.getModuleProducers()) {
                IBuildingModule iBuildingModule = BuildingEntry.produceModuleWithoutBuilding(moduleProducer.key);
                if (!(iBuildingModule instanceof WorkerBuildingModule)) continue;
                WorkerBuildingModule module = (WorkerBuildingModule)iBuildingModule;
                this.getCitizenJobHandler().setModelDependingOnJob(module.getJobEntry().produceJob(null));
                return InteractionResult.SUCCESS;
            }
        }
        if (this.isInteractionItem(usedStack) && this.interactionCooldown > 0) {
            if (!this.level().isClientSide()) {
                this.playSound(SoundEvents.VILLAGER_NO, 0.5f, (float)SoundUtils.getRandomPitch(this.getRandom()));
                MessageUtils.format("com.minecolonies.coremod.interaction.notnow", this.getCitizenData().getName()).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(player);
            }
            return InteractionResult.PASS;
        }
        boolean bl = isSick = this.getCitizenData() != null && this.getCitizenData().getCitizenDiseaseHandler().isSick() || this.citizenDataView != null && this.citizenDataView.getVisibleStatus() == VisibleCitizenStatus.SICK;
        if (usedStack.getItem() == Items.GOLDEN_APPLE && isSick) {
            usedStack.shrink(1);
            player.setItemInHand(hand, usedStack);
            if (!this.level().isClientSide() && this.getRandom().nextInt(3) == 0) {
                this.getCitizenData().getCitizenDiseaseHandler().cure();
                this.playSound(SoundEvents.PLAYER_LEVELUP, 1.0f, (float)SoundUtils.getRandomPitch(this.getRandom()));
                new VanillaParticleMessage(this.getX(), this.getY(), this.getZ(), ParticleTypes.HAPPY_VILLAGER).sendToTrackingEntity((Entity)this);
            }
            this.interactionCooldown = 6000;
            return InteractionResult.CONSUME;
        }
        if (usedStack.is(ModTags.poisonous_food)) {
            usedStack.shrink(1);
            player.setItemInHand(hand, usedStack);
            if (!this.level().isClientSide() && this.getCitizenData().getCitizenDiseaseHandler().setDisease(DiseasesListener.getRandomDisease(this.getRandom()))) {
                this.playSound(SoundEvents.VILLAGER_HURT, 1.0f, (float)SoundUtils.getRandomPitch(this.getRandom()));
                this.getCitizenData().markDirty(20);
                MessageUtils.format("com.minecolonies.coremod.interaction.poison", this.getCitizenData().getName()).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(player);
            }
            this.interactionCooldown = 400;
            return InteractionResult.CONSUME;
        }
        if (isSick) {
            return null;
        }
        if (ItemStackUtils.ISFOOD.test(usedStack) && usedStack.getItem() != Items.GOLDEN_APPLE) {
            if (this.isBaby()) {
                this.childFoodInteraction(usedStack, player, hand);
            } else {
                this.eatFoodInteraction(usedStack, player, hand);
            }
            return InteractionResult.CONSUME;
        }
        if (usedStack.getItem() == Items.BOOK && this.isBaby()) {
            usedStack.shrink(1);
            player.setItemInHand(hand, usedStack);
            if (!this.level().isClientSide()) {
                this.getCitizenData().getCitizenSkillHandler().addXpToSkill(Skill.Intelligence, 50.0, this.getCitizenData());
            }
            this.interactionCooldown = 6000;
            return InteractionResult.CONSUME;
        }
        if (usedStack.getItem() == Items.CACTUS) {
            usedStack.shrink(1);
            player.setItemInHand(hand, usedStack);
            if (!this.level().isClientSide()) {
                MessageUtils.format("com.minecolonies.coremod.interaction.ouch", this.getCitizenData().getName()).sendTo(player);
                EntityNavigationUtils.walkAwayFrom(this, player.blockPosition(), 5, 1.0);
                this.setJumping(true);
            }
            this.interactionCooldown = 6000;
            return InteractionResult.CONSUME;
        }
        if (usedStack.getItem() == Items.GLOWSTONE_DUST) {
            usedStack.shrink(1);
            player.setItemInHand(hand, usedStack);
            if (!this.level().isClientSide()) {
                this.addEffect(new MobEffectInstance(MobEffects.GLOWING, 3600));
            }
            this.interactionCooldown = 3600;
            return InteractionResult.CONSUME;
        }
        return null;
    }

    public boolean isInteractionItem(ItemStack stack) {
        return ItemStackUtils.ISFOOD.test(stack) || stack.getItem() == Items.BOOK || stack.getItem() == Items.GOLDEN_APPLE || stack.getItem() == Items.CACTUS || stack.getItem() == Items.GLOWSTONE_DUST || stack.is(ModTags.poisonous_food);
    }

    private void childFoodInteraction(ItemStack usedStack, Player player, InteractionHand hand) {
        if (usedStack.getDisplayName().getString().toLowerCase(Locale.US).contains("cookie")) {
            this.interactionCooldown = 100;
            if (!this.level().isClientSide()) {
                this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 300));
                this.playSound(SoundEvents.GENERIC_EAT, 1.5f, (float)SoundUtils.getRandomPitch(this.getRandom()));
                new ItemParticleEffectMessage(usedStack.copy(), this.getX(), this.getY(), this.getZ(), this.getXRot(), this.getYRot(), this.getEyeHeight()).sendToTrackingEntity((Entity)this);
                ItemStackUtils.consumeFood(usedStack, this, player);
            }
        } else {
            player.getInventory().removeItem(usedStack);
            player.drop(usedStack, true, true);
            if (!this.level().isClientSide()) {
                this.playSound(SoundEvents.VILLAGER_NO, 1.0f, (float)SoundUtils.getRandomPitch(this.getRandom()));
                MessageUtils.format("com.minecolonies.coremod.interaction.nocookie", this.getCitizenData().getName()).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(player);
            }
        }
    }

    private void eatFoodInteraction(ItemStack usedStack, Player player, InteractionHand hand) {
        if (!this.level().isClientSide()) {
            this.playSound(SoundEvents.GENERIC_EAT, 1.5f, (float)SoundUtils.getRandomPitch(this.getRandom()));
            new ItemParticleEffectMessage(usedStack.copy(), this.getX(), this.getY(), this.getZ(), this.getXRot(), this.getYRot(), this.getEyeHeight()).sendToTrackingEntity((Entity)this);
            if (this.citizenData != null) {
                this.citizenData.getCitizenFoodHandler().addLastEaten(usedStack.getItem());
            }
            ItemStackUtils.consumeFood(usedStack, this, player);
        }
        this.interactionCooldown = 100;
    }

    @NotNull
    public String getScoreboardName() {
        return this.getName().getString() + " (" + this.getCivilianID() + ")";
    }

    @Override
    public ICitizenDataView getCitizenDataView() {
        if (this.citizenDataView == null) {
            IColonyView colonyView;
            if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.level().dimension())) != null) {
                this.citizenDataView = colonyView.getCitizen(this.citizenId);
                return this.citizenDataView;
            }
        } else {
            return this.citizenDataView;
        }
        return null;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("colony", this.citizenColonyHandler.getColonyId());
        if (this.citizenData != null) {
            compound.putInt("citizen", this.citizenData.getId());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("colony")) {
            this.citizenColonyHandler.setColonyId(compound.getInt("colony"));
            if (compound.contains("citizen")) {
                this.citizenId = compound.getInt("citizen");
            }
        }
        this.setPose(Pose.STANDING);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.interactionCooldown > 0) {
            --this.interactionCooldown;
        }
    }

    public boolean refreshCitizenDataView() {
        IColonyView colonyView;
        if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.level().dimension())) != null) {
            this.citizenDataView = colonyView.getCitizen(this.citizenId);
            this.getNavigation().getPathingOptions().setCanUseRails(this.canPathOnRails());
            this.getNavigation().getPathingOptions().setCanClimbAdvanced(this.canClimbVines());
        }
        return false;
    }

    private boolean onTickDecrements() {
        this.decrementCallForHelpCooldown();
        this.decreaseWalkingSaturation();
        return false;
    }

    private boolean onServerUpdateHandlers() {
        this.citizenExperienceHandler.gatherXp();
        CitizenItemUtils.pickupItems(this);
        this.citizenData.setLastPosition(this.blockPosition());
        this.onLivingSoundUpdate();
        ChunkPos currentChunk = this.chunkPosition();
        if (!Objects.equals(currentChunk, this.lastChunk)) {
            this.lastChunk = currentChunk;
            EventHandler.onEnteringChunkEntity(this, currentChunk);
        }
        return false;
    }

    public int getMaxAirSupply() {
        return this.maxAir;
    }

    private boolean updateVisualData() {
        this.setCustomNameVisible((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).alwaysRenderNameTag.get());
        if (!this.citizenColonyHandler.getColonyOrRegister().getTextureStyleId().equals(this.getEntityData().get(DATA_STYLE))) {
            this.getEntityData().set(DATA_STYLE, (Object)this.citizenColonyHandler.getColonyOrRegister().getTextureStyleId());
        }
        if (!this.citizenData.getTextureSuffix().equals(this.getEntityData().get(DATA_TEXTURE_SUFFIX))) {
            this.getEntityData().set(DATA_TEXTURE_SUFFIX, (Object)this.citizenData.getTextureSuffix());
        }
        return false;
    }

    private boolean updateHealing() {
        this.checkHeal();
        if (this.citizenData.getSaturation() <= 0.0) {
            if (this.getEffect(MobEffects.MOVEMENT_SLOWDOWN) == null) {
                this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 600));
            }
        } else {
            this.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
        }
        return false;
    }

    private void decrementCallForHelpCooldown() {
        if (this.callForHelpCooldown > 0) {
            --this.callForHelpCooldown;
        }
    }

    public boolean canPathOnRails() {
        if (this.level().isClientSide) {
            IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.level().dimension());
            if (colonyView != null) {
                return colonyView.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.RAILS) > 0.0;
            }
            return false;
        }
        return this.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.RAILS) > 0.0;
    }

    public boolean canClimbVines() {
        if (this.level().isClientSide) {
            IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.level().dimension());
            if (colonyView != null) {
                return colonyView.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.VINES) > 0.0;
            }
            return false;
        }
        return this.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.VINES) > 0.0;
    }

    private void decreaseWalkingSaturation() {
        if (this.walkDist - this.lastDistanceWalked > 25.0f) {
            this.lastDistanceWalked = this.walkDist;
            this.decreaseSaturationForContinuousAction();
        }
    }

    private void checkHeal() {
        if (this.getCitizenData() != null) {
            float f = this.getHealth();
            float f2 = this.getCitizenData().getCitizenDiseaseHandler().isSick() ? this.getMaxHealth() / 3.0f : this.getMaxHealth();
            if (f < f2 && this.getLastHurtByMob() == null) {
                double limitDecrease = this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SATLIMIT);
                double citizenSaturation = this.citizenData.getSaturation();
                double healAmount = citizenSaturation >= 20.0 + limitDecrease ? 2.0 * (1.0 + this.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.REGENERATION)) : (citizenSaturation < 6.0 ? 1.0 * (citizenSaturation / 20.0) / 2.0 : 1.0 * (1.0 + this.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.REGENERATION)));
                this.heal((float)healAmount);
            }
        }
    }

    private void onLivingSoundUpdate() {
        if (WorldUtil.isDayTime(this.level()) && !this.isSilent()) {
            SoundUtils.playRandomSound(this.level(), this.blockPosition(), this.citizenData);
        }
    }

    public boolean isBaby() {
        return this.child;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_COLONY_ID, (Object)(this.citizenColonyHandler == null ? 0 : this.citizenColonyHandler.getColonyId()));
        builder.define(DATA_CITIZEN_ID, (Object)this.citizenId);
    }

    @Override
    public void setRenderMetadata(String metadata) {
        super.setRenderMetadata(metadata);
        if (this.citizenJobHandler.getColonyJob() != null && ((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).enableInDevelopmentFeatures.get()).booleanValue()) {
            super.setCustomName((Component)Component.literal((String)(this.citizenData.getName() + "[" + this.citizenJobHandler.getColonyJob().getNameTagDescription() + "]")));
        }
    }

    @Override
    public ILocation getLocation() {
        if (this.location == null) {
            this.location = StandardFactoryController.getInstance().getNewInstance(TypeConstants.ILOCATION, this, new Object[0]);
        }
        return this.location;
    }

    @Override
    public ICitizenData getCitizenData() {
        return this.citizenData;
    }

    @Override
    public ICivilianData getCivilianData() {
        return this.citizenData;
    }

    @Override
    public void setCivilianData(@Nullable ICivilianData data) {
        if (data != null) {
            this.citizenData = (ICitizenData)data;
            data.initEntityValues();
        }
    }

    @Override
    @NotNull
    public InventoryCitizen getInventoryCitizen() {
        return this.getCitizenData().getInventory();
    }

    @Override
    @NotNull
    public IItemHandler getItemHandlerCitizen() {
        return this.getInventoryCitizen();
    }

    @Override
    public void markDirty(int time) {
        if (this.citizenData != null) {
            this.citizenData.markDirty(time);
        }
    }

    @Override
    public void setIsChild(boolean isChild) {
        if (isChild && !this.child) {
            new EntityAICitizenChild(this);
        } else if (!isChild && this.child) {
            this.child = isChild;
            this.getCitizenJobHandler().setModelDependingOnJob(this.citizenJobHandler.getColonyJob());
        }
        this.child = isChild;
        this.getEntityData().set(DATA_IS_CHILD, (Object)isChild);
        this.refreshDimensions();
        this.markDirty(0);
    }

    @Override
    public void playMoveAwaySound() {
        if (this.citizenJobHandler.getColonyJob() != null) {
            SoundUtils.playSoundAtCitizenWith(this.level(), this.blockPosition(), EventType.DANGER, this.getCitizenData());
        }
    }

    @Override
    public void decreaseSaturationForAction() {
        if (this.citizenData != null) {
            this.citizenData.decreaseSaturation(this.citizenColonyHandler.getPerBuildingFoodCost() / 2.0);
            this.citizenData.markDirty(400);
        }
    }

    @Override
    public void decreaseSaturationForContinuousAction() {
        if (this.citizenData != null) {
            this.citizenData.decreaseSaturation(this.citizenColonyHandler.getPerBuildingFoodCost() / 150.0);
            this.citizenData.markDirty(2400);
        }
    }

    @Override
    public int getCivilianID() {
        return this.citizenId;
    }

    @Override
    public void setCitizenId(int id) {
        this.citizenId = id;
    }

    @Override
    public ICitizenExperienceHandler getCitizenExperienceHandler() {
        return this.citizenExperienceHandler;
    }

    @Override
    public ICitizenInventoryHandler getCitizenInventoryHandler() {
        return this.citizenInventoryHandler;
    }

    @Override
    public void setCitizenInventoryHandler(ICitizenInventoryHandler citizenInventoryHandler) {
        this.citizenInventoryHandler = citizenInventoryHandler;
    }

    @Override
    public ICitizenColonyHandler getCitizenColonyHandler() {
        return this.citizenColonyHandler;
    }

    @Override
    public void setCitizenColonyHandler(ICitizenColonyHandler citizenColonyHandler) {
        this.citizenColonyHandler = citizenColonyHandler;
    }

    @Override
    public ICitizenJobHandler getCitizenJobHandler() {
        return this.citizenJobHandler;
    }

    @Override
    public ICitizenSleepHandler getCitizenSleepHandler() {
        return this.citizenSleepHandler;
    }

    public void setVisibleStatusIfNone(VisibleCitizenStatus status) {
        if (this.getCitizenData().getStatus() == null) {
            this.getCitizenData().setVisibleStatus(status);
        }
    }

    @Override
    public float getRotationYaw() {
        return this.getYRot();
    }

    @Override
    public float getRotationPitch() {
        return this.getXRot();
    }

    @Override
    public boolean isDead() {
        return !this.isAlive();
    }

    @Override
    public void setCitizenSleepHandler(ICitizenSleepHandler citizenSleepHandler) {
        this.citizenSleepHandler = citizenSleepHandler;
    }

    @Override
    public void setCitizenJobHandler(ICitizenJobHandler citizenJobHandler) {
        this.citizenJobHandler = citizenJobHandler;
    }

    @Override
    public void setCitizenExperienceHandler(ICitizenExperienceHandler citizenExperienceHandler) {
        this.citizenExperienceHandler = citizenExperienceHandler;
    }

    @Override
    public boolean hurt(@NotNull DamageSource damageSource, float damage) {
        Player player;
        Entity entity = damageSource.getEntity();
        if (entity instanceof Player && (player = (Player)entity).isCreative() && player.getMainHandItem().getItem() == ModItems.scanAnalyzer) {
            CompoundTag tag = new CompoundTag();
            try {
                this.save(tag);
            }
            catch (Exception e) {
                Log.getLogger().warn("Error while saving:", (Throwable)e);
            }
            Log.getLogger().warn("Entity:" + this.getName().toString() + " uuid:" + String.valueOf(this.getUUID()) + " id:" + this.getId() + " removed:" + this.isRemoved() + " colonyid:" + this.citizenColonyHandler.getColonyId() + " entitydata colony id:" + String.valueOf(this.getEntityData().get(DATA_COLONY_ID)) + " hascolony:" + (this.citizenColonyHandler.getColony() != null) + " registered:" + this.citizenColonyHandler.registered() + " world:" + String.valueOf(this.level()) + " saved data:" + String.valueOf(tag));
        }
        if (this.handleInWallDamage(damageSource)) {
            return false;
        }
        Entity sourceEntity = damageSource.getEntity();
        if (!this.checkIfValidDamageSource(damageSource, damage)) {
            return false;
        }
        if (this.getCitizenJobHandler().getColonyJob() != null && this.getCitizenJobHandler().getColonyJob().ignoresDamage(damageSource)) {
            return false;
        }
        if (this.getCitizenColonyHandler().getColonyOrRegister() == null) {
            return super.hurt(damageSource, damage);
        }
        return this.handleDamagePerformed(damageSource, damage, sourceEntity);
    }

    private boolean handleInWallDamage(@NotNull DamageSource damageSource) {
        if (damageSource.typeHolder().is(DamageTypes.IN_WALL)) {
            TeleportHelper.teleportCitizen(this, this.level(), this.blockPosition());
            return true;
        }
        return damageSource.typeHolder().is(DamageTypes.IN_WALL) && this.citizenSleepHandler.isAsleep() || this.isInvulnerable();
    }

    private boolean checkIfValidDamageSource(DamageSource source, float damage) {
        Entity sourceEntity = source.getEntity();
        if (sourceEntity instanceof EntityCitizen) {
            if (((EntityCitizen)sourceEntity).citizenColonyHandler.getColonyId() == this.citizenColonyHandler.getColonyId()) {
                return false;
            }
            IColony attackerColony = ((EntityCitizen)sourceEntity).citizenColonyHandler.getColonyOrRegister();
            if (attackerColony != null && this.citizenColonyHandler.getColonyOrRegister() != null) {
                IPermissions permission = attackerColony.getPermissions();
                this.citizenColonyHandler.getColonyOrRegister().getPermissions().addPlayer(permission.getOwner(), permission.getOwnerName(), permission.getRank(4));
            }
        }
        if (sourceEntity instanceof Player) {
            if (sourceEntity instanceof ServerPlayer) {
                if (this.citizenColonyHandler.getColonyOrRegister().getRaiderManager().isRaided()) {
                    return false;
                }
                if (damage > 1.0f && !this.getCitizenColonyHandler().getColonyOrRegister().getPermissions().hasPermission((Player)sourceEntity, Action.HURT_CITIZEN)) {
                    return false;
                }
                if (this.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) {
                    return IGuardBuilding.checkIfGuardShouldTakeDamage(this, (Player)sourceEntity);
                }
            } else {
                IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.getCitizenColonyHandler().getColonyId(), (ResourceKey<Level>)this.level().dimension());
                return damage <= 1.0f || colonyView == null || colonyView.getPermissions().hasPermission((Player)sourceEntity, Action.HURT_CITIZEN);
            }
        }
        return true;
    }

    public float getSpeed() {
        return (float)Math.min(0.5, (double)super.getSpeed());
    }

    private boolean handleDamagePerformed(@NotNull DamageSource damageSource, float damage, Entity sourceEntity) {
        float blockedDamage;
        LivingShieldBlockEvent ev;
        boolean result;
        float damageInc = Math.min(damage, this.getMaxHealth() * 0.2f);
        if (this.citizenJobHandler.getColonyJob() instanceof JobNetherWorker && this.citizenData != null && damageSource.typeHolder().is(DamageSourceKeys.NETHER)) {
            damageInc = damage;
        }
        if (!this.level().isClientSide && !this.isInvisible()) {
            this.performMoveAway(sourceEntity);
        }
        this.setLastHurtMob(damageSource.getEntity());
        if (!this.level().isClientSide && this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard && this.citizenData != null) {
            if (this.citizenJobHandler.getColonyJob() instanceof JobKnight && this.citizenColonyHandler.getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.BLOCK_ATTACKS) > 0.0 && this.getRandom().nextDouble() < this.citizenColonyHandler.getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.BLOCK_ATTACKS)) {
                return false;
            }
            if (this.citizenData.getWorkBuilding() instanceof AbstractBuildingGuards && ((AbstractBuildingGuards)this.citizenData.getWorkBuilding()).shallRetrieveOnLowHealth() && (double)this.getHealth() < (double)((int)this.getMaxHealth()) * 0.2) {
                damageInc = (float)((double)damageInc * (1.0 - this.citizenColonyHandler.getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FLEEING_DAMAGE)));
            }
        }
        if (!(result = super.hurt(damageSource, damageInc)) && damageInc > 0.0f && !this.damageContainers.empty() && (ev = CommonHooks.onDamageBlock((LivingEntity)this, (DamageContainer)((DamageContainer)this.damageContainers.peek()), (boolean)this.isDamageSourceBlocked(damageSource))).getBlocked() && (blockedDamage = ((DamageContainer)this.damageContainers.peek()).getBlockedDamage()) > 0.0f && this.getItemInHand(this.getUsedItemHand()).getItem() instanceof ShieldItem) {
            if (this.getHealth() > blockedDamage * 0.5f) {
                float blockDamage = CombatRules.getDamageAfterAbsorb((LivingEntity)this, (float)(blockedDamage * 0.5f), (DamageSource)damageSource, (float)this.getArmorValue(), (float)((float)this.getAttribute(Attributes.ARMOR_TOUGHNESS).getValue()));
                this.setHealth(this.getHealth() - Math.max(0.5f, blockDamage));
                result = true;
            }
            CitizenItemUtils.damageItemInHand(this, this.getUsedItemHand(), (int)(blockedDamage * 0.5f));
        }
        if (!result) {
            return false;
        }
        if (damageSource.getEntity() instanceof LivingEntity) {
            this.threatTable.addThreat((LivingEntity)damageSource.getEntity(), (int)damageInc);
        }
        if (damageSource.is(DamageTypeTags.IS_FIRE) || damageSource.is(DamageTypeTags.IS_LIGHTNING)) {
            return true;
        }
        if (!this.level().isClientSide) {
            CitizenItemUtils.updateArmorDamage(this, damageInc);
            if (this.citizenData != null) {
                this.getCitizenData().getCitizenHappinessHandler().addModifier(new ExpirationBasedHappinessModifier("damage", 2.0, new StaticHappinessSupplier(0.0), 1));
            }
        }
        return true;
    }

    private void performMoveAway(@Nullable Entity attacker) {
        if (!(attacker instanceof LivingEntity || this.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && !this.getCitizenJobHandler().getColonyJob().canAIBeInterrupted())) {
            EntityNavigationUtils.walkAwayFrom(this, this.blockPosition(), 5, 1.1);
            return;
        }
        if (attacker == null) {
            return;
        }
        if (this.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) {
            this.callForHelp(attacker, 900);
            return;
        }
        this.citizenAI.addTransition(new AIOneTimeEventTarget<CitizenAIState>(CitizenAIState.FLEE));
        this.callForHelp(attacker, 90000);
        EntityNavigationUtils.walkAwayFrom(this, attacker.blockPosition(), 15, 1.1);
    }

    @Override
    public void callForHelp(Entity attacker, int guardHelpRange) {
        if (!(attacker instanceof LivingEntity) || this.callForHelpCooldown != 0) {
            return;
        }
        if (this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard && this.citizenJobHandler.getColonyJob(AbstractJobGuard.class).isAsleep()) {
            return;
        }
        this.callForHelpCooldown = 100;
        ArrayList<AbstractEntityCitizen> possibleGuards = new ArrayList<AbstractEntityCitizen>();
        for (ICitizenData entry : this.getCitizenColonyHandler().getColonyOrRegister().getCitizenManager().getCitizens()) {
            if (!entry.getEntity().isPresent() || !(entry.getJob() instanceof AbstractJobGuard) || entry.getId() == this.citizenData.getId() || BlockPosUtil.getDistanceSquared(entry.getEntity().get().blockPosition(), this.blockPosition()) >= (long)guardHelpRange || entry.getJob().getWorkerAI() == null) continue;
            ThreatTable table = ((EntityCitizen)entry.getEntity().get()).getThreatTable();
            table.addThreat((LivingEntity)attacker, 0);
            if (!((AbstractEntityAIGuard)entry.getJob().getWorkerAI()).canHelp(attacker.blockPosition())) continue;
            possibleGuards.add(entry.getEntity().get());
        }
        Collections.sort(possibleGuards, Comparator.comparingInt(guard -> (int)this.blockPosition().distSqr((Vec3i)guard.blockPosition())));
        for (int i = 0; i < possibleGuards.size() && i <= 2; ++i) {
            ((AbstractEntityAIGuard)((AbstractEntityCitizen)possibleGuards.get(i)).getCitizenData().getJob().getWorkerAI()).startHelpCitizen((LivingEntity)attacker);
        }
    }

    protected void doPush(Entity entity) {
        AbstractEntityCitizen otherCitizen;
        if (!this.citizenSleepHandler.isAsleep()) {
            super.doPush(entity);
        }
        if (!this.level().isClientSide && this.getCitizenData() != null && entity instanceof AbstractEntityCitizen && (otherCitizen = (AbstractEntityCitizen)entity).getCitizenData() != null) {
            this.getCitizenData().getCitizenDiseaseHandler().onCollission(otherCitizen.getCitizenData());
        }
    }

    @Override
    public void onPlayerCollide(Player player) {
        super.onPlayerCollide(player);
        if (this.citizenJobHandler.getColonyJob() != null && this.citizenJobHandler.getColonyJob().getWorkerAI() instanceof AbstractEntityAIBasic && !this.citizenJobHandler.getColonyJob().isGuard()) {
            ((AbstractEntityAIBasic)this.citizenJobHandler.getColonyJob().getWorkerAI()).setDelay(60);
        }
    }

    public float getAgeScale() {
        return this.isBaby() ? 0.62f : 1.0f;
    }

    public void die(@NotNull DamageSource damageSource) {
        if (this.citizenColonyHandler.getColonyOrRegister() != null && this.getCitizenData() != null) {
            this.citizenColonyHandler.getColonyOrRegister().getRaiderManager().onLostCitizen(this.getCitizenData());
            this.citizenExperienceHandler.dropExperience();
            this.remove(Entity.RemovalReason.KILLED);
            if (!(this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard)) {
                this.citizenColonyHandler.getColonyOrRegister().getCitizenManager().injectModifier(new ExpirationBasedHappinessModifier("death", 3.0, new StaticHappinessSupplier(0.0), 3));
            }
            this.triggerDeathAchievement(damageSource, this.citizenJobHandler.getColonyJob());
            if (!(this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard)) {
                this.citizenColonyHandler.getColonyOrRegister().getCitizenManager().updateCitizenMourn(this.citizenData, true);
            }
            this.getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().increment("death", this.getCitizenColonyHandler().getColonyOrRegister().getDay());
            boolean graveSpawned = false;
            if (!this.isInvisible()) {
                if (this.citizenColonyHandler.getColonyOrRegister().isCoordInColony(this.level(), this.blockPosition())) {
                    graveSpawned = this.getCitizenColonyHandler().getColonyOrRegister().getGraveManager().createCitizenGrave(this.level(), this.blockPosition(), this.citizenData);
                } else {
                    InventoryUtils.dropItemHandler((IItemHandler)this.citizenData.getInventory(), this.level(), (int)this.getX(), (int)this.getY(), (int)this.getZ());
                }
            }
            if (this.getCitizenColonyHandler().getColonyOrRegister() != null && this.getCitizenData() != null) {
                MessageUtils.format(this.getCombatTracker().getDeathMessage()).append((Component)Component.literal((String)"! ")).append((Component)Component.translatable((String)"block.blockhuttownhall.messagecolonistgravelocation", (Object[])new Object[]{Math.round(this.getX()), Math.round(this.getY()), Math.round(this.getZ())})).append((Component)(!(this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard) ? Component.translatable((String)"com.minecolonies.coremod.mourning", (Object[])new Object[]{this.getCitizenData().getName()}) : Component.empty())).append((Component)(graveSpawned ? Component.translatable((String)"com.minecolonies.coremod.gravespawned") : Component.empty())).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(this.getCitizenColonyHandler().getColonyOrRegister()).forManagers();
            }
            if (this.citizenData.getJob() != null) {
                this.citizenData.getJob().onRemoval();
            }
            this.citizenColonyHandler.getColonyOrRegister().getCitizenManager().removeCivilian(this.getCitizenData());
            String deathCause = Component.literal((String)damageSource.getLocalizedDeathMessage((LivingEntity)this).getString()).getString().replaceFirst(this.getDisplayName().getString(), "Citizen");
            this.citizenColonyHandler.getColonyOrRegister().getEventDescriptionManager().addEventDescription(new CitizenDiedEvent(this.blockPosition(), this.citizenData.getName(), deathCause));
            IMinecoloniesAPI.getInstance().getEventBus().post(new CitizenDiedModEvent(this.citizenData, damageSource));
        }
        super.die(damageSource);
    }

    public void remove(@NotNull Entity.RemovalReason reason) {
        super.remove(reason);
        IMinecoloniesAPI.getInstance().getEventBus().post(new CitizenRemovedModEvent(this.citizenColonyHandler.getColony(), this.citizenId, reason));
    }

    private void triggerDeathAchievement(DamageSource source, IJob<?> job) {
        if (job != null) {
            job.triggerDeathAchievement(source, this);
        }
    }

    protected void dropEquipment() {
        for (int i = 0; i < this.getInventoryCitizen().getSlots(); ++i) {
            ItemStack itemstack = this.getCitizenData().getInventory().getStackInSlot(i);
            if (ItemStackUtils.getSize(itemstack) <= 0) continue;
            CitizenItemUtils.entityDropItem(this, itemstack);
        }
    }

    @NotNull
    public Iterable<ItemStack> getAllSlots() {
        if (this.citizenData != null) {
            return this.citizenData.getInventory().getIterableArmorAndHandInv();
        }
        if (this.citizenDataView != null) {
            return this.citizenDataView.getInventory().getIterableArmorAndHandInv();
        }
        return super.getAllSlots();
    }

    @NotNull
    public ItemStack getItemBySlot(EquipmentSlot slotType) {
        switch (slotType.getType()) {
            case HAND: {
                return super.getItemBySlot(slotType);
            }
            case HUMANOID_ARMOR: {
                if (this.citizenData != null) {
                    return this.citizenData.getInventory().getArmorInSlot(slotType);
                }
                if (this.citizenDataView != null) {
                    return this.citizenDataView.getInventory().getArmorInSlot(slotType);
                }
                return super.getItemBySlot(slotType);
            }
        }
        return ItemStack.EMPTY;
    }

    public int getArmorValue() {
        if (this.citizenJobHandler.getColonyJob() instanceof JobKnight) {
            return (int)((double)super.getArmorValue() * (1.0 + this.citizenColonyHandler.getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MELEE_ARMOR)));
        }
        if (this.citizenJobHandler.getColonyJob() instanceof JobRanger) {
            return (int)((double)super.getArmorValue() * (1.0 + this.citizenColonyHandler.getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARCHER_ARMOR)));
        }
        return super.getArmorValue();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntityCitizen) {
            EntityCitizen citizen = (EntityCitizen)obj;
            return citizen.citizenColonyHandler.getColonyId() == this.citizenColonyHandler.getColonyId() && citizen.citizenId == this.citizenId;
        }
        return false;
    }

    public int hashCode() {
        if (this.citizenColonyHandler == null) {
            return super.hashCode();
        }
        return Objects.hash(this.citizenId, this.citizenColonyHandler.getColonyId());
    }

    public void setRemoved(Entity.RemovalReason reason) {
        this.citizenColonyHandler.onCitizenRemoved();
        super.setRemoved(reason);
    }

    public void setCustomName(@Nullable Component name) {
        if (this.citizenData != null && this.citizenColonyHandler.getColonyOrRegister() != null && name != null) {
            this.citizenData.setName(name.getString());
            super.setCustomName(name);
        }
    }

    public void spawnAnim() {
        super.spawnAnim();
    }

    protected void pickUpItem(ItemEntity itemEntity) {
    }

    public boolean requiresCustomPersistence() {
        return true;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new ContainerCitizenInventory(id, inv, this.citizenColonyHandler.getColonyId(), this.citizenId);
    }

    @Override
    public void setTexture() {
        super.setTexture();
    }

    @Override
    public void queueSound(@NotNull SoundEvent soundEvent, BlockPos pos, int length, int repetitions) {
        if (soundEvent == null || !BuiltInRegistries.SOUND_EVENT.containsKey(soundEvent.getLocation())) {
            return;
        }
        new PlaySoundForCitizenMessage(this.getId(), soundEvent, this.getSoundSource(), pos, this.level(), length, repetitions).sendToTargetPoint((ServerLevel)this.level(), null, pos.getX(), pos.getY(), pos.getZ(), 16.0);
    }

    @Override
    public void queueSound(@NotNull SoundEvent soundEvent, BlockPos pos, int length, int repetitions, float volume, float pitch) {
        if (soundEvent == null || !BuiltInRegistries.SOUND_EVENT.containsKey(soundEvent.getLocation())) {
            return;
        }
        new PlaySoundForCitizenMessage(this.getId(), soundEvent, this.getSoundSource(), pos, this.level(), volume, pitch, length, repetitions).sendToTargetPoint((ServerLevel)this.level(), null, pos.getX(), pos.getY(), pos.getZ(), 16.0);
    }

    public boolean isActive() {
        return this.level().isClientSide ? this.entityStateController.getState() == EntityState.ACTIVE_CLIENT : this.entityStateController.getState() == EntityState.ACTIVE_SERVER;
    }

    @Override
    public ThreatTable getThreatTable() {
        return this.threatTable;
    }

    public ITickRateStateMachine<IState> getCitizenAI() {
        return this.citizenAI;
    }

    public boolean isSuppressingBounce() {
        if (this.citizenSleepHandler.isAsleep()) {
            return true;
        }
        return super.isSuppressingBounce();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        super.onSyncedDataUpdated(dataAccessor);
        if (this.citizenColonyHandler != null) {
            this.citizenColonyHandler.onSyncDataUpdate(dataAccessor);
        }
        if (this.level().isClientSide && dataAccessor == DATA_STYLE && !TextureReloadListener.TEXTURE_PACKS.contains(this.getEntityData().get(DATA_STYLE))) {
            this.getEntityData().set(DATA_STYLE, (Object)TextureReloadListener.TEXTURE_PACKS.get(0));
        }
    }

    public boolean isCurrentlyGlowing() {
        return this.isGlowing || super.isCurrentlyGlowing();
    }

    public void setGlowing(boolean isGlowing) {
        this.isGlowing = isGlowing;
    }

    public CombatTracker getCombatTracker() {
        return this.combatTracker;
    }

    public void setMaxAir(int maxAir) {
        this.maxAir = maxAir;
    }

    @Override
    public int getTeamId() {
        return this.citizenColonyHandler.getColonyId();
    }

    private boolean decreaseIdleSaturation() {
        if (this.citizenData != null) {
            int buildingLevel;
            int n = buildingLevel = this.citizenData.getHomeBuilding() == null ? 1 : this.citizenData.getHomeBuilding().getBuildingLevelEquivalent();
            if (buildingLevel <= 2) {
                this.citizenData.decreaseSaturation((double)buildingLevel / 25.0);
            } else {
                this.citizenData.decreaseSaturation((double)buildingLevel / 10.0);
            }
        }
        return false;
    }
}

