/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production.agriculture;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.advancements.MaxFieldsTrigger;
import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.entity.ai.JobStatus;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.blocks.BlockScarecrow;
import com.minecolonies.core.blocks.MinecoloniesCropBlock;
import com.minecolonies.core.blocks.MinecoloniesFarmland;
import com.minecolonies.core.colony.buildingextensions.FarmField;
import com.minecolonies.core.colony.buildings.modules.BuildingExtensionsModule;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobFarmer;
import com.minecolonies.core.entity.ai.workers.crafting.AbstractEntityAICrafting;
import com.minecolonies.core.items.ItemCrop;
import com.minecolonies.core.network.messages.client.CompostParticleMessage;
import com.minecolonies.core.util.AdvancementUtils;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkFarmer
extends AbstractEntityAICrafting<JobFarmer, BuildingFarmer> {
    private static final int MAX_BLOCKS_MINED = 64;
    private static final int DEFAULT_DELAY = 40;
    private static final int SMALLEST_DELAY = 1;
    private static final double DELAY_DIVIDER = 1.0;
    private static final double XP_PER_HARVEST = 0.5;
    private static final int MAX_DEPTH = 5;
    private static final VisibleCitizenStatus FARMING_ICON = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/farmer.png"), "com.minecolonies.gui.visiblestatus.farmer");
    private boolean shouldDumpInventory = false;
    private boolean didWork = false;
    private int skippedState = 0;

    public EntityAIWorkFarmer(@NotNull JobFarmer job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.PREPARING, this::prepareForFarming, 20), new AITarget<Object>(AIWorkerState.FARMER_HOE, this::workAtField, 5), new AITarget<Object>(AIWorkerState.FARMER_PLANT, this::workAtField, 5), new AITarget<Object>(AIWorkerState.FARMER_HARVEST, this::workAtField, 5));
        this.worker.setCanPickUpLoot(true);
    }

    @Override
    public Class<BuildingFarmer> getExpectedBuildingClass() {
        return BuildingFarmer.class;
    }

    @Override
    protected boolean wantInventoryDumped() {
        if (this.shouldDumpInventory || ((JobFarmer)this.job).getActionsDone() >= this.getActionRewardForCraftingSuccess()) {
            this.shouldDumpInventory = false;
            return true;
        }
        return super.wantInventoryDumped();
    }

    @Override
    protected int getActionRewardForCraftingSuccess() {
        return 64;
    }

    @Override
    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata(this.getState() == AIWorkerState.FARMER_PLANT || this.getState() == AIWorkerState.FARMER_HARVEST ? "working" : "");
    }

    @Override
    protected IAIState decide() {
        IAIState state = super.decide();
        if (state == AIWorkerState.IDLE) {
            return AIWorkerState.PREPARING;
        }
        return state;
    }

    @Override
    public boolean hasWorkToDo() {
        return true;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 64;
    }

    @NotNull
    private IAIState prepareForFarming() {
        int amountOfCompostInInv;
        int amountOfCompostInBuilding;
        this.worker.getCitizenData().setJobStatus(JobStatus.IDLE);
        if (this.building == null || ((BuildingFarmer)this.building).getBuildingLevel() < 1) {
            this.worker.getCitizenData().setJobStatus(JobStatus.STUCK);
            return AIWorkerState.PREPARING;
        }
        BuildingExtensionsModule module = (BuildingExtensionsModule)((BuildingFarmer)this.building).getFirstModuleOccurance(BuildingExtensionsModule.class);
        if (module.getOwnedExtensions().size() == ((BuildingFarmer)this.building).getMaxBuildingLevel()) {
            AdvancementUtils.TriggerAdvancementPlayersForColony(((BuildingFarmer)this.building).getColony(), ((MaxFieldsTrigger)((Object)AdvancementTriggers.MAX_FIELDS.get()))::trigger);
        }
        if ((amountOfCompostInBuilding = InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, this::isCompost, 1)) + (amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost)) <= 0) {
            if (((BuildingFarmer)this.building).requestFertilizer() && !((BuildingFarmer)this.building).hasWorkerOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(StackList.class))) {
                ArrayList<ItemStack> compostAbleItems = new ArrayList<ItemStack>();
                compostAbleItems.add(new ItemStack((ItemLike)ModItems.compost, 1));
                compostAbleItems.add(new ItemStack((ItemLike)Items.BONE_MEAL, 1));
                this.worker.getCitizenData().createRequestAsync(new StackList(compostAbleItems, "com.minecolonies.coremod.request.fertilizer", 64, 1));
            }
        } else if (amountOfCompostInInv <= 0 && amountOfCompostInBuilding > 0) {
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(this::isCompost, 64);
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        if (module.hasNoExtensions()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"entity.farmer.nofreefields", (Object[])new Object[0]), ChatPriority.BLOCKING));
            }
            this.worker.getCitizenData().setJobStatus(JobStatus.STUCK);
            return AIWorkerState.IDLE;
        }
        IBuildingExtension fieldToWork = module.getBuildingExtensionToWorkOn();
        if (fieldToWork instanceof FarmField) {
            FarmField farmField = (FarmField)fieldToWork;
            if (this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.hoe.get())) {
                this.worker.getCitizenData().setJobStatus(JobStatus.STUCK);
                return AIWorkerState.PREPARING;
            }
            this.worker.getCitizenData().setVisibleStatus(FARMING_ICON);
            this.worker.getCitizenData().setJobStatus(JobStatus.WORKING);
            if (farmField.getFieldStage() == FarmField.Stage.PLANTED && this.checkIfShouldExecute(farmField, pos -> this.findHarvestableSurface((BlockPos)pos) != null)) {
                return AIWorkerState.FARMER_HARVEST;
            }
            if (farmField.getFieldStage() == FarmField.Stage.HOED) {
                return this.canGoPlanting(farmField);
            }
            if (farmField.getFieldStage() == FarmField.Stage.EMPTY && this.checkIfShouldExecute(farmField, pos -> this.findHoeableSurface((BlockPos)pos, farmField) != null)) {
                return AIWorkerState.FARMER_HOE;
            }
            farmField.nextState();
            if (++this.skippedState >= 4) {
                this.skippedState = 0;
                this.didWork = true;
                module.resetCurrentExtension();
            }
            return AIWorkerState.IDLE;
        }
        if (fieldToWork != null) {
            Log.getLogger().warn("Farmer found non-FarmField extension: {}", fieldToWork.getClass());
        }
        return AIWorkerState.IDLE;
    }

    private boolean isCompost(ItemStack itemStack) {
        if (itemStack.getItem() == ModItems.compost) {
            return true;
        }
        return itemStack.getItem() == Items.BONE_MEAL;
    }

    private boolean checkIfShouldExecute(@NotNull FarmField farmField, @NotNull Predicate<BlockPos> predicate) {
        BlockPos position;
        do {
            ((BuildingFarmer)this.building).setWorkingOffset(this.nextValidCell(farmField));
            if (((BuildingFarmer)this.building).getWorkingOffset() != null) continue;
            return false;
        } while (!predicate.test(position = farmField.getPosition().below().south(((BuildingFarmer)this.building).getWorkingOffset().getZ()).east(((BuildingFarmer)this.building).getWorkingOffset().getX())));
        return true;
    }

    private IAIState canGoPlanting(@NotNull FarmField farmField) {
        if (farmField.getSeed() == null) {
            return AIWorkerState.PREPARING;
        }
        ItemStack seeds = farmField.getSeed();
        int slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(seeds.getItem());
        if (slot != -1) {
            return AIWorkerState.FARMER_PLANT;
        }
        if (!this.walkToBuilding()) {
            return AIWorkerState.PREPARING;
        }
        seeds.setCount(seeds.getMaxStackSize());
        if (!this.checkIfRequestForItemExistOrCreateAsync(seeds, seeds.getMaxStackSize(), 1)) {
            farmField.nextState();
        }
        return AIWorkerState.PREPARING;
    }

    private BlockPos findHoeableSurface(@NotNull BlockPos position, @NotNull FarmField farmField) {
        if ((position = this.getSurfacePos(position)) == null) {
            return null;
        }
        BlockState blockState = this.world.getBlockState(position);
        if (farmField.isNoPartOfField((Level)this.world, position) || this.world.getBlockState(position.above()).getBlock() instanceof CropBlock || this.world.getBlockState(position.above()).getBlock() instanceof BlockScarecrow || !blockState.is(BlockTags.DIRT) && !(blockState.getBlock() instanceof MinecoloniesFarmland) && !(blockState.getBlock() instanceof FarmBlock) || this.isRightFarmLandForCrop(farmField, blockState) || this.world.getBlockState(position.above()).getBlock() instanceof MinecoloniesCropBlock) {
            return null;
        }
        BlockState aboveState = this.world.getBlockState(position.above());
        if (aboveState.canBeReplaced() && !(aboveState.getBlock() instanceof MinecoloniesCropBlock)) {
            this.world.destroyBlock(position.above(), true);
        }
        if (!this.isRightFarmLandForCrop(farmField, blockState)) {
            return position;
        }
        BlockHitResult blockHitResult = new BlockHitResult(Vec3.ZERO, Direction.UP, position, false);
        UseOnContext useOnContext = new UseOnContext((Level)this.world, null, InteractionHand.MAIN_HAND, this.getInventory().getStackInSlot(InventoryUtils.getFirstSlotOfItemHandlerContainingEquipment((IItemHandler)this.getInventory(), (EquipmentTypeEntry)ModEquipmentTypes.hoe.get(), 0, ((BuildingFarmer)this.building).getMaxEquipmentLevel())), blockHitResult);
        BlockState toolModifiedState = blockState.getToolModifiedState(useOnContext, ItemAbilities.HOE_TILL, true);
        if (toolModifiedState == null || !toolModifiedState.is(Blocks.FARMLAND)) {
            return null;
        }
        return position;
    }

    private BlockPos getSurfacePos(BlockPos position) {
        return this.getSurfacePos(position, 0);
    }

    private BlockPos getSurfacePos(BlockPos position, Integer depth) {
        if (Math.abs(depth) > 5 || !WorldUtil.isBlockLoaded((LevelAccessor)this.world, position)) {
            return null;
        }
        BlockState curBlockState = this.world.getBlockState(position);
        @Nullable Block curBlock = curBlockState.getBlock();
        if (curBlockState.isSolid() && !(curBlock instanceof PumpkinBlock) && curBlock != Blocks.MELON && !(curBlock instanceof WebBlock) || curBlockState.liquid()) {
            if (depth < 0) {
                return position;
            }
            return this.getSurfacePos(position.above(), depth + 1);
        }
        if (depth > 0) {
            return position.below();
        }
        return this.getSurfacePos(position.below(), depth - 1);
    }

    protected BlockPos nextValidCell(FarmField farmField) {
        int x;
        int z;
        if (((BuildingFarmer)this.building).getWorkingOffset() == null) {
            ((BuildingFarmer)this.building).setCell(-1);
        }
        do {
            if (((BuildingFarmer)this.building).setCell(((BuildingFarmer)this.building).getCell() + 1) == this.getLargestCell(farmField)) {
                return null;
            }
            int ring = (int)Math.floor((Math.sqrt((double)((BuildingFarmer)this.building).getCell() + 1.0) + 1.0) / 2.0);
            int ringCell = ((BuildingFarmer)this.building).getCell() - (int)(4.0 * Math.pow((double)ring - 1.0, 2.0) + (double)(4 * (ring - 1)));
            Direction facing = Direction.from2DDataValue((int)Math.floorDiv(ringCell, 2 * ring));
            if (facing.getAxis() == Direction.Axis.Z) {
                x = (facing == Direction.NORTH ? -1 : 1) * (ring - ringCell % (2 * ring));
                z = (facing == Direction.NORTH ? -1 : 1) * ring;
                continue;
            }
            x = (facing == Direction.WEST ? -1 : 1) * ring;
            z = (facing == Direction.EAST ? -1 : 1) * (ring - ringCell % (2 * ring));
        } while (-z > farmField.getRadius(Direction.NORTH) || x > farmField.getRadius(Direction.EAST) || z > farmField.getRadius(Direction.SOUTH) || -x > farmField.getRadius(Direction.WEST));
        return new BlockPos(x, 0, z);
    }

    protected int getLargestCell(FarmField farmField) {
        return (int)Math.pow((double)farmField.getMaxRadius() * 2.0 + 1.0, 2.0);
    }

    private IAIState workAtField() {
        BuildingExtensionsModule module = (BuildingExtensionsModule)((BuildingFarmer)this.building).getFirstModuleOccurance(BuildingExtensionsModule.class);
        IBuildingExtension field = module.getCurrentExtension();
        this.worker.getCitizenData().setVisibleStatus(FARMING_ICON);
        if (field instanceof FarmField) {
            FarmField farmField = (FarmField)field;
            if (((BuildingFarmer)this.building).getWorkingOffset() != null) {
                BlockPos position = farmField.getPosition().below().south(((BuildingFarmer)this.building).getWorkingOffset().getZ()).east(((BuildingFarmer)this.building).getWorkingOffset().getX());
                if (!this.walkToSafePos(position.above())) {
                    return this.getState();
                }
                switch ((AIWorkerState)this.getState()) {
                    case FARMER_HOE: {
                        if (this.hoeIfAble(position, farmField)) break;
                        this.didWork = true;
                        return this.getState();
                    }
                    case FARMER_PLANT: {
                        if (this.tryToPlant(farmField, position)) break;
                        this.didWork = true;
                        return AIWorkerState.PREPARING;
                    }
                    case FARMER_HARVEST: {
                        if (this.harvestIfAble(position)) break;
                        this.didWork = true;
                        return this.getState();
                    }
                    default: {
                        return AIWorkerState.PREPARING;
                    }
                }
                ((BuildingFarmer)this.building).setPrevPos(position);
                this.setDelay(this.getLevelDelay());
            }
            ((BuildingFarmer)this.building).setWorkingOffset(this.nextValidCell(farmField));
            if (((BuildingFarmer)this.building).getWorkingOffset() == null) {
                this.shouldDumpInventory = true;
                farmField.nextState();
                module.markDirty();
                if (this.didWork || ++this.skippedState >= 4) {
                    module.resetCurrentExtension();
                    this.skippedState = 0;
                }
                this.didWork = false;
                ((BuildingFarmer)this.building).setPrevPos(null);
                return AIWorkerState.IDLE;
            }
        } else {
            return AIWorkerState.IDLE;
        }
        return this.getState();
    }

    private boolean hoeIfAble(BlockPos position, FarmField farmField) {
        if ((position = this.findHoeableSurface(position, farmField)) != null && !this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.hoe.get())) {
            if (this.mineBlock(position.above())) {
                this.equipHoe();
                this.worker.swing(this.worker.getUsedItemHand());
                this.createCorrectFarmlandForSeed(farmField.getSeed(), position);
                CitizenItemUtils.damageItemInHand(this.worker, InteractionHand.MAIN_HAND, 1);
                this.worker.decreaseSaturationForContinuousAction();
                this.worker.getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().increment("land_tilled", this.worker.getCitizenColonyHandler().getColonyOrRegister().getDay());
                return true;
            }
            return false;
        }
        return true;
    }

    private void createCorrectFarmlandForSeed(ItemStack seed, BlockPos pos) {
        Item item = seed.getItem();
        if (item instanceof ItemCrop) {
            ItemCrop itemCrop = (ItemCrop)item;
            this.world.setBlockAndUpdate(pos, ((MinecoloniesCropBlock)itemCrop.getBlock()).getPreferredFarmland().defaultBlockState());
        } else {
            this.world.setBlockAndUpdate(pos, Blocks.FARMLAND.defaultBlockState());
        }
    }

    private boolean isRightFarmLandForCrop(FarmField farmField, BlockState blockState) {
        Item item = farmField.getSeed().getItem();
        if (item instanceof ItemCrop) {
            ItemCrop itemCrop = (ItemCrop)item;
            return blockState.getBlock() == ((MinecoloniesCropBlock)itemCrop.getBlock()).getPreferredFarmland();
        }
        return blockState.getBlock() instanceof FarmBlock;
    }

    private boolean harvestIfAble(BlockPos position) {
        if ((position = this.findHarvestableSurface(position)) != null) {
            if (this.mineBlock(position.above())) {
                this.worker.getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().increment("crops_harvested", this.worker.getCitizenColonyHandler().getColonyOrRegister().getDay());
                this.worker.getCitizenExperienceHandler().addExperience(0.5);
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public void onBlockDropReception(List<ItemStack> blockDrops) {
        super.onBlockDropReception(blockDrops);
        for (ItemStack stack : blockDrops) {
            ((BuildingFarmer)this.building).getModule(BuildingModules.STATS_MODULE).incrementBy("item_obtained;" + stack.getItem().getDescriptionId(), stack.getCount());
        }
    }

    protected int getLevelDelay() {
        return (int)Math.max(1.0, 40.0 - (double)this.getPrimarySkillLevel() / 2.0 * 1.0);
    }

    private boolean tryToPlant(FarmField farmField, BlockPos position) {
        return (position = this.findPlantableSurface(position, farmField)) == null || this.plantCrop(farmField.getSeed(), position);
    }

    private void equipHoe() {
        CitizenItemUtils.setHeldItem(this.worker, InteractionHand.MAIN_HAND, this.getHoeSlot());
    }

    private BlockPos findPlantableSurface(@NotNull BlockPos position, @NotNull FarmField farmField) {
        if ((position = this.getSurfacePos(position)) == null || farmField.isNoPartOfField((Level)this.world, position) || this.world.getBlockState(position.above()).getBlock() instanceof CropBlock || this.world.getBlockState(position.above()).getBlock() instanceof StemBlock || this.world.getBlockState(position).getBlock() instanceof BlockScarecrow || !this.isRightFarmLandForCrop(farmField, this.world.getBlockState(position)) || this.world.getBlockState(position.above()).getBlock() instanceof MinecoloniesCropBlock) {
            return null;
        }
        return position;
    }

    private boolean plantCrop(ItemStack item, @NotNull BlockPos position) {
        BlockItem blockItem;
        if (item == null || item.isEmpty()) {
            return false;
        }
        int slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(item.getItem());
        if (slot == -1) {
            return false;
        }
        Item item2 = item.getItem();
        if (item2 instanceof BlockItem && ((blockItem = (BlockItem)item2).getBlock() instanceof CropBlock || blockItem.getBlock() instanceof StemBlock || blockItem.getBlock() instanceof MinecoloniesCropBlock) && blockItem.getBlock().defaultBlockState().canSurvive((LevelReader)this.worker.level(), position.above())) {
            @NotNull Item seed = item.getItem();
            if (!(seed != Items.MELON_SEEDS && seed != Items.PUMPKIN_SEEDS || ((BuildingFarmer)this.building).getPrevPos() == null || this.world.isEmptyBlock(((BuildingFarmer)this.building).getPrevPos().above()))) {
                return true;
            }
            this.world.setBlockAndUpdate(position.above(), ((BlockItem)item.getItem()).getBlock().defaultBlockState());
            this.worker.decreaseSaturationForContinuousAction();
            this.getInventory().extractItem(slot, 1, false);
        }
        return true;
    }

    private BlockPos findHarvestableSurface(@NotNull BlockPos position) {
        if ((position = this.getSurfacePos(position)) == null) {
            return null;
        }
        BlockState state = this.world.getBlockState(position.above());
        Block block = state.getBlock();
        if (block == Blocks.PUMPKIN || block == Blocks.MELON) {
            return position;
        }
        if (block instanceof CropBlock) {
            @NotNull CropBlock crop = (CropBlock)block;
            if (crop.isMaxAge(state)) {
                return position;
            }
            int amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost);
            if (amountOfCompostInInv == 0) {
                return null;
            }
            if (InventoryUtils.shrinkItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost)) {
                new CompostParticleMessage(position.above()).sendToTargetPoint(this.world, null, position.getX(), position.getY(), position.getZ(), 16.0);
                crop.growCrops((Level)this.world, position.above(), state);
                state = this.world.getBlockState(position.above());
                block = state.getBlock();
                if (block instanceof CropBlock) {
                    crop = (CropBlock)block;
                } else {
                    return null;
                }
            }
            return crop.isMaxAge(state) ? position : null;
        }
        if (block instanceof MinecoloniesCropBlock) {
            MinecoloniesCropBlock minecoloniesCrop = (MinecoloniesCropBlock)block;
            if (minecoloniesCrop.isMaxAge(state)) {
                return position;
            }
            int amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost);
            if (amountOfCompostInInv == 0) {
                return null;
            }
            if (InventoryUtils.shrinkItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost)) {
                new CompostParticleMessage(position.above()).sendToTargetPoint(this.world, null, position.getX(), position.getY(), position.getZ(), 16.0);
                minecoloniesCrop.attemptGrow(state, this.world, position.above());
                state = this.world.getBlockState(position.above());
                block = state.getBlock();
                if (block instanceof MinecoloniesCropBlock) {
                    minecoloniesCrop = (MinecoloniesCropBlock)block;
                } else {
                    return null;
                }
            }
            return minecoloniesCrop.isMaxAge(state) ? position : null;
        }
        return null;
    }

    @Override
    protected List<ItemStack> increaseBlockDrops(List<ItemStack> drops) {
        double increaseCrops = this.worker.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FARMING);
        if (increaseCrops == 0.0) {
            return drops;
        }
        ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
        for (ItemStack stack : drops) {
            ItemStack drop = stack.copy();
            if (this.worker.getRandom().nextDouble() < increaseCrops) {
                drop.setCount(drop.getCount() * 2);
            }
            newDrops.add(drop);
        }
        return newDrops;
    }

    @Override
    public int getBreakSpeedLevel() {
        return this.getSecondarySkillLevel();
    }

    private int getHoeSlot() {
        return InventoryUtils.getFirstSlotOfItemHandlerContainingEquipment((IItemHandler)this.getInventory(), (EquipmentTypeEntry)ModEquipmentTypes.hoe.get(), 0, ((BuildingFarmer)this.building).getMaxEquipmentLevel());
    }

    @Nullable
    public AbstractEntityCitizen getCitizen() {
        return this.worker;
    }

    @Override
    public boolean canGoIdle() {
        if (((BuildingFarmer)this.building).getModule(BuildingModules.FARMER_FIELDS).getBuildingExtensionToWorkOn() == null) {
            return !super.hasWorkToDo();
        }
        return false;
    }
}

