/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.guard;

import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.other.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.entity.ai.combat.AttackMoveAI;
import com.minecolonies.core.entity.ai.combat.CombatUtils;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIGuard;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.other.CustomArrowEntity;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobCanSee;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveAwayFromLocation;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveToLocation;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.neoforge.items.IItemHandler;

public class RangerCombatAI
extends AttackMoveAI<EntityCitizen> {
    private static final VisibleCitizenStatus ARCHER_COMBAT = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/archer_combat.png"), "com.minecolonies.gui.visiblestatus.archer_combat");
    private final AbstractEntityAIGuard parentAI;
    private static final double COMBAT_SPEED = 1.0;
    private static final double ARROW_EXTRA_DAMAGE = 2.0;
    private static final int BOW_HOLDING_DELAY = 40;
    private static final int GUARD_BONUS_RANGE = 10;
    private static final int FLEE_CHANCE = 3;
    private final PathingOptions combatPathingOptions;

    public RangerCombatAI(EntityCitizen owner, ITickRateStateMachine stateMachine, AbstractEntityAIGuard parentAI) {
        super(owner, stateMachine);
        this.parentAI = parentAI;
        this.combatPathingOptions = new PathingOptions();
        this.combatPathingOptions.setEnterDoors(true);
        this.combatPathingOptions.setCanOpenDoors(true);
        this.combatPathingOptions.setCanSwim(true);
        this.combatPathingOptions.withOnPathCost(0.8);
        this.combatPathingOptions.withJumpCost(0.01);
        this.combatPathingOptions.withDropCost(1.5);
    }

    @Override
    public boolean canAttack() {
        int weaponSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingEquipment((IItemHandler)((EntityCitizen)this.user).getInventoryCitizen(), (EquipmentTypeEntry)ModEquipmentTypes.bow.get(), 0, ((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getMaxEquipmentLevel());
        if (weaponSlot != -1) {
            CitizenItemUtils.setHeldItem((AbstractEntityCitizen)this.user, InteractionHand.MAIN_HAND, weaponSlot);
            if (this.nextAttackTime - 40L >= ((EntityCitizen)this.user).level().getGameTime() && !((EntityCitizen)this.user).isUsingItem()) {
                ((EntityCitizen)this.user).startUsingItem(InteractionHand.MAIN_HAND);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean checkForTarget() {
        boolean validTarget = super.checkForTarget();
        if (!validTarget && ((EntityCitizen)this.user).isUsingItem()) {
            ((EntityCitizen)this.user).stopUsingItem();
        }
        return validTarget;
    }

    @Override
    protected void doAttack(LivingEntity target) {
        if (((EntityCitizen)this.user).distanceToSqr((Entity)target) < 7.0) {
            if (((EntityCitizen)this.user).getRandom().nextInt(3) == 0 && !((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getTask().equals("com.minecolonies.core.guard.setting.guard")) {
                EntityNavigationUtils.walkAwayFrom((AbstractFastMinecoloniesEntity)this.user, target.blockPosition(), (int)(this.getAttackDistance() / 2.0), this.getCombatMovementSpeed());
            }
        } else {
            ((EntityCitizen)this.user).getNavigation().stop();
        }
        ((EntityCitizen)this.user).getCitizenData().setVisibleStatus(ARCHER_COMBAT);
        ((EntityCitizen)this.user).swing(InteractionHand.MAIN_HAND);
        ((EntityCitizen)this.user).stopUsingItem();
        int amountOfArrows = 1;
        if (((EntityCitizen)this.user).getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.DOUBLE_ARROWS) > 0.0 && ((EntityCitizen)this.user).getRandom().nextDouble() < ((EntityCitizen)this.user).getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.DOUBLE_ARROWS)) {
            ++amountOfArrows;
        }
        for (int i = 0; i < amountOfArrows; ++i) {
            ItemStack bow;
            AbstractArrow arrow = CombatUtils.createArrowForShooter((LivingEntity)this.user);
            if (((EntityCitizen)this.user).getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARROW_PIERCE) > 0.0) {
                arrow.setPierceLevel((byte)2);
            }
            if ((bow = ((EntityCitizen)this.user).getItemInHand(InteractionHand.MAIN_HAND)).getEnchantmentLevel(Utils.getRegistryValue(Enchantments.FLAME, ((EntityCitizen)this.user).level())) > 0) {
                arrow.setRemainingFireTicks(100);
            }
            double damage = this.calculateDamage(arrow);
            arrow.setBaseDamage(damage);
            float chance = 15.0f / (float)(((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) + 1);
            CombatUtils.shootArrow(arrow, target, chance);
            ((EntityCitizen)this.user).playSound(SoundEvents.SKELETON_SHOOT, 1.0f, (float)SoundUtils.getRandomPitch(((EntityCitizen)this.user).getRandom()));
        }
        target.setLastHurtByMob((LivingEntity)this.user);
        CitizenItemUtils.damageItemInHand((AbstractEntityCitizen)this.user, InteractionHand.MAIN_HAND, 1);
        ((EntityCitizen)this.user).stopUsingItem();
        ((EntityCitizen)this.user).decreaseSaturationForContinuousAction();
    }

    @Override
    protected double getAttackDistance() {
        int attackDist = 10;
        if (((EntityCitizen)this.user).getCitizenData().getWorkBuilding() != null) {
            attackDist += ((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getBuildingLevelEquivalent();
        }
        if (((EntityCitizen)this.user).getCitizenData() != null) {
            attackDist = (int)((float)attackDist + (float)((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) / 50.0f * 15.0f);
        }
        attackDist = Math.min(attackDist, 24);
        if (this.target != null) {
            attackDist = (int)((double)attackDist + (((EntityCitizen)this.user).getY() - this.target.getY()));
        }
        if (((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getTask().equals("com.minecolonies.core.guard.setting.guard")) {
            attackDist += 10;
        }
        return attackDist;
    }

    @Override
    protected int getAttackDelay() {
        return 60;
    }

    private double calculateDamage(AbstractArrow arrow) {
        int slot;
        double damage = (double)((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Agility) / 5.0;
        ItemStack heldItem = ((EntityCitizen)this.user).getItemInHand(InteractionHand.MAIN_HAND);
        damage += (double)EnchantmentHelper.modifyDamage((ServerLevel)((ServerLevel)((EntityCitizen)this.user).level()), (ItemStack)heldItem, (Entity)this.target, (DamageSource)((EntityCitizen)this.user).level().damageSources().mobAttack((LivingEntity)this.user), (float)1.0f) / 2.5;
        damage += (double)heldItem.getEnchantmentLevel(Utils.getRegistryValue(Enchantments.POWER, ((EntityCitizen)this.user).level()));
        damage += ((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARCHER_DAMAGE);
        if (((EntityCitizen)this.user).getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARCHER_USE_ARROWS) > 0.0 && (slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)((EntityCitizen)this.user).getInventoryCitizen(), item -> item.getItem() instanceof ArrowItem)) != -1 && !ItemStackUtils.isEmpty(((EntityCitizen)this.user).getInventoryCitizen().extractItem(slot, 1, true))) {
            damage += 2.0;
            if (arrow instanceof CustomArrowEntity) {
                CustomArrowEntity customArrowEntity = (CustomArrowEntity)arrow;
                customArrowEntity.setOnHitCallback(entityRayTraceResult -> {
                    int arrowSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)((EntityCitizen)this.user).getInventoryCitizen(), item -> item.getItem() instanceof ArrowItem);
                    if (arrowSlot != -1) {
                        ((EntityCitizen)this.user).getInventoryCitizen().extractItem(arrowSlot, 1, false);
                    }
                    return true;
                });
            }
        }
        if ((double)((EntityCitizen)this.user).getHealth() <= (double)((EntityCitizen)this.user).getMaxHealth() * 0.2) {
            damage *= 2.0;
        }
        if (ColonyConstants.rand.nextDouble() > 1.0 / (1.0 + ((EntityCitizen)this.user).getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.GUARD_CRIT))) {
            damage *= 1.5;
        }
        return (2.0 + damage) * (Double)((ServerConfiguration)MineColonies.getConfig().getServer()).guardDamageMultiplier.get();
    }

    @Override
    protected PathResult moveInAttackPosition(LivingEntity target) {
        if ((double)BlockPosUtil.getDistanceSquared(target.blockPosition(), ((EntityCitizen)this.user).blockPosition()) <= 4.0) {
            PathJobMoveAwayFromLocation job = new PathJobMoveAwayFromLocation(((EntityCitizen)this.user).level(), PathfindingUtils.prepareStart(target), target.blockPosition(), 7, (int)((EntityCitizen)this.user).getAttribute(Attributes.FOLLOW_RANGE).getValue(), this.user);
            PathResult pathResult = ((MinecoloniesAdvancedPathNavigate)((EntityCitizen)this.user).getNavigation()).setPathJob(job, null, this.getCombatMovementSpeed(), true);
            job.setPathingOptions(this.combatPathingOptions);
            return pathResult;
        }
        if (BlockPosUtil.getDistance2D(target.blockPosition(), ((EntityCitizen)this.user).blockPosition()) >= 20L) {
            PathJobMoveToLocation job = new PathJobMoveToLocation(((EntityCitizen)this.user).level(), PathfindingUtils.prepareStart((LivingEntity)this.user), target.blockPosition(), 200, this.user);
            PathResult pathResult = ((MinecoloniesAdvancedPathNavigate)((EntityCitizen)this.user).getNavigation()).setPathJob(job, null, this.getCombatMovementSpeed(), true);
            job.setPathingOptions(this.combatPathingOptions);
            return pathResult;
        }
        PathJobCanSee job = new PathJobCanSee(this.user, target, ((EntityCitizen)this.user).level(), ((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getGuardPos((AbstractEntityCitizen)this.user), 40);
        PathResult pathResult = ((MinecoloniesAdvancedPathNavigate)((EntityCitizen)this.user).getNavigation()).setPathJob(job, null, this.getCombatMovementSpeed(), true);
        job.setPathingOptions(this.combatPathingOptions);
        return pathResult;
    }

    protected double getCombatMovementSpeed() {
        double levelAdjustment = (double)((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Agility) * 0.01;
        levelAdjustment += (double)(((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getBuildingLevelEquivalent() * 2 - 1) * 0.01;
        levelAdjustment = Math.min(levelAdjustment, 0.3);
        return 1.0 + levelAdjustment;
    }

    @Override
    protected boolean isAttackableTarget(LivingEntity entity) {
        return AbstractEntityAIGuard.isAttackableTarget((AbstractEntityCitizen)this.user, entity);
    }

    @Override
    protected boolean isWithinPersecutionDistance(LivingEntity target) {
        return this.parentAI.isWithinPersecutionDistance(target.blockPosition(), this.getAttackDistance());
    }

    @Override
    protected boolean skipSearch(LivingEntity entity) {
        EntityCitizen citizen;
        if (entity instanceof EntityCitizen && (citizen = (EntityCitizen)entity).getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && ((AbstractJobGuard)citizen.getCitizenJobHandler().getColonyJob()).isAsleep() && ((EntityCitizen)this.user).getSensing().hasLineOfSight((Entity)citizen)) {
            this.parentAI.setWakeCitizen(citizen);
            return true;
        }
        return false;
    }

    @Override
    protected void onTargetChange() {
        CombatUtils.notifyGuardsOfTarget((AbstractEntityCitizen)this.user, this.target, 1600);
    }

    @Override
    protected int getYSearchRange() {
        if (((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getTask().equals("com.minecolonies.core.guard.setting.guard")) {
            return 28;
        }
        return 3;
    }

    @Override
    protected void onTargetDied(LivingEntity entity) {
        this.parentAI.incrementActionsDoneAndDecSaturation();
        ((EntityCitizen)this.user).getCitizenExperienceHandler().addExperience(15.0);
        ((EntityCitizen)this.user).getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().increment("mobs_killed", ((EntityCitizen)this.user).getCitizenColonyHandler().getColonyOrRegister().getDay());
        ComponentContents componentContents = entity.getType().getDescription().getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            this.parentAI.building.getModule(BuildingModules.STATS_MODULE).increment("mob_killed;" + translatableContents.getKey());
        }
    }
}

