/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.debug.messages;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.debug.DebugPlayerManager;
import com.minecolonies.core.debug.messages.DebugOutputMessage;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class QueryCitizenAIHistoryMessage
extends AbstractColonyServerMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"debug_aihistory", QueryCitizenAIHistoryMessage::new);
    private int id;

    public QueryCitizenAIHistoryMessage(ICitizenDataView citizen) {
        super(TYPE, citizen.getColony());
        this.id = citizen.getId();
    }

    protected QueryCitizenAIHistoryMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.id = buf.readInt();
    }

    @Override
    protected void toBytes(RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.id);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
        if (player == null || !DebugPlayerManager.hasDebugEnabled((Player)player)) {
            return;
        }
        ICitizenData citizen = colony.getCitizenManager().getCivilian(this.id);
        if (citizen == null || !citizen.getEntity().isPresent()) {
            return;
        }
        AbstractEntityCitizen abstractEntityCitizen = citizen.getEntity().get();
        if (abstractEntityCitizen instanceof EntityCitizen) {
            EntityCitizen entityCitizen = (EntityCitizen)abstractEntityCitizen;
            MutableComponent message = Component.literal((String)"Citizen AI: ").append(entityCitizen.getCitizenAI().getHistory());
            if (entityCitizen.getCitizenJobHandler().getColonyJob() != null) {
                message.append((Component)Component.literal((String)"Job AI: ").append(entityCitizen.getCitizenJobHandler().getWorkAI().getStateAI().getHistory()));
            }
            new DebugOutputMessage((Component)message, true).sendToPlayer(player);
        }
    }
}

