/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.datalistener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.util.Log;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class StudyItemListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String KEY_ITEM = "item";
    private static final String KEY_SKILL_INCREASE_CHANCE = "skill_increase_chance";
    private static final String KEY_BREAK_CHANCE = "break_chance";
    private static Map<ResourceLocation, StudyItem> ACTIVE_LIST = new HashMap<ResourceLocation, StudyItem>();

    public StudyItemListener() {
        super(GSON, "study_items");
    }

    public static Map<ResourceLocation, StudyItem> getAllStudyItems() {
        return ACTIVE_LIST;
    }

    public static boolean isStudyItem(ItemStack stack) {
        return ACTIVE_LIST.containsKey(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()));
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> jsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        HashMap<ResourceLocation, StudyItem> newItems = new HashMap<ResourceLocation, StudyItem>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonElementMap.entrySet()) {
            if (!entry.getValue().isJsonObject()) {
                return;
            }
            JsonObject object = entry.getValue().getAsJsonObject();
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)object, (String)KEY_ITEM)));
            int skillIncreaseChance = this.percentage(object, KEY_SKILL_INCREASE_CHANCE);
            int breakChance = this.percentage(object, KEY_BREAK_CHANCE);
            newItems.put(entry.getKey(), new StudyItem(item, skillIncreaseChance, breakChance));
        }
        ACTIVE_LIST = Collections.unmodifiableMap(newItems);
    }

    private int percentage(JsonObject object, String field) {
        int clamped;
        int raw = GsonHelper.getAsInt((JsonObject)object, (String)field, (int)0);
        if (raw != (clamped = Mth.clamp((int)raw, (int)0, (int)100))) {
            Log.getLogger().warn("Parsing study item for Library contains a problem. Expected value for {} exceeded the range of [0,100], actual values was {}. Value was automatically clamped to {}.", (Object)field, (Object)raw, (Object)clamped);
        }
        return clamped;
    }

    public record StudyItem(Item item, int skillIncreaseChance, int breakChance) {
    }
}

