/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.compatibility.journeymap;

import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.IJobRegistry;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesRaider;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.compatibility.journeymap.ColonyBorderMapping;
import com.minecolonies.core.compatibility.journeymap.ColonyDeathpoints;
import com.minecolonies.core.compatibility.journeymap.EventListener;
import com.minecolonies.core.compatibility.journeymap.Journeymap;
import com.minecolonies.core.compatibility.journeymap.JourneymapOptions;
import com.minecolonies.core.entity.visitor.VisitorCitizen;
import java.util.Arrays;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.IClientPlugin;
import journeymap.api.v2.client.JourneyMapPlugin;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.entity.WrappedEntity;
import journeymap.api.v2.client.event.EntityRadarUpdateEvent;
import journeymap.api.v2.client.event.MappingEvent;
import journeymap.api.v2.client.event.RegistryEvent;
import journeymap.api.v2.common.event.ClientEventRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@JourneyMapPlugin(apiVersion="2.0.0-SNAPSHOT")
public class JourneymapPlugin
implements IClientPlugin {
    private static final Style JOB_TOOLTIP = Style.EMPTY.withColor(ChatFormatting.YELLOW).withItalic(Boolean.valueOf(true));
    private Journeymap jmap;
    private EventListener listener;

    public void initialize(@NotNull IClientAPI api) {
        this.jmap = new Journeymap(api);
        this.listener = new EventListener(this.jmap);
        ClientEventRegistry.MAPPING_EVENT.subscribe("minecolonies", this::onMappingEvent);
        ClientEventRegistry.OPTIONS_REGISTRY_EVENT_EVENT.subscribe("minecolonies", this::onOptionsRegistryEvent);
        ClientEventRegistry.INFO_SLOT_REGISTRY_EVENT_EVENT.subscribe("minecolonies", this::onInfoRegistryEvent);
        ClientEventRegistry.ENTITY_RADAR_UPDATE_EVENT.subscribe("minecolonies", this::onEntityRadarUpdateEvent);
    }

    public String getModId() {
        return "minecolonies";
    }

    private void onMappingEvent(MappingEvent event) {
        switch (event.getStage()) {
            case MAPPING_STARTED: {
                ColonyBorderMapping.load(this.jmap, (ResourceKey<Level>)event.dimension);
                break;
            }
            case MAPPING_STOPPED: {
                ColonyBorderMapping.unload(this.jmap, (ResourceKey<Level>)event.dimension);
                ColonyDeathpoints.unload(this.jmap, (ResourceKey<Level>)event.dimension);
            }
        }
    }

    private void onOptionsRegistryEvent(RegistryEvent.OptionsRegistryEvent event) {
        this.jmap.setOptions(new JourneymapOptions());
    }

    private void onInfoRegistryEvent(RegistryEvent.InfoSlotRegistryEvent event) {
        event.register("minecolonies", "com.minecolonies.coremod.journeymap.currentcolony", 2500L, ColonyBorderMapping::getCurrentColony);
    }

    private void onEntityRadarUpdateEvent(EntityRadarUpdateEvent event) {
        WrappedEntity wrapper = event.getWrappedEntity();
        Entity entity = (Entity)wrapper.getEntityRef().get();
        if (entity instanceof AbstractEntityCitizen) {
            boolean showName;
            Component name;
            MutableComponent jobName;
            boolean isVisitor = entity instanceof VisitorCitizen;
            if (isVisitor) {
                if (!JourneymapOptions.getShowVisitors(this.jmap.getOptions())) {
                    wrapper.setDisable(true);
                    return;
                }
                jobName = Component.translatableEscape((String)"com.minecolonies.coremod.journeymap.visitor", (Object[])new Object[0]);
            } else {
                IJob<?> job;
                String jobId = (String)entity.getEntityData().get(AbstractEntityCitizen.DATA_JOB);
                JobEntry jobEntry = jobId.isEmpty() ? null : (JobEntry)IJobRegistry.getInstance().get(ResourceLocation.parse((String)jobId));
                IJob<?> iJob = job = jobEntry == null ? null : jobEntry.produceJob(null);
                if (job instanceof AbstractJobGuard ? !JourneymapOptions.getShowGuards(this.jmap.getOptions()) : !JourneymapOptions.getShowCitizens(this.jmap.getOptions())) {
                    wrapper.setDisable(true);
                    return;
                }
                jobName = Component.translatableEscape((String)(jobEntry == null ? "com.minecolonies.coremod.journeymap.unemployed" : jobEntry.getTranslationKey()), (Object[])new Object[0]);
            }
            if (JourneymapOptions.getShowColonistTooltip(this.jmap.getOptions()) && (name = entity.getCustomName()) != null) {
                wrapper.setEntityToolTips(Arrays.asList(name, jobName.setStyle(JOB_TOOLTIP)));
            }
            boolean bl = showName = event.getActiveUiState().ui.equals((Object)Context.UI.Minimap) ? JourneymapOptions.getShowColonistNameMinimap(this.jmap.getOptions()) : JourneymapOptions.getShowColonistNameFullscreen(this.jmap.getOptions());
            if (!showName) {
                wrapper.setCustomName("");
            }
            if (!isVisitor && JourneymapOptions.getShowColonistTeamColour(this.jmap.getOptions())) {
                wrapper.setColor(entity.getTeamColor());
            }
        } else if (entity instanceof AbstractEntityMinecoloniesRaider) {
            JourneymapOptions.RaiderColor color = JourneymapOptions.getRaiderColor(this.jmap.getOptions());
            if (JourneymapOptions.RaiderColor.NONE.equals((Object)color)) {
                wrapper.setDisable(true);
            } else if (!JourneymapOptions.RaiderColor.HOSTILE.equals((Object)color)) {
                wrapper.setColor(color.getColor().getValue());
            }
        }
    }
}

