/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.compatibility.jei;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.core.blocks.MinecoloniesCropBlock;
import com.minecolonies.core.colony.crafting.CustomRecipeManager;
import com.minecolonies.core.colony.crafting.LootTableAnalyzer;
import com.minecolonies.core.compatibility.jei.JobBasedRecipeCategory;
import com.minecolonies.core.compatibility.jei.ModRecipeTypes;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public class CropRecipeCategory
implements IRecipeCategory<CropRecipe> {
    private final int WIDTH = 150;
    private final int HEIGHT = 54;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;
    private final IDrawable chanceSlot;

    public CropRecipeCategory(@NotNull IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(150, 54);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.DIAMOND_HOE));
        this.slot = guiHelper.getSlotDrawable();
        this.chanceSlot = guiHelper.createDrawable(new ResourceLocation("minecolonies", "textures/gui/jei_recipe.png"), 0, 121, 18, 18);
    }

    @NotNull
    public static List<CropRecipe> findRecipes() {
        HashSet<Block> sourceBlocks = new HashSet<Block>();
        for (MinecoloniesCropBlock crop : ModBlocks.getCrops()) {
            sourceBlocks.addAll(crop.getDroppedFrom());
        }
        return sourceBlocks.stream().map(CropRecipe::new).toList();
    }

    @NotNull
    public RecipeType<CropRecipe> getRecipeType() {
        return ModRecipeTypes.CROPS;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"com.minecolonies.coremod.jei.crops");
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull CropRecipe recipe, @NotNull IFocusGroup focuses) {
        int startX;
        EquipmentTypeEntry requiredTool = (EquipmentTypeEntry)ModEquipmentTypes.hoe.get();
        builder.addSlot(RecipeIngredientRole.CATALYST, 132, 0).setSlotName("tool").setBackground(this.chanceSlot, -1, -1).addItemStacks(MinecoloniesAPIProxy.getInstance().getColonyManager().getCompatibilityManager().getListOfAllItems().stream().filter(requiredTool::checkIsEquipment).sorted(Comparator.comparing(requiredTool::getMiningLevel)).toList());
        builder.addSlot(RecipeIngredientRole.INPUT, 0, 0).setSlotName("block").setBackground(this.slot, -1, -1).addItemStack(recipe.source().getCloneItemStack((LevelReader)Minecraft.getInstance().level, BlockPos.ZERO, recipe.source().defaultBlockState()));
        List<LootTableAnalyzer.LootDrop> drops = CustomRecipeManager.getInstance().getLootDrops((ResourceKey<LootTable>)recipe.source().getLootTable());
        int initialColumns = 114 / this.slot.getWidth();
        int rows = Math.max(1, (drops.size() + initialColumns - 1) / initialColumns);
        int columns = (drops.size() + rows - 1) / rows;
        int x = startX = (150 - columns * this.slot.getWidth()) / 2;
        int y = 54 - rows * this.slot.getHeight() + 1;
        int c = 0;
        for (LootTableAnalyzer.LootDrop drop : drops) {
            IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).setBackground(this.chanceSlot, -1, -1).addItemStacks(drop.getItemStacks());
            slot.addRichTooltipCallback((IRecipeSlotRichTooltipCallback)new JobBasedRecipeCategory.LootTableTooltipCallback(drop, (ResourceKey<LootTable>)recipe.source().getLootTable()));
            if (++c >= columns) {
                c = 0;
                x = startX;
                y += this.slot.getHeight();
                continue;
            }
            x += this.slot.getWidth();
        }
    }

    public record CropRecipe(@NotNull Block source) {
    }
}

