/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.generalcommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.commands.commandTypes.IMCOPCommand;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class CommandGetRanks
implements IMCOPCommand {
    private static final String COLONY_INFO_TEXT = "ID: %s  Name: %s  Rank: %s";
    private static final String COORDINATES_TEXT = "Coordinates: ";
    private static final String COORDINATES_XYZ = "x=%s y=%s z=%s";
    private static final String RANKS_COMMAND_SUGGESTED = "/minecolonies ranks ";
    private static final String PAGE_TOP_LEFT = "   ------------------ page ";
    private static final String PAGE_TOP_RIGHT = " ------------------";
    private static final String PAGE_TOP_MIDDLE = " of ";
    private static final String PREV_PAGE = " <- prev";
    private static final String NEXT_PAGE = "next -> ";
    private static final String PAGE_LINE = " ----------------";
    private static final String PAGE_LINE_DIVIDER = " | ";
    private static final int COLONIES_ON_PAGE = 10;
    private static final String START_PAGE_ARG = "startpage";

    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        return this.executeCommand(context, 1);
    }

    private int executeWithPage(CommandContext<CommandSourceStack> context) {
        if (this.checkPreCondition(context)) {
            return this.executeCommand(context, IntegerArgumentType.getInteger(context, (String)START_PAGE_ARG));
        }
        return 0;
    }

    private int executeCommand(CommandContext<CommandSourceStack> context, int startpage) {
        GameProfile profile;
        try {
            profile = GameProfileArgument.getGameProfiles(context, (String)"playername").stream().findFirst().orElse(null);
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
        if (((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(profile.getId()) == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.playernotfound", (Object[])new Object[]{profile.getName()}), true);
            return 0;
        }
        int page = startpage;
        List<IColony> colonies = IColonyManager.getInstance().getAllColonies().stream().filter(colony -> !colony.getPermissions().getRankNeutral().equals(colony.getPermissions().getRank(profile.getId()))).toList();
        int colonyCount = colonies.size();
        int halfPage = colonyCount % 10 == 0 ? 0 : 1;
        int pageCount = (int)(Math.floor((double)colonyCount / 10.0) + (double)halfPage);
        if (page < 1 || page > pageCount) {
            page = 1;
        }
        int pageStartIndex = 10 * (page - 1);
        int pageStopIndex = Math.min(10 * page, colonyCount);
        int prevPage = Math.max(1, page - 1);
        int nextPage = Math.min(page + 1, colonyCount / 10 + halfPage);
        List<Object> coloniesPage = pageStartIndex < 0 || pageStartIndex >= colonyCount ? new ArrayList() : colonies.subList(pageStartIndex, pageStopIndex);
        MutableComponent headerLine = Component.literal((String)(PAGE_TOP_LEFT + page + PAGE_TOP_MIDDLE + pageCount + PAGE_TOP_RIGHT));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandGetRanks.lambda$executeCommand$2((Component)headerLine), true);
        for (IColony iColony : coloniesPage) {
            Rank rank = iColony.getPermissions().getRank(profile.getId());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format(COLONY_INFO_TEXT, colony2.getID(), colony2.getName(), rank.getName())), true);
        }
        MutableComponent prevButton = Component.literal((String)PREV_PAGE).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.GOLD).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, RANKS_COMMAND_SUGGESTED + prevPage)));
        MutableComponent mutableComponent = Component.literal((String)NEXT_PAGE).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.GOLD).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, RANKS_COMMAND_SUGGESTED + nextPage)));
        MutableComponent beginLine = Component.literal((String)PAGE_LINE);
        MutableComponent endLine = Component.literal((String)PAGE_LINE);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandGetRanks.lambda$executeCommand$4(beginLine, (Component)prevButton, (Component)mutableComponent, endLine), true);
        return 1;
    }

    @Override
    public String getName() {
        return "ranks";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(((RequiredArgumentBuilder)IMCCommand.newArgument("playername", GameProfileArgument.gameProfile()).then(IMCCommand.newArgument(START_PAGE_ARG, IntegerArgumentType.integer()).executes(this::executeWithPage))).executes(this::checkPreConditionAndExecute));
    }

    private static /* synthetic */ Component lambda$executeCommand$4(MutableComponent beginLine, Component prevButton, Component nextButton, MutableComponent endLine) {
        return beginLine.append(prevButton).append((Component)Component.literal((String)PAGE_LINE_DIVIDER)).append(nextButton).append((Component)endLine);
    }

    private static /* synthetic */ Component lambda$executeCommand$2(Component headerLine) {
        return headerLine;
    }
}

