/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.commands.commandTypes.IMCOPCommand;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class CommandSetRank
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        GameProfile profile;
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).getLevel().dimension());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        try {
            profile = GameProfileArgument.getGameProfiles(context, (String)"playername").stream().findFirst().orElse(null);
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
        if (((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(profile.getId()) == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.playernotfound", (Object[])new Object[]{profile.getName()}), true);
            return 0;
        }
        String rankName = StringArgumentType.getString(context, (String)"rank");
        if (rankName != null && rankName.contains(" ")) {
            rankName = rankName.split(" ")[1];
        }
        Rank rankFound = null;
        for (Rank rank : colony.getPermissions().getRanks().values()) {
            if (rankName == null || rankName.isEmpty() || !rankName.toLowerCase(Locale.US).equals(rank.getName().toLowerCase(Locale.US))) continue;
            rankFound = rank;
            break;
        }
        if (rankFound == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Rank does not exist"), true);
            return 0;
        }
        colony.getPermissions().setPlayerRank(profile.getId(), rankFound, colony.getWorld());
        String finalRankName = rankName;
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Set player: " + profile.getName() + " to rank:" + finalRankName)), true);
        return 1;
    }

    @Override
    public String getName() {
        return "setRank";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("playername", GameProfileArgument.gameProfile()).then(IMCCommand.newArgument("rank", StringArgumentType.greedyString()).suggests((context, builder) -> {
            int colonyID = IntegerArgumentType.getInteger((CommandContext)context, (String)"colonyID");
            IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).getLevel().dimension());
            if (colony == null) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
                return null;
            }
            for (Rank rank : colony.getPermissions().getRanks().values()) {
                builder.suggest(rank.getId() + " " + rank.getName());
            }
            return builder.buildFuture();
        }).executes(this::checkPreConditionAndExecute))));
    }
}

