/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.commands.commandTypes.IMCOPCommand;
import com.minecolonies.core.util.ChunkDataHelper;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CommandClaimChunks
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        Entity sender = ((CommandSourceStack)context.getSource()).getEntity();
        if (!(sender instanceof Player)) {
            return 0;
        }
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        Colony colony = (Colony)IColonyManager.getInstance().getColonyByWorld(colonyID, sender.level());
        int range = IntegerArgumentType.getInteger(context, (String)"range");
        if (range > (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).maxColonySize.get()) {
            MessageUtils.format("com.minecolonies.command.claim.toolarge", colonyID).sendTo((Player)sender);
            return 0;
        }
        boolean add = BoolArgumentType.getBool(context, (String)"add");
        ChunkDataHelper.staticClaimInRange(colony, add, sender.blockPosition(), range, (ServerLevel)sender.level(), true);
        if (add) {
            MessageUtils.format("com.minecolonies.command.claim.success", new Object[0]).sendTo((Player)sender);
        } else {
            MessageUtils.format("com.minecolonies.command.claim.unclaim", new Object[0]).sendTo((Player)sender);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "claim";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("range", IntegerArgumentType.integer((int)0, (int)10)).then(IMCCommand.newArgument("add", BoolArgumentType.bool()).executes(this::checkPreConditionAndExecute))));
    }
}

