/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.workorders.view;

import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.core.colony.workorders.view.AbstractWorkOrderView;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class WorkOrderBuildingView
extends AbstractWorkOrderView {
    private String customBuildingName;
    private String customParentBuildingName;
    private String parentTranslationKey;

    @Override
    public Component getDisplayName() {
        MutableComponent nameComponent;
        MutableComponent buildingComponent;
        MutableComponent mutableComponent = buildingComponent = this.customBuildingName.isEmpty() ? Component.translatableEscape((String)this.getTranslationKey(), (Object[])new Object[0]) : Component.literal((String)this.customBuildingName);
        if (this.parentTranslationKey.isEmpty()) {
            nameComponent = buildingComponent;
        } else {
            MutableComponent parentComponent = this.customParentBuildingName.isEmpty() ? Component.translatableEscape((String)this.parentTranslationKey, (Object[])new Object[0]) : Component.literal((String)this.customParentBuildingName);
            nameComponent = Component.translatableEscape((String)"%s / %s", (Object[])new Object[]{parentComponent, buildingComponent});
        }
        return this.getOrderTypePrefix((Component)nameComponent);
    }

    private Component getOrderTypePrefix(Component nameComponent) {
        switch (this.getWorkOrderType()) {
            case BUILD: {
                return Component.translatableEscape((String)"com.minecolonies.coremod.action.builder.building", (Object[])new Object[]{nameComponent});
            }
            case UPGRADE: {
                return Component.translatableEscape((String)"com.minecolonies.coremod.action.builder.upgrading", (Object[])new Object[]{nameComponent, this.getCurrentLevel(), this.getTargetLevel()});
            }
            case REPAIR: {
                return Component.translatableEscape((String)"com.minecolonies.coremod.action.builder.repairing", (Object[])new Object[]{nameComponent});
            }
            case REMOVE: {
                return Component.translatableEscape((String)"com.minecolonies.coremod.action.builder.removing", (Object[])new Object[]{nameComponent});
            }
        }
        return nameComponent;
    }

    @Override
    public void deserialize(@NotNull RegistryFriendlyByteBuf buf) {
        super.deserialize(buf);
        this.customBuildingName = buf.readUtf(Short.MAX_VALUE);
        this.customParentBuildingName = buf.readUtf(Short.MAX_VALUE);
        this.parentTranslationKey = buf.readUtf(Short.MAX_VALUE);
    }

    @Override
    public boolean shouldShowIn(IBuildingView view) {
        return view instanceof ITownHallView || view instanceof BuildingBuilder.View;
    }
}

