/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.resolvers.core;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.INonExhaustiveDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.MinimumStack;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.AbstractDeliverymanRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Delivery;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.WarehouseRequestQueueModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.core.colony.requestsystem.resolvers.core.AbstractRequestResolver;
import com.minecolonies.core.tileentities.TileEntityWareHouse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWarehouseRequestResolver
extends AbstractRequestResolver<IDeliverable> {
    public AbstractWarehouseRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    public TypeToken<? extends IDeliverable> getRequestType() {
        return TypeConstants.DELIVERABLE;
    }

    protected abstract int getWarehouseInternalCount(BuildingWareHouse var1, IRequest<? extends IDeliverable> var2);

    @Override
    public boolean canResolveRequest(@NotNull IRequestManager manager, IRequest<? extends IDeliverable> requestToCheck) {
        if (requestToCheck.getRequester().getLocation().equals(this.getLocation())) {
            return false;
        }
        if (!manager.getColony().getWorld().isClientSide) {
            IBuilding otherWarehouse;
            Colony colony = (Colony)manager.getColony();
            IBuilding wareHouse = colony.getBuildingManager().getBuilding(this.getLocation().getInDimensionLocation());
            if (wareHouse == null) {
                return false;
            }
            if (requestToCheck.getRequest() instanceof MinimumStack && (otherWarehouse = colony.getBuildingManager().getBuilding(requestToCheck.getRequester().getLocation().getInDimensionLocation())).getBuildingType() == ModBuildings.wareHouse.get()) {
                return false;
            }
            if (!this.isRequestChainValid(manager, requestToCheck)) {
                return false;
            }
            int totalCount = this.getWarehouseInternalCount((BuildingWareHouse)wareHouse, requestToCheck);
            if (totalCount <= 0) {
                return false;
            }
            try {
                for (Map.Entry<BlockPos, IBuilding> building : colony.getBuildingManager().getBuildings().entrySet()) {
                    if (building.getValue().getBuildingType() != ModBuildings.wareHouse.get() || building.getValue() == wareHouse || (totalCount += this.getWarehouseInternalCount((BuildingWareHouse)building.getValue(), requestToCheck)) < requestToCheck.getRequest().getCount()) continue;
                    return true;
                }
                return totalCount >= requestToCheck.getRequest().getMinimumCount();
            }
            catch (Exception e) {
                Log.getLogger().error((Object)e);
            }
        }
        return false;
    }

    public boolean isRequestChainValid(@NotNull IRequestManager manager, IRequest<?> requestToCheck) {
        if (!requestToCheck.hasParent()) {
            return true;
        }
        IRequest<?> parentRequest = manager.getRequestForToken((IToken<?>)requestToCheck.getParent());
        if (parentRequest == null) {
            return true;
        }
        return this.isRequestChainValid(manager, parentRequest);
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
        if (manager.getColony().getWorld().isClientSide) {
            return Lists.newArrayList();
        }
        if (!(manager.getColony() instanceof Colony)) {
            return Lists.newArrayList();
        }
        Colony colony = (Colony)manager.getColony();
        TileEntityWareHouse wareHouse = (TileEntityWareHouse)colony.getBuildingManager().getBuilding(this.getLocation().getInDimensionLocation()).getTileEntity();
        if (wareHouse == null) {
            return Lists.newArrayList();
        }
        int totalRequested = request.getRequest().getCount();
        int totalAvailable = 0;
        if (request.getRequest() instanceof INonExhaustiveDeliverable) {
            totalAvailable -= ((INonExhaustiveDeliverable)request.getRequest()).getLeftOver();
        }
        List<Tuple<ItemStack, BlockPos>> inv = wareHouse.getMatchingItemStacksInWarehouse(itemStack -> ((IDeliverable)request.getRequest()).matches((ItemStack)itemStack));
        for (Tuple<ItemStack, BlockPos> stack : inv) {
            if (stack.getA().isEmpty()) continue;
            totalAvailable += stack.getA().getCount();
        }
        if (totalAvailable >= totalRequested || totalAvailable >= request.getRequest().getMinimumCount()) {
            return Lists.newArrayList();
        }
        if (totalAvailable < 0) {
            totalAvailable = 0;
        }
        int totalRemainingRequired = totalRequested - totalAvailable;
        return Lists.newArrayList((Object[])new IToken[]{manager.createRequest(this, request.getRequest().copyWithCount(totalRemainingRequired))});
    }

    @Override
    public void resolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
        manager.updateRequestState((IToken<?>)request.getId(), RequestState.RESOLVED);
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> completedRequest) {
        if (manager.getColony().getWorld().isClientSide) {
            return null;
        }
        Colony colony = (Colony)manager.getColony();
        TileEntityWareHouse wareHouse = (TileEntityWareHouse)colony.getBuildingManager().getBuilding(this.getLocation().getInDimensionLocation()).getTileEntity();
        if (wareHouse == null) {
            return null;
        }
        ArrayList deliveries = Lists.newArrayList();
        int remainingCount = completedRequest.getRequest().getCount();
        HashMap<ItemStorage, Integer> storages = new HashMap<ItemStorage, Integer>();
        int keep = completedRequest.getRequest() instanceof INonExhaustiveDeliverable ? ((INonExhaustiveDeliverable)completedRequest.getRequest()).getLeftOver() : 0;
        List<Tuple<ItemStack, BlockPos>> targetStacks = wareHouse.getMatchingItemStacksInWarehouse(itemStack -> ((IDeliverable)completedRequest.getRequest()).matches((ItemStack)itemStack));
        for (Tuple<ItemStack, BlockPos> tuple : targetStacks) {
            int kept;
            if (ItemStackUtils.isEmpty(tuple.getA())) continue;
            int leftOver = tuple.getA().getCount();
            if (keep > 0 && (kept = storages.getOrDefault(new ItemStorage(tuple.getA()), 0).intValue()) < keep) {
                if (leftOver + kept <= keep) {
                    storages.put(new ItemStorage(tuple.getA()), storages.getOrDefault(new ItemStorage(tuple.getA()), 0) + tuple.getA().getCount());
                    continue;
                }
                int toKeep = leftOver + kept - keep;
                leftOver -= toKeep;
                storages.put(new ItemStorage(tuple.getA()), storages.getOrDefault(new ItemStorage(tuple.getA()), 0) + toKeep);
            }
            int count = Math.min(remainingCount, leftOver);
            ItemStack matchingStack = tuple.getA().copy();
            matchingStack.setCount(count);
            completedRequest.addDelivery(matchingStack);
            ILocation itemStackLocation = manager.getFactoryController().getNewInstance(TypeConstants.ILOCATION, tuple.getB(), wareHouse.getLevel().dimension());
            Delivery delivery = new Delivery(itemStackLocation, completedRequest.getRequester().getLocation(), matchingStack, AbstractDeliverymanRequestable.getDefaultDeliveryPriority(true));
            IToken<?> requestToken = manager.createRequest(this, delivery);
            deliveries.add(manager.getRequestForToken(requestToken));
            if ((remainingCount -= count) > 0) continue;
            break;
        }
        return deliveries.isEmpty() ? null : deliveries;
    }

    @Override
    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    @NotNull
    public MutableComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        return Component.translatableEscape((String)"com.minecolonies.coremod.buildings.warehouse.name", (Object[])new Object[0]);
    }

    @Override
    public int getPriority() {
        return 150;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public int getSuitabilityMetric(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
        IWareHouse wareHouse = manager.getColony().getBuildingManager().getBuilding(this.getLocation().getInDimensionLocation(), IWareHouse.class);
        int distance = (int)BlockPosUtil.getDistance(request.getRequester().getLocation().getInDimensionLocation(), this.getLocation().getInDimensionLocation());
        if (wareHouse == null) {
            return distance;
        }
        return Math.max(distance / 10, 1) + ((WarehouseRequestQueueModule)wareHouse.getModule(BuildingModules.WAREHOUSE_REQUEST_QUEUE)).getMutableRequestList().size();
    }
}

