/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.managers;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.managers.interfaces.IVisitorManager;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.citizen.AbstractCivilianEntity;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.VisitorData;
import com.minecolonies.core.entity.visitor.VisitorCitizen;
import com.minecolonies.core.network.messages.client.colony.ColonyVisitorViewDataMessage;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class VisitorManager
implements IVisitorManager {
    public static String TAG_VISIT_MANAGER = "visitManager";
    public static String TAG_VISITORS = "visitors";
    public static String TAG_NEXTID = "nextID";
    private Map<Integer, IVisitorData> visitorMap = new HashMap<Integer, IVisitorData>();
    private boolean isDirty = false;
    private final IColony colony;
    private int nextVisitorID = -1;

    public VisitorManager(IColony colony) {
        this.colony = colony;
    }

    @Override
    public void registerCivilian(AbstractCivilianEntity visitor) {
        if (visitor.getCivilianID() == 0 || this.visitorMap.get(visitor.getCivilianID()) == null) {
            if (!visitor.isAddedToLevel()) {
                Log.getLogger().warn("Discarding entity not added to world, should be only called after:", (Throwable)new Exception());
            }
            visitor.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        ICitizenData data = this.visitorMap.get(visitor.getCivilianID());
        if (data == null || !visitor.getUUID().equals(data.getUUID())) {
            if (!visitor.isAddedToLevel()) {
                Log.getLogger().warn("Discarding entity not added to world, should be only called after:", (Throwable)new Exception());
            }
            visitor.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        Optional<AbstractEntityCitizen> existingCitizen = data.getEntity();
        if (!existingCitizen.isPresent()) {
            data.setEntity(visitor);
            visitor.setCivilianData(data);
            return;
        }
        if (existingCitizen.get() == visitor) {
            return;
        }
        if (visitor.isAlive()) {
            existingCitizen.get().remove(Entity.RemovalReason.DISCARDED);
            data.setEntity(visitor);
            visitor.setCivilianData(data);
            return;
        }
        if (!visitor.isAddedToLevel()) {
            Log.getLogger().warn("Discarding entity not added to world, should be only called after:", (Throwable)new Exception());
        }
        visitor.remove(Entity.RemovalReason.DISCARDED);
    }

    @Override
    public void unregisterCivilian(AbstractCivilianEntity entity) {
        ICitizenData data = this.visitorMap.get(entity.getCivilianID());
        if (data != null && data.getEntity().isPresent() && data.getEntity().get() == entity) {
            this.visitorMap.get(entity.getCivilianID()).setEntity(null);
        }
    }

    @Override
    public void read(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        if (compound.contains(TAG_VISIT_MANAGER)) {
            CompoundTag visitorManagerNBT = compound.getCompound(TAG_VISIT_MANAGER);
            ListTag citizenList = visitorManagerNBT.getList(TAG_VISITORS, 10);
            for (Tag citizen : citizenList) {
                IVisitorData data = VisitorData.loadVisitorFromNBT(this.colony, (CompoundTag)citizen, provider);
                this.visitorMap.put(data.getId(), data);
            }
            this.nextVisitorID = visitorManagerNBT.getInt(TAG_NEXTID);
        }
        this.markDirty();
    }

    @Override
    public void write(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compoundNBT) {
        CompoundTag visitorManagerNBT = new CompoundTag();
        ListTag citizenList = new ListTag();
        for (Map.Entry<Integer, IVisitorData> entry : this.visitorMap.entrySet()) {
            citizenList.add((Object)entry.getValue().serializeNBT(provider));
        }
        visitorManagerNBT.put(TAG_VISITORS, (Tag)citizenList);
        visitorManagerNBT.putInt(TAG_NEXTID, this.nextVisitorID);
        compoundNBT.put(TAG_VISIT_MANAGER, (Tag)visitorManagerNBT);
    }

    @Override
    public void sendPackets(@NotNull Set<ServerPlayer> closeSubscribers, @NotNull Set<ServerPlayer> newSubscribers) {
        boolean refresh;
        HashSet<IVisitorData> toSend = null;
        boolean bl = refresh = !newSubscribers.isEmpty() || this.isDirty;
        if (refresh) {
            toSend = new HashSet<IVisitorData>(this.visitorMap.values());
            for (IVisitorData data : this.visitorMap.values()) {
                data.clearDirty();
            }
            this.clearDirty();
        } else {
            for (IVisitorData data : this.visitorMap.values()) {
                if (data.isDirty()) {
                    if (toSend == null) {
                        toSend = new HashSet();
                    }
                    toSend.add(data);
                }
                data.clearDirty();
            }
        }
        if (toSend == null || toSend.isEmpty()) {
            return;
        }
        HashSet<ServerPlayer> players = new HashSet<ServerPlayer>(newSubscribers);
        players.addAll(closeSubscribers);
        new ColonyVisitorViewDataMessage(this.colony, toSend, refresh).sendToPlayer(players);
    }

    @Override
    @NotNull
    public Map<Integer, ICivilianData> getCivilianDataMap() {
        return Collections.unmodifiableMap(this.visitorMap);
    }

    public IVisitorData getCivilian(int citizenId) {
        return this.visitorMap.get(citizenId);
    }

    @Override
    public <T extends IVisitorData> T getVisitor(int citizenId) {
        return (T)this.visitorMap.get(citizenId);
    }

    public IVisitorData spawnOrCreateCivilian(ICivilianData data, Level world, BlockPos spawnPos, boolean force) {
        VisitorCitizen citizenEntity;
        if (!WorldUtil.isEntityBlockLoaded((LevelAccessor)world, spawnPos)) {
            return (IVisitorData)data;
        }
        if (data == null) {
            data = this.createAndRegisterCivilianData();
        }
        if ((citizenEntity = (VisitorCitizen)ModEntities.VISITOR.create(this.colony.getWorld())) == null) {
            return (IVisitorData)data;
        }
        citizenEntity.setUUID(data.getUUID());
        citizenEntity.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY() + 0.1, (double)spawnPos.getZ() + 0.5);
        world.addFreshEntity((Entity)citizenEntity);
        citizenEntity.setCitizenId(data.getId());
        citizenEntity.getCitizenColonyHandler().setColonyId(this.colony.getID());
        if (citizenEntity.isAddedToLevel()) {
            citizenEntity.getCitizenColonyHandler().registerWithColony(data.getColony().getID(), data.getId());
        }
        return (IVisitorData)data;
    }

    @Override
    public IVisitorData createAndRegisterCivilianData() {
        this.markDirty();
        VisitorData data = new VisitorData(this.nextVisitorID--, this.colony);
        data.initForNewCivilian();
        this.visitorMap.put(data.getId(), data);
        return data;
    }

    @Override
    public void removeCivilian(@NotNull ICivilianData citizen) {
        IVisitorData data = this.visitorMap.remove(citizen.getId());
        if (data != null && data.getEntity().isPresent()) {
            data.getEntity().get().remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public void markDirty() {
        this.isDirty = true;
    }

    @Override
    public void clearDirty() {
        this.isDirty = false;
    }

    @Override
    public void onColonyTick(IColony colony) {
        if (colony.hasTownHall()) {
            for (IVisitorData data : this.visitorMap.values()) {
                data.updateEntityIfNecessary();
            }
        }
    }
}

