/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.managers;

import com.google.common.collect.Maps;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.managers.interfaces.ITravellingManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.util.TeleportHelper;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class TravellingManager
implements ITravellingManager,
INBTSerializable<CompoundTag> {
    private final IColony colony;
    private final Map<Integer, TravelerData> travelerDataMap = Maps.newHashMap();

    public TravellingManager(IColony colony) {
        this.colony = colony;
    }

    @Override
    public boolean isTravelling(int citizenId) {
        return Optional.ofNullable(this.travelerDataMap.get(citizenId)).map(TravelerData::isTraveling).orElse(false);
    }

    @Override
    public Optional<BlockPos> getTravellingTargetFor(int citizenId) {
        return Optional.ofNullable(this.travelerDataMap.get(citizenId)).map(TravelerData::getTarget);
    }

    @Override
    public void startTravellingTo(int citizenId, BlockPos target, int travelTimeInTicks) {
        this.travelerDataMap.put(citizenId, new TravelerData(citizenId, target, travelTimeInTicks));
        this.colony.markDirty();
    }

    @Override
    public void finishTravellingFor(int citizenId) {
        if (this.travelerDataMap.containsKey(citizenId)) {
            this.travelerDataMap.remove(citizenId);
            this.colony.markDirty();
        }
    }

    @Override
    public void recallAllTravellingCitizens() {
        for (Integer citizenId : this.travelerDataMap.keySet()) {
            ICitizenData citizenData = this.colony.getCitizenManager().getCivilian(citizenId);
            BlockPos spawnHutPos = citizenData.getWorkBuilding() != null ? citizenData.getWorkBuilding().getPosition() : this.colony.getBuildingManager().getTownHall().getPosition();
            Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
            if (optionalEntityCitizen.isEmpty()) {
                Log.getLogger().warn(String.format("The traveller %d from colony #%d has returned very confused!", citizenData.getId(), this.colony.getID()));
                citizenData.setNextRespawnPosition(EntityUtils.getSpawnPoint(this.colony.getWorld(), spawnHutPos));
                citizenData.updateEntityIfNecessary();
                optionalEntityCitizen = citizenData.getEntity();
            }
            optionalEntityCitizen.ifPresent(abstractEntityCitizen -> TeleportHelper.teleportCitizen(abstractEntityCitizen, this.colony.getWorld(), spawnHutPos));
        }
        this.travelerDataMap.clear();
        this.colony.markDirty();
    }

    public boolean onTick() {
        this.travelerDataMap.values().forEach(TravelerData::onTick);
        return true;
    }

    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag data = new CompoundTag();
        ListTag output = new ListTag();
        for (TravelerData travelerData : this.travelerDataMap.values()) {
            CompoundTag serializeNBT = travelerData.serializeNBT(provider);
            output.add((Object)serializeNBT);
        }
        data.put("travelerData", (Tag)output);
        return data;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
        ListTag travelerData = nbt.getList("travelerData", 10);
        this.travelerDataMap.clear();
        for (Tag travelerDatum : travelerData) {
            if (!(travelerDatum instanceof CompoundTag)) continue;
            CompoundTag compoundTag = (CompoundTag)travelerDatum;
            TravelerData data = new TravelerData(provider, compoundTag);
            this.travelerDataMap.put(data.getCitizenId(), data);
        }
    }

    private static final class TravelerData
    implements INBTSerializable<CompoundTag> {
        private int citizenId = -1;
        private BlockPos target = BlockPos.ZERO;
        private int initialTravelTime = 0;
        private int remainingTravelTime = 0;

        public TravelerData(int citizenId, BlockPos target, int initialTravelTime) {
            this.citizenId = citizenId;
            this.target = target;
            this.initialTravelTime = initialTravelTime;
            this.remainingTravelTime = initialTravelTime;
        }

        public TravelerData(HolderLookup.Provider provider, CompoundTag tag) {
            this.deserializeNBT(provider, tag);
        }

        public void onTick() {
            if (this.remainingTravelTime > 0) {
                this.remainingTravelTime -= 20;
                this.remainingTravelTime = Math.max(0, this.remainingTravelTime);
            }
        }

        public boolean hasReachedTarget() {
            return this.remainingTravelTime == 0;
        }

        public double getTravelPercentage() {
            return (double)this.remainingTravelTime * 100.0 / (double)this.initialTravelTime;
        }

        public int getCitizenId() {
            return this.citizenId;
        }

        public BlockPos getTarget() {
            return this.target;
        }

        public int getInitialTravelTime() {
            return this.initialTravelTime;
        }

        public int getRemainingTravelTime() {
            return this.remainingTravelTime;
        }

        public boolean isTraveling() {
            return !this.hasReachedTarget();
        }

        public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            CompoundTag data = new CompoundTag();
            data.putInt("citizen", this.citizenId);
            data.put("target", NbtUtils.writeBlockPos((BlockPos)this.target));
            data.putInt("initialTravelTime", this.initialTravelTime);
            data.putInt("remainingTravelTime", this.remainingTravelTime);
            return data;
        }

        public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            this.citizenId = nbt.getInt("citizen");
            this.target = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"target").orElse(BlockPos.ZERO);
            this.initialTravelTime = nbt.getInt("initialTravelTime");
            this.remainingTravelTime = nbt.getInt("remainingTravelTime");
        }
    }
}

