/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.jobs;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.core.colony.jobs.AbstractJobCrafter;
import com.minecolonies.core.entity.ai.workers.production.EntityAIWorkNether;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class JobNetherWorker
extends AbstractJobCrafter<EntityAIWorkNether, JobNetherWorker> {
    private boolean citizenInNether = false;
    private Queue<ItemStack> craftedResults = new LinkedList<ItemStack>();
    private Queue<ItemStack> processedResults = new LinkedList<ItemStack>();
    private final String TAG_IN_NETHER = "inNether";
    private final String TAG_CRAFTED = "craftedResults";
    private final String TAG_PROCESSED = "processedResults";

    public JobNetherWorker(ICitizenData entity) {
        super(entity);
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        @NotNull ListTag craftedList = new ListTag();
        this.craftedResults.forEach(item -> craftedList.add((Object)item.saveOptional(provider)));
        compound.put("craftedResults", (Tag)craftedList);
        @NotNull ListTag processedList = new ListTag();
        this.processedResults.forEach(item -> processedList.add((Object)item.saveOptional(provider)));
        compound.put("processedResults", (Tag)processedList);
        compound.putBoolean("inNether", this.citizenInNether);
        return compound;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        ListTag craftedList = compound.getList("craftedResults", 10);
        for (int i = 0; i < craftedList.size(); ++i) {
            CompoundTag itemCompound = craftedList.getCompound(i);
            this.craftedResults.add(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemCompound));
        }
        ListTag processedList = compound.getList("processedResults", 10);
        for (int i = 0; i < processedList.size(); ++i) {
            CompoundTag itemCompound = processedList.getCompound(i);
            this.processedResults.add(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemCompound));
        }
        if (compound.contains("inNether")) {
            this.citizenInNether = compound.getBoolean("inNether");
        }
    }

    @Override
    public EntityAIWorkNether generateAI() {
        return new EntityAIWorkNether(this);
    }

    @Override
    @NotNull
    public ResourceLocation getModel() {
        return ModModelTypes.NETHERWORKER_ID;
    }

    @Override
    public double getDiseaseModifier() {
        if (this.getCitizen().getEntity().isPresent() && this.getCitizen().getEntity().get().isInvisible()) {
            return 0.0;
        }
        return super.getDiseaseModifier();
    }

    @Override
    public int getIdleSeverity(boolean isDemand) {
        if (isDemand) {
            return super.getIdleSeverity(isDemand);
        }
        return 4;
    }

    public void setInNether(boolean away) {
        this.citizenInNether = away;
    }

    public boolean isInNether() {
        return this.citizenInNether;
    }

    public Queue<ItemStack> getCraftedResults() {
        return this.craftedResults;
    }

    public boolean addCraftedResultsList(Collection<ItemStack> newResults) {
        return this.craftedResults.addAll(newResults);
    }

    public Queue<ItemStack> getProcessedResults() {
        return this.processedResults;
    }

    public boolean addProcessedResultsList(Collection<ItemStack> newResults) {
        return this.processedResults.addAll(newResults);
    }

    @Override
    public boolean ignoresDamage(@NotNull DamageSource damageSource) {
        if (damageSource.typeHolder().is(ResearchConstants.FIRE_DAMAGE_PREDICATE)) {
            return this.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FIRE_RES) > 0.0;
        }
        return super.ignoresDamage(damageSource);
    }
}

