/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.interactionhandling;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.Box;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.IVisitorViewData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.interactionhandling.ModInteractionResponseHandlers;
import com.minecolonies.api.eventbus.events.colony.citizens.CitizenAddedModEvent;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.StatsUtil;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.colony.interactionhandling.ServerCitizenInteraction;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class RecruitmentInteraction
extends ServerCitizenInteraction {
    private static final String RECRUITMENT_ICON = "recruitIcon";
    private static final ResourceLocation icon = new ResourceLocation("minecolonies", "textures/icons/recruiticon.png");
    private static final Tuple<Component, Component> recruitAnswer = new Tuple<MutableComponent, MutableComponent>(Component.translatableEscape((String)"com.minecolonies.coremod.gui.chat.recruit", (Object[])new Object[0]), Component.empty());
    private static final Tuple<Component, Component>[] responses = new Tuple[]{new Tuple<MutableComponent, MutableComponent>(Component.translatableEscape((String)"com.minecolonies.coremod.gui.chat.showstats", (Object[])new Object[0]), Component.empty()), recruitAnswer, new Tuple<MutableComponent, MutableComponent>(Component.translatableEscape((String)"com.minecolonies.coremod.gui.chat.notnow", (Object[])new Object[0]), Component.empty())};
    private static final int BAD_VISITOR_CHANCE = 2;

    public RecruitmentInteraction(ICitizen data) {
        super(data);
    }

    public RecruitmentInteraction(Component inquiry, IChatPriority priority) {
        super(inquiry, true, priority, (ICitizenData d) -> true, (Component)Component.empty(), responses);
    }

    @Override
    public List<IInteractionResponseHandler> genChildInteractions() {
        return Collections.emptyList();
    }

    @Override
    public String getType() {
        return ModInteractionResponseHandlers.RECRUITMENT.getPath();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWindowOpened(BOWindow window, ICitizenDataView dataView) {
        ButtonImage recruitButton = (ButtonImage)window.findPaneOfTypeByID("response_2", ButtonImage.class);
        Box group = (Box)window.findPaneOfTypeByID("responseOptions", Box.class);
        if (recruitButton != null && dataView instanceof IVisitorViewData) {
            IVisitorViewData visitorViewData = (IVisitorViewData)dataView;
            ItemStack recruitCost = visitorViewData.getRecruitCost();
            IColonyView colony = (IColonyView)dataView.getColony();
            ((Text)window.findPaneOfTypeByID("chat", Text.class)).setText(((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)PaneBuilders.textBuilder().append(Component.literal((String)(dataView.getName() + ": ")))).append(this.getInquiry())).emptyLines(1)).appendNL(Component.translatable((String)(colony.getCitizens().size() < colony.getCitizenCountLimit() ? "com.minecolonies.coremod.gui.chat.recruitcost" : "com.minecolonies.coremod.gui.chat.nospacerecruit"), (Object[])new Object[]{recruitCost.getCount() + " " + recruitCost.getHoverName().getString()}))).appendNL(Component.literal((String)""))).getText());
            int iconPosX = recruitButton.getX() + recruitButton.getWidth() - 28;
            int iconPosY = recruitButton.getY() + recruitButton.getHeight() - 18;
            ItemIcon icon = new ItemIcon();
            icon.setID(RECRUITMENT_ICON);
            icon.setSize(15, 15);
            group.addChild((Pane)icon);
            icon.setItem(recruitCost);
            icon.setPosition(iconPosX, iconPosY);
            icon.setVisible(true);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onClientResponseTriggered(int responseId, Player player, ICitizenDataView data, BOWindow window) {
        Component response = this.getPossibleResponses().get(responseId);
        if (response.equals((Object)recruitAnswer.getA()) && data instanceof IVisitorViewData) {
            if (player.isCreative() || InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((Container)player.getInventory()), ((IVisitorViewData)data).getRecruitCost().getItem()) >= ((IVisitorViewData)data).getRecruitCost().getCount()) {
                return super.onClientResponseTriggered(responseId, player, data, window);
            }
            MessageUtils.format("com.minecolonies.coremod.gui.chat.notenoughitems", new Object[0]).sendTo(player);
        }
        return true;
    }

    @Override
    public void onServerResponseTriggered(int responseId, Player player, ICitizenData data) {
        Component response = this.getPossibleResponses().get(responseId);
        if (response.equals((Object)recruitAnswer.getA()) && data instanceof IVisitorData) {
            IColony colony = data.getColony();
            if (colony.getCitizenManager().getCurrentCitizenCount() < colony.getCitizenManager().getPotentialMaxCitizens()) {
                if (player.isCreative() || InventoryUtils.attemptReduceStackInItemHandler((IItemHandler)new InvWrapper((Container)player.getInventory()), ((IVisitorData)data).getRecruitCost(), ((IVisitorData)data).getRecruitCost().getCount(), true, true)) {
                    colony.getVisitorManager().removeCivilian(data);
                    data.setHomeBuilding(null);
                    data.setJob(null);
                    IBuilding tavern = colony.getBuildingManager().getFirstBuildingMatching(b -> b.getBuildingType() == ModBuildings.tavern.get());
                    if (colony.getWorld().random.nextInt(100) <= 2) {
                        StatsUtil.trackStat(tavern, "visitors_absconded", 1);
                        colony.getStatisticsManager().increment("visitors_absconded", colony.getDay());
                        MessageUtils.format("com.minecolonies.coremod.recruit.runaway", data.getName()).sendTo(colony).forAllPlayers();
                        return;
                    }
                    StatsUtil.trackStat(tavern, "visitors_recruited", 1);
                    colony.getStatisticsManager().increment("visitors_recruited", colony.getDay());
                    ICitizenData newCitizen = colony.getCitizenManager().createAndRegisterCivilianData();
                    newCitizen.deserializeNBT((HolderLookup.Provider)player.level().registryAccess(), (Tag)((CompoundTag)data.serializeNBT((HolderLookup.Provider)player.level().registryAccess())));
                    newCitizen.setParents("", "");
                    newCitizen.setLastPosition(data.getLastPosition());
                    newCitizen.updateEntityIfNecessary();
                    data.getEntity().ifPresent(e -> e.remove(Entity.RemovalReason.DISCARDED));
                    if (data.hasCustomTexture()) {
                        MessageUtils.format("com.minecolonies.coremod.recruit.message.custom", data.getName()).sendTo(colony).forAllPlayers();
                    } else {
                        MessageUtils.format("com.minecolonies.coremod.recruit.message", data.getName()).sendTo(colony).forAllPlayers();
                    }
                    IMinecoloniesAPI.getInstance().getEventBus().post(new CitizenAddedModEvent(newCitizen, CitizenAddedModEvent.CitizenAddedSource.HIRED));
                }
            } else {
                MessageUtils.format("com.minecolonies.coremod.gui.chat.nospace", new Object[0]).sendTo(player);
            }
        }
    }

    @Override
    public ResourceLocation getInteractionIcon() {
        return icon;
    }
}

