/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.items.component.AdventureData;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Utils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.common.extensions.IHolderExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LootTableAnalyzer {
    private LootTableAnalyzer() {
    }

    public static List<LootDrop> toDrops(HolderLookup.Provider provider, @NotNull ResourceKey<LootTable> lootTableId) {
        try {
            return LootTableAnalyzer.toDrops(provider, (Holder<LootTable>)provider.holderOrThrow(lootTableId));
        }
        catch (IllegalStateException ex) {
            Log.getLogger().debug(String.format("Failed to parse loot table from %s", lootTableId), (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public static List<LootDrop> toDrops(@NotNull HolderLookup.Provider provider, @NotNull Holder<LootTable> lootTable) {
        try {
            JsonObject lootTableJson = Utils.serializeCodecMessToJson(LootTable.DIRECT_CODEC, provider, (LootTable)lootTable.value()).getAsJsonObject();
            return LootTableAnalyzer.toDrops(provider, lootTableJson);
        }
        catch (JsonParseException ex) {
            Log.getLogger().error(String.format("Failed to parse loot table from %s", lootTable.getKey()), (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public static List<LootDrop> toDrops(@NotNull HolderLookup.Provider provider, @NotNull JsonObject lootTableJson) {
        ArrayList<LootDrop> drops = new ArrayList<LootDrop>();
        if (!lootTableJson.has("pools")) {
            return drops;
        }
        JsonArray pools = GsonHelper.getAsJsonArray((JsonObject)lootTableJson, (String)"pools");
        for (JsonElement pool : pools) {
            boolean conditional;
            float rolls = LootTableAnalyzer.processNumber(pool.getAsJsonObject().get("rolls"), 1.0f);
            JsonArray entries = GsonHelper.getAsJsonArray((JsonObject)pool.getAsJsonObject(), (String)"entries", (JsonArray)new JsonArray());
            float totalWeight = StreamSupport.stream(entries.spliterator(), false).filter(entry -> {
                String type = GsonHelper.getAsString((JsonObject)entry.getAsJsonObject(), (String)"type");
                return type.equals("minecraft:empty") || type.equals("minecraft:item") || type.equals("minecraft:tag") || type.equals("minecraft:loot_table") || type.equals("minecraft:alternatives");
            }).mapToInt(entry -> GsonHelper.getAsInt((JsonObject)entry.getAsJsonObject(), (String)"weight", (int)1)).sum();
            JsonArray conditions = GsonHelper.getAsJsonArray((JsonObject)pool.getAsJsonObject(), (String)"conditions", (JsonArray)new JsonArray());
            boolean bl = conditional = !conditions.isEmpty();
            if (LootTableAnalyzer.conditionsSeemImpossible(conditions)) continue;
            float modifier = LootTableAnalyzer.adjustModifier(1.0f, conditions);
            for (JsonElement ej : entries) {
                JsonObject entryJson = ej.getAsJsonObject();
                float weight = GsonHelper.getAsFloat((JsonObject)entryJson, (String)"weight", (float)1.0f);
                List<LootDrop> entryDrops = LootTableAnalyzer.entryToDrops(provider, entryJson);
                for (LootDrop drop : entryDrops) {
                    drops.add(new LootDrop(drop.getItemStacks(), drop.getProbability() * (weight / totalWeight) * rolls * modifier, drop.getQuality() * rolls, conditional || drop.getConditional()));
                }
            }
        }
        drops.sort(Comparator.comparing(LootDrop::getProbability).reversed());
        return drops;
    }

    @NotNull
    private static List<LootDrop> entryToDrops(@NotNull HolderLookup.Provider provider, @NotNull JsonObject entryJson) {
        String type;
        ArrayList<LootDrop> drops = new ArrayList<LootDrop>();
        switch (type = GsonHelper.getAsString((JsonObject)entryJson, (String)"type")) {
            case "minecraft:item": {
                boolean conditional;
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)entryJson, (String)"name")));
                float quality = GsonHelper.getAsFloat((JsonObject)entryJson, (String)"quality", (float)0.0f);
                float modifier = 1.0f;
                JsonArray conditions = GsonHelper.getAsJsonArray((JsonObject)entryJson, (String)"conditions", (JsonArray)new JsonArray());
                boolean bl = conditional = !conditions.isEmpty();
                if (LootTableAnalyzer.conditionsSeemImpossible(conditions)) break;
                ItemStack stack = new ItemStack((ItemLike)item);
                if (entryJson.has("functions")) {
                    Tuple<ItemStack, Float> result = LootTableAnalyzer.processFunctions(provider, stack, GsonHelper.getAsJsonArray((JsonObject)entryJson, (String)"functions"));
                    stack = (ItemStack)result.getA();
                    modifier = ((Float)result.getB()).floatValue();
                }
                modifier = LootTableAnalyzer.adjustModifier(modifier, conditions);
                if (stack.getItem().equals(ModItems.adventureToken)) {
                    List<LootDrop> mobDrops = LootTableAnalyzer.expandAdventureToken(provider, stack);
                    for (LootDrop drop : mobDrops) {
                        drops.add(new LootDrop(drop.getItemStacks(), drop.getProbability(), drop.getQuality() + quality, drop.getConditional() || conditional));
                    }
                    break;
                }
                drops.add(new LootDrop(Collections.singletonList(stack), modifier, quality, conditional));
                break;
            }
            case "minecraft:loot_table": {
                boolean conditional;
                ResourceLocation table = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)entryJson, (String)"value"));
                List<LootDrop> tableDrops = LootTableAnalyzer.toDrops(provider, (ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)table));
                float quality = GsonHelper.getAsFloat((JsonObject)entryJson, (String)"quality", (float)0.0f);
                JsonArray conditions = GsonHelper.getAsJsonArray((JsonObject)entryJson, (String)"conditions", (JsonArray)new JsonArray());
                boolean bl = conditional = !conditions.isEmpty();
                if (LootTableAnalyzer.conditionsSeemImpossible(conditions)) break;
                for (LootDrop drop : tableDrops) {
                    drops.add(new LootDrop(drop.getItemStacks(), drop.getProbability(), drop.getQuality() + quality, drop.getConditional() || conditional));
                }
                break;
            }
            case "minecraft:alternatives": {
                JsonArray children = GsonHelper.getAsJsonArray((JsonObject)entryJson, (String)"children", (JsonArray)new JsonArray());
                JsonObject childJson = StreamSupport.stream(children.spliterator(), false).map(JsonElement::getAsJsonObject).filter(j -> !j.has("conditions")).findFirst().orElse(children.get(children.size() - 1).getAsJsonObject());
                drops.addAll(LootTableAnalyzer.entryToDrops(provider, childJson));
            }
        }
        return drops;
    }

    private static boolean conditionsSeemImpossible(@NotNull JsonArray conditions) {
        for (JsonElement condition : conditions) {
            String json = condition.toString();
            if (!json.contains("killed_by_player") && !json.contains("damage_source_properties") || json.contains("minecraft:inverted")) continue;
            return true;
        }
        return false;
    }

    private static float adjustModifier(float modifier, @NotNull JsonArray conditions) {
        for (JsonElement cj : conditions) {
            JsonObject condition = cj.getAsJsonObject();
            switch (GsonHelper.getAsString((JsonObject)condition, (String)"condition", (String)"")) {
                case "minecraft:random_chance": 
                case "minecraft:random_chance_with_looting": {
                    float chance = GsonHelper.getAsFloat((JsonObject)condition, (String)"chance", (float)1.0f);
                    modifier *= chance;
                }
            }
        }
        return modifier;
    }

    @NotNull
    private static List<LootDrop> expandAdventureToken(@NotNull HolderLookup.Provider provider, @NotNull ItemStack token) {
        AdventureData component = AdventureData.readFromItemStack(token);
        if (component != null) {
            return LootTableAnalyzer.toDrops(provider, (ResourceKey<LootTable>)component.entityType().getDefaultLootTable());
        }
        return Collections.emptyList();
    }

    @NotNull
    public static List<LootDrop> consolidate(@NotNull List<LootDrop> input) {
        return input.stream().collect(Collectors.groupingBy(LootDrop::hashCode)).values().stream().map(LootDrop::new).sorted(Comparator.comparing(LootDrop::getProbability).reversed()).collect(Collectors.toList());
    }

    private static Tuple<ItemStack, Float> processFunctions(@NotNull HolderLookup.Provider provider, @NotNull ItemStack stack, @NotNull JsonArray functions) {
        float modifier = 1.0f;
        block23: for (JsonElement je : functions) {
            JsonObject function = je.getAsJsonObject();
            String name = GsonHelper.getAsString((JsonObject)function, (String)"function", (String)"");
            try {
                switch (name) {
                    case "minecraft:set_count": {
                        Tuple<Integer, Float> result = LootTableAnalyzer.processCount(function.get("count"));
                        stack.setCount(((Integer)result.getA()).intValue());
                        modifier *= ((Float)result.getB()).floatValue();
                        break;
                    }
                    case "minecraft:set_damage": {
                        if (!stack.isDamageableItem()) continue block23;
                        float damage = 1.0f - LootTableAnalyzer.processNumber(function.get("damage"), 0.0f);
                        stack.setDamageValue(Mth.floor((float)(damage * (float)stack.getMaxDamage())));
                        break;
                    }
                    case "minecraft:set_potion": {
                        String id = GsonHelper.getAsString((JsonObject)function, (String)"id");
                        Holder potion = BuiltInRegistries.POTION.getHolder(ResourceLocation.tryParse((String)id)).orElse(null);
                        if (potion == null) continue block23;
                        stack.update(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY, (Object)potion, PotionContents::withPotion);
                        break;
                    }
                    case "minecraft:set_components": {
                        DataComponentPatch patch = (DataComponentPatch)Utils.deserializeCodecMessFromJson(DataComponentPatch.CODEC, provider, function.get("components"));
                        stack.applyComponentsAndValidate(patch);
                        break;
                    }
                    case "minecraft:enchant_with_levels": {
                        int levels = LootTableAnalyzer.processNumber(function.get("levels"), 1);
                        MapCodec optionsCodec = RegistryCodecs.homogeneousList((ResourceKey)Registries.ENCHANTMENT).optionalFieldOf("options");
                        RegistryOps ops = provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
                        Optional options = (Optional)optionsCodec.decode((DynamicOps)ops, (MapLike)ops.getMap((Object)function).getOrThrow()).getOrThrow();
                        Stream enchantments = options.map(HolderSet::stream).orElseGet(() -> provider.lookupOrThrow(Registries.ENCHANTMENT).listElements().map(IHolderExtension::getDelegate));
                        stack = EnchantmentHelper.enchantItem((RandomSource)RandomSource.create(), (ItemStack)stack, (int)levels, (Stream)enchantments);
                        break;
                    }
                    case "minecraft:apply_bonus": 
                    case "minecraft:enchanted_count_increase": {
                        break;
                    }
                    case "minecraft:furnace_smelt": {
                        break;
                    }
                    case "minecraft:explosion_decay": {
                        break;
                    }
                    default: {
                        Log.getLogger().warn("Unhandled modifier in loot table: {}", (Object)name);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                Log.getLogger().error("Failed to parse {} in loot table", (Object)name, (Object)e);
            }
        }
        return new Tuple((Object)stack, (Object)Float.valueOf(modifier));
    }

    private static Tuple<Integer, Float> processCount(@Nullable JsonElement json) {
        if (json == null) {
            return new Tuple((Object)1, (Object)Float.valueOf(1.0f));
        }
        if (json.isJsonObject() && GsonHelper.getAsString((JsonObject)json.getAsJsonObject(), (String)"type", (String)"").equals("minecraft:uniform")) {
            int min = GsonHelper.getAsInt((JsonObject)json.getAsJsonObject(), (String)"min", (int)0);
            int max = GsonHelper.getAsInt((JsonObject)json.getAsJsonObject(), (String)"max", (int)1);
            return new Tuple((Object)max, (Object)Float.valueOf(min == 0 ? (float)max / ((float)max + 1.0f) : 1.0f));
        }
        return new Tuple((Object)LootTableAnalyzer.processNumber(json, 1), (Object)Float.valueOf(1.0f));
    }

    private static int processNumber(@Nullable JsonElement json, int defaultValue) {
        if (json == null) {
            return defaultValue;
        }
        if (json.isJsonObject()) {
            switch (GsonHelper.getAsString((JsonObject)json.getAsJsonObject(), (String)"type", (String)"")) {
                case "minecraft:constant": {
                    return GsonHelper.getAsInt((JsonObject)json.getAsJsonObject(), (String)"value", (int)defaultValue);
                }
                case "minecraft:uniform": {
                    return GsonHelper.getAsInt((JsonObject)json.getAsJsonObject(), (String)"max", (int)defaultValue);
                }
            }
            return defaultValue;
        }
        if (json.isJsonPrimitive()) {
            return json.getAsJsonPrimitive().getAsInt();
        }
        return defaultValue;
    }

    private static float processNumber(@Nullable JsonElement json, float defaultValue) {
        if (json == null) {
            return defaultValue;
        }
        if (json.isJsonObject()) {
            switch (GsonHelper.getAsString((JsonObject)json.getAsJsonObject(), (String)"type", (String)"")) {
                case "minecraft:constant": {
                    return GsonHelper.getAsFloat((JsonObject)json.getAsJsonObject(), (String)"value", (float)defaultValue);
                }
                case "minecraft:uniform": {
                    return GsonHelper.getAsFloat((JsonObject)json.getAsJsonObject(), (String)"max", (float)defaultValue);
                }
            }
            return defaultValue;
        }
        if (json.isJsonPrimitive()) {
            return json.getAsJsonPrimitive().getAsFloat();
        }
        return defaultValue;
    }

    public static class LootDrop {
        private final List<ItemStack> stacks;
        private final float probability;
        private final float quality;
        private final boolean conditional;

        public LootDrop(@NotNull List<ItemStack> stacks, float probability, float quality, boolean conditional) {
            this.stacks = stacks;
            this.probability = probability;
            this.quality = quality;
            this.conditional = conditional;
        }

        public LootDrop(@NotNull List<LootDrop> drops) {
            this.stacks = drops.stream().flatMap(d -> d.getItemStacks().stream()).collect(Collectors.toList());
            this.probability = drops.get(0).getProbability();
            this.quality = drops.get(0).getQuality();
            this.conditional = drops.get(0).getConditional();
        }

        @NotNull
        public List<ItemStack> getItemStacks() {
            return this.stacks;
        }

        public float getProbability() {
            return this.probability;
        }

        public float getQuality() {
            return this.quality;
        }

        public boolean getConditional() {
            return this.conditional;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.probability), Float.valueOf(this.quality), this.conditional);
        }

        public void serialize(@NotNull RegistryFriendlyByteBuf buffer) {
            int prevIndex = buffer.writerIndex();
            buffer.writeVarInt(this.stacks.size());
            for (ItemStack stack : this.stacks) {
                try {
                    Utils.serializeCodecMess(buffer, stack);
                }
                catch (Exception e) {
                    Log.getLogger().warn("Error serializing item stack: " + String.valueOf(stack), (Throwable)e);
                    buffer.writerIndex(prevIndex);
                    buffer.writeVarInt(0);
                    break;
                }
            }
            buffer.writeFloat(this.probability);
            buffer.writeFloat(this.quality);
            buffer.writeBoolean(this.conditional);
        }

        public static LootDrop deserialize(@NotNull RegistryFriendlyByteBuf buffer) {
            int size = buffer.readVarInt();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(size);
            for (int i = 0; i < size; ++i) {
                stacks.add(Utils.deserializeCodecMess(buffer));
            }
            float probability = buffer.readFloat();
            float quality = buffer.readFloat();
            boolean conditional = buffer.readBoolean();
            return new LootDrop(stacks, probability, quality, conditional);
        }
    }
}

