/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableList;
import com.ldtteam.structurize.api.RotationMirror;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.colony.buildings.modules.settings.BlockSetting;
import com.minecolonies.core.colony.buildings.modules.settings.IntSetting;
import com.minecolonies.core.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.core.colony.jobs.JobMiner;
import com.minecolonies.core.colony.workorders.WorkOrderMiner;
import com.minecolonies.core.entity.ai.workers.util.MineNode;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class BuildingMiner
extends AbstractBuildingStructureBuilder {
    public static final ISettingKey<BlockSetting> FILL_BLOCK = new SettingKey<BlockSetting>(BlockSetting.class, new ResourceLocation("minecolonies", "fillblock"));
    public static final ISettingKey<IntSetting> MAX_DEPTH = new SettingKey<IntSetting>(IntSetting.class, new ResourceLocation("minecolonies", "maxdepth"));
    private static final List<Integer> MINING_LEVELS = ImmutableList.copyOf((Object[])new Integer[]{48, 16, -16, -100});
    private static final String MINER = "miner";
    private BlockPos cobbleLocation;
    private BlockPos ladderLocation;

    public BuildingMiner(IColony c, BlockPos l) {
        super(c, l);
        ItemStack stackLadder = new ItemStack((ItemLike)Blocks.LADDER);
        ItemStack stackTorch = new ItemStack((ItemLike)Blocks.TORCH);
        ItemStack stackCobble = new ItemStack((ItemLike)Blocks.COBBLESTONE);
        this.keepX.put(stack -> ItemStack.isSameItem((ItemStack)stackLadder, (ItemStack)stack), new Tuple((Object)64, (Object)true));
        this.keepX.put(stack -> ItemStack.isSameItem((ItemStack)stackTorch, (ItemStack)stack), new Tuple((Object)64, (Object)true));
        this.keepX.put(stack -> ItemStack.isSameItem((ItemStack)stackCobble, (ItemStack)stack), new Tuple((Object)64, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.pickaxe.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.shovel.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.axe.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.shears.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, new ItemStack((ItemLike)this.getSetting(FILL_BLOCK).getValue())), new Tuple((Object)64, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return MINER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public int getResourceBatchMultiplier() {
        if (((WorkerBuildingModule)this.getModuleMatching(WorkerBuildingModule.class, (T m) -> m.getJobEntry() == ModJobs.quarrier.get())).getAssignedCitizen().isEmpty()) {
            return 4;
        }
        return 1;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        this.ladderLocation = BlockPosUtil.readOrNull(compound, "ladderlocation");
        this.cobbleLocation = BlockPosUtil.readOrNull(compound, "cobblelocation");
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        BlockPosUtil.writeOptional(compound, "cobblelocation", this.cobbleLocation);
        BlockPosUtil.writeOptional(compound, "ladderlocation", this.ladderLocation);
        return compound;
    }

    public int getDepthLimit(Level level) {
        int buildingY = this.getLadderLocation().getY() - 5;
        int buildingLevels = this.getBuildingLevel();
        int yLevel = 0;
        for (Integer miningLevel : MINING_LEVELS) {
            if (miningLevel < buildingY) {
                yLevel = miningLevel;
                --buildingLevels;
            }
            if (buildingLevels != 0) continue;
            break;
        }
        return this.normalizeMaxDepth(yLevel, level);
    }

    public int normalizeMaxDepth(int max, Level level) {
        int worldMaxDepth = level.getMinBuildHeight() + 5;
        IntSetting maxDepth = this.getSetting(MAX_DEPTH);
        if (maxDepth.getValue().intValue() == maxDepth.getDefault()) {
            return Math.max(worldMaxDepth, max);
        }
        return Math.max(worldMaxDepth, Math.max(max, maxDepth.getValue()));
    }

    public BlockPos getLadderLocation() {
        if (this.ladderLocation == null) {
            this.loadLadderPos();
        }
        return this.ladderLocation;
    }

    public BlockPos getCobbleLocation() {
        if (this.cobbleLocation == null) {
            this.loadLadderPos();
        }
        return this.cobbleLocation;
    }

    private void loadLadderPos() {
        Map<String, Set<BlockPos>> map = this.getTileEntity().getWorldTagNamePosMap();
        Set cobblePos = map.getOrDefault("cobble", new HashSet());
        Set ladderPos = map.getOrDefault("ladder", new HashSet());
        if (cobblePos.isEmpty() || ladderPos.isEmpty()) {
            return;
        }
        this.cobbleLocation = (BlockPos)cobblePos.iterator().next();
        this.ladderLocation = (BlockPos)ladderPos.iterator().next();
    }

    public static void initStructure(MineNode mineNode, BlockPos structurePos, BuildingMiner buildingMiner, Level world, JobMiner job) {
        String style;
        RotationMirror rotMir;
        String structurePack = buildingMiner.getStructurePack();
        if (mineNode == null) {
            rotMir = BuildingMiner.getRotationFromVector(buildingMiner);
            style = MineNode.NodeType.SHAFT.getSchematicName();
        } else {
            rotMir = mineNode.getRotationMirror().orElse(RotationMirror.NONE);
            style = mineNode.getStyle().getSchematicName();
        }
        if (job == null || job.getWorkOrder() == null) {
            WorkOrderMiner wo = new WorkOrderMiner(structurePack, style + ".blueprint", style, rotMir, structurePos, false, buildingMiner.getPosition());
            wo.setClaimedBy(buildingMiner.getPosition());
            buildingMiner.getColony().getWorkManager().addWorkOrder(wo, false);
            if (job != null) {
                job.setWorkOrder(wo);
            } else {
                wo.setClaimedBy(buildingMiner.getPosition());
            }
        }
        buildingMiner.markDirty();
    }

    private static RotationMirror getRotationFromVector(BuildingMiner buildingMiner) {
        BlockPos vector = buildingMiner.getLadderLocation().subtract((Vec3i)buildingMiner.getCobbleLocation());
        if (vector.getX() == 1) {
            return RotationMirror.R90;
        }
        if (vector.getZ() == 1) {
            return RotationMirror.R180;
        }
        if (vector.getX() == -1) {
            return RotationMirror.R270;
        }
        if (vector.getZ() == -1) {
            return RotationMirror.NONE;
        }
        return RotationMirror.NONE;
    }
}

