/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.TagConstants;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.level.block.HopperBlock;
import org.jetbrains.annotations.NotNull;

public class BuildingMechanic
extends AbstractBuilding {
    private static final String MECHANIC = "mechanic";

    public BuildingMechanic(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return MECHANIC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public static class DOCraftingModule
    extends AbstractCraftingBuildingModule.Domum {
        public DOCraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @NotNull
        public static OptionalPredicate<ItemStack> getStaticIngredientValidator() {
            OptionalPredicate<ItemStack> sawmill = CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_SAWMILL, true).combine(stack -> Optional.of(stack.is(ItemTags.PLANKS) || stack.is(ItemTags.LOGS)));
            Predicate<ItemStack> handled = sawmill.or(CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_FLETCHER, true)).or(CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_STONEMASON, true)).or(CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_GLASSBLOWER, true)).orElse(false);
            return OptionalPredicate.of(handled.negate());
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return DOCraftingModule.getStaticIngredientValidator();
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_MECHANIC).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            Optional<Boolean> isRecipeAllowed = CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_MECHANIC);
            if (isRecipeAllowed.isPresent()) {
                return isRecipeAllowed.get();
            }
            Item item = recipe.getPrimaryOutput().getItem();
            return item instanceof MinecartItem || item instanceof BlockItem && ((BlockItem)item).getBlock() instanceof HopperBlock;
        }

        @Override
        protected int getMaxRecipes() {
            return super.getMaxRecipes() + 5;
        }
    }
}

