/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesNamedGrave;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.GraveData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.tileentities.TileEntityGrave;
import com.minecolonies.core.tileentities.TileEntityNamedGrave;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraveyardManagementModule
extends AbstractBuildingModule
implements IBuildingModule,
IPersistentModule,
IBuildingEventsModule {
    private static final String TAG_RIP_CITIZEN_LIST = "ripCitizenList";
    private static final String TAG_GRAVE_DATA = "gravedata";
    private final List<String> restingCitizen = new ArrayList<String>();
    @Nullable
    private GraveData lastGraveData;

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        this.restingCitizen.clear();
        if (compound.contains(TAG_RIP_CITIZEN_LIST)) {
            ListTag ripCitizen = compound.getList(TAG_RIP_CITIZEN_LIST, 8);
            for (int i = 0; i < ripCitizen.size(); ++i) {
                String citizenName = ripCitizen.getString(i);
                this.restingCitizen.add(citizenName);
            }
        }
        if (compound.contains(TAG_GRAVE_DATA)) {
            this.lastGraveData = new GraveData();
            this.lastGraveData.read(compound.getCompound(TAG_GRAVE_DATA));
        } else {
            this.lastGraveData = null;
        }
    }

    @Override
    public void serializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        @NotNull ListTag ripCitizen = new ListTag();
        for (String citizenName : this.restingCitizen) {
            ripCitizen.add((Object)StringTag.valueOf((String)citizenName));
        }
        compound.put(TAG_RIP_CITIZEN_LIST, (Tag)ripCitizen);
        if (this.lastGraveData != null) {
            compound.put(TAG_GRAVE_DATA, (Tag)this.lastGraveData.write());
        }
    }

    @Override
    public void serializeToView(@NotNull RegistryFriendlyByteBuf buf) {
        IColony colony = this.building.getColony();
        ArrayList<BlockPos> graves = new ArrayList<BlockPos>(colony.getGraveManager().getGraves().keySet());
        ArrayList<BlockPos> cleanList = new ArrayList<BlockPos>();
        for (BlockPos grave : graves) {
            BlockEntity tileEntity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), grave) || !((tileEntity = colony.getWorld().getBlockEntity(grave)) instanceof TileEntityGrave)) continue;
            cleanList.add(grave);
        }
        buf.writeInt(cleanList.size());
        for (BlockPos grave : cleanList) {
            buf.writeBlockPos(grave);
        }
        buf.writeInt(this.restingCitizen.size());
        for (String citizenName : this.restingCitizen) {
            buf.writeUtf(citizenName);
        }
    }

    public void setLastGraveData(GraveData graveData) {
        this.lastGraveData = graveData;
        this.markDirty();
    }

    public GraveData getLastGraveData() {
        return this.lastGraveData;
    }

    public boolean hasRestingCitizen(Set<String> citizens) {
        for (String citizen : citizens) {
            if (!this.restingCitizen.contains(citizen)) continue;
            return true;
        }
        return false;
    }

    public void buryCitizenHere(Tuple<BlockPos, Direction> positionAndDirection, AbstractEntityCitizen worker) {
        if (this.lastGraveData != null && !this.restingCitizen.contains(this.lastGraveData.getCitizenName())) {
            IColony colony = this.building.getColony();
            Direction facing = positionAndDirection.getB();
            if (facing == Direction.UP || facing == Direction.DOWN) {
                facing = Direction.NORTH;
            }
            colony.getWorld().destroyBlock(positionAndDirection.getA(), true, (Entity)worker);
            colony.getWorld().setBlockAndUpdate(positionAndDirection.getA(), (BlockState)ModBlocks.blockNamedGrave.defaultBlockState().setValue((Property)AbstractBlockMinecoloniesNamedGrave.FACING, (Comparable)facing));
            BlockEntity tileEntity = colony.getWorld().getBlockEntity(positionAndDirection.getA());
            if (tileEntity instanceof TileEntityNamedGrave) {
                String firstName = StringUtils.split((String)this.lastGraveData.getCitizenName())[0];
                String lastName = this.lastGraveData.getCitizenName().replaceFirst(firstName, "");
                ArrayList<String> lines = new ArrayList<String>();
                lines.add(firstName);
                lines.add(lastName);
                if (this.lastGraveData.getCitizenJobName() != null) {
                    lines.add(this.lastGraveData.getCitizenJobName());
                }
                ((TileEntityNamedGrave)tileEntity).setTextLines(lines);
            }
            this.restingCitizen.add(this.lastGraveData.getCitizenName());
            this.markDirty();
        }
    }
}

