/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings;

import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingContainer;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.AbstractDeliverymanRequestable;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.core.blocks.BlockMinecoloniesRack;
import com.minecolonies.core.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import com.minecolonies.core.tileentities.TileEntityRack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBuildingContainer
extends AbstractSchematicProvider
implements IBuildingContainer {
    protected final Set<BlockPos> containerList = new HashSet<BlockPos>();
    protected final Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> keepX = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>();
    protected AbstractTileEntityColonyBuilding tileEntity;
    private int unscaledPickUpPriority = 5;

    public AbstractBuildingContainer(BlockPos pos, IColony colony) {
        super(pos, colony);
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        ListTag containerTagList = compound.getList("Containers", 11);
        for (int i = 0; i < containerTagList.size(); ++i) {
            this.containerList.add(NBTUtils.readBlockPos(containerTagList.get(i)));
        }
        if (compound.contains("prio")) {
            this.unscaledPickUpPriority = compound.getInt("prio");
        }
        if (compound.contains("prioState") && compound.getInt("prioState") == 0) {
            this.unscaledPickUpPriority = 0;
        }
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        @NotNull ListTag containerTagList = new ListTag();
        for (BlockPos pos : this.containerList) {
            containerTagList.add((Object)NBTUtils.writeBlockPos(pos));
        }
        compound.put("Containers", (Tag)containerTagList);
        compound.putInt("prio", this.unscaledPickUpPriority);
        return compound;
    }

    @Override
    public int getPickUpPriority() {
        return this.unscaledPickUpPriority;
    }

    @Override
    public void alterPickUpPriority(int value) {
        this.unscaledPickUpPriority = Mth.clamp((int)(this.unscaledPickUpPriority + value), (int)0, (int)AbstractDeliverymanRequestable.getMaxBuildingPriority(false));
    }

    @Override
    public void addContainerPosition(@NotNull BlockPos pos) {
        this.containerList.add(pos);
    }

    @Override
    public void removeContainerPosition(BlockPos pos) {
        this.containerList.remove(pos);
    }

    @Override
    public List<BlockPos> getContainers() {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(this.containerList);
        list.add(this.getPosition());
        return list;
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull Level world) {
        this.registerBlockPosition(blockState.getBlock(), pos, world);
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull Level world) {
        if (block instanceof AbstractBlockHut) {
            BlockEntity entity = world.getBlockEntity(pos);
            if (entity instanceof TileEntityColonyBuilding) {
                TileEntityColonyBuilding buildingEntity = (TileEntityColonyBuilding)entity;
                buildingEntity.setStructurePack(StructurePacks.getStructurePack((String)this.getStructurePack()));
                IBuilding building = this.colony.getBuildingManager().getBuilding(pos);
                if (building != null) {
                    building.setStructurePack(this.getStructurePack());
                    building.setParent(this.getID());
                }
            }
        } else if (block instanceof BlockMinecoloniesRack) {
            this.addContainerPosition(pos);
            BlockEntity entity = world.getBlockEntity(pos);
            if (entity instanceof TileEntityRack) {
                TileEntityRack rackEntity = (TileEntityRack)entity;
                rackEntity.setBuildingPos(this.getID());
            }
        }
    }

    @Nullable
    protected BlockPos getFirstLocationFromTag(@NotNull String tagName) {
        List<BlockPos> locations = this.getLocationsFromTag(tagName);
        return locations.isEmpty() ? null : locations.get(0);
    }

    @Override
    public List<BlockPos> getLocationsFromTag(@NotNull String tagName) {
        if (this.tileEntity != null) {
            return this.tileEntity.getCachedWorldTagNamePosMap().getOrDefault(tagName, Collections.emptyList());
        }
        return Collections.emptyList();
    }

    @Override
    public void setTileEntity(AbstractTileEntityColonyBuilding te) {
        this.tileEntity = te;
        if (te != null && te.isOutdated()) {
            this.safeUpdateTEDataFromSchematic();
        }
    }

    @Override
    @Nullable
    public IItemHandler getItemHandlerCap(Direction direction) {
        return this.getTileEntity().getItemHandlerCap(direction);
    }
}

