/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataManager;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.CitizenData;
import com.minecolonies.core.colony.CitizenDataView;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class CitizenDataManager
implements ICitizenDataManager {
    @Override
    public ICitizenData createFromNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound, IColony colony) {
        int id = compound.getInt("id");
        @NotNull CitizenData citizen = new CitizenData(id, colony);
        citizen.deserializeNBT(provider, compound);
        return citizen;
    }

    @Override
    public ICitizenDataView createFromNetworkData(int id, @NotNull RegistryFriendlyByteBuf networkBuffer, IColonyView colonyView) {
        ICitizenDataView citizenDataView = colonyView.getCitizen(id) == null ? new CitizenDataView(id, colonyView) : colonyView.getCitizen(id);
        try {
            citizenDataView.deserialize(networkBuffer);
        }
        catch (RuntimeException ex) {
            Log.getLogger().error(String.format("A CitizenData.View for #%d has thrown an exception during loading, its state cannot be restored. Report this to the mod author", citizenDataView.getId()), (Throwable)ex);
            citizenDataView = null;
        }
        return citizenDataView;
    }
}

