/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render.worldevent;

import com.ldtteam.structurize.util.WorldRenderMacros;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.core.client.render.worldevent.ColonyBlueprintRenderer;
import com.minecolonies.core.client.render.worldevent.ColonyBorderRenderer;
import com.minecolonies.core.client.render.worldevent.ColonyPatrolPointRenderer;
import com.minecolonies.core.client.render.worldevent.ColonyWaypointRenderer;
import com.minecolonies.core.client.render.worldevent.GuardTowerRallyBannerRenderer;
import com.minecolonies.core.client.render.worldevent.HighlightManager;
import com.minecolonies.core.client.render.worldevent.ItemOverlayBoxesRenderer;
import com.minecolonies.core.client.render.worldevent.PathfindingDebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.jetbrains.annotations.Nullable;

public class WorldEventContext
extends WorldRenderMacros {
    public static final WorldEventContext INSTANCE = new WorldEventContext();
    @Nullable
    public IColonyView nearestColony;

    private WorldEventContext() {
    }

    protected void renderWithinContext(RenderLevelStageEvent.Stage stage) {
        if (stage == STAGE_FOR_LINES) {
            ColonyBorderRenderer.render(this);
            ColonyBlueprintRenderer.renderBlueprints(this);
            ColonyWaypointRenderer.render(this);
            ColonyPatrolPointRenderer.render(this);
            GuardTowerRallyBannerRenderer.render(this);
            PathfindingDebugRenderer.render(this);
            ColonyBlueprintRenderer.renderBoxes(this);
            ItemOverlayBoxesRenderer.render(this);
            HighlightManager.render(this);
        }
    }

    boolean hasNearestColony() {
        return this.nearestColony != null;
    }

    public void checkNearbyColony(Level level) {
        if (this.clientPlayer != null) {
            this.nearestColony = IColonyManager.getInstance().getClosestColonyView(level, this.clientPlayer.blockPosition());
        }
    }

    public void renderLineBoxWithShadow(BlockPos pos, int argbColor, float lineWidth) {
        int red = FastColor.ARGB32.red((int)argbColor);
        int green = FastColor.ARGB32.green((int)argbColor);
        int blue = FastColor.ARGB32.blue((int)argbColor);
        int alpha = FastColor.ARGB32.alpha((int)argbColor);
        this.renderLineBox(LINES_WITH_WIDTH_DEPTH_INVERT, pos, pos, red / 2, green / 2, blue / 2, alpha / 2, lineWidth);
        this.renderLineBox(LINES_WITH_WIDTH, pos, pos, red, green, blue, alpha, lineWidth);
    }

    public void renderLineAABBWithShadow(AABB aabb, int argbColor, float lineWidth) {
        int red = FastColor.ARGB32.red((int)argbColor);
        int green = FastColor.ARGB32.green((int)argbColor);
        int blue = FastColor.ARGB32.blue((int)argbColor);
        int alpha = FastColor.ARGB32.alpha((int)argbColor);
        this.renderLineAABB(LINES_WITH_WIDTH_DEPTH_INVERT, aabb, red / 2, green / 2, blue / 2, alpha / 2, lineWidth);
        this.renderLineAABB(LINES_WITH_WIDTH, aabb, red, green, blue, alpha, lineWidth);
    }
}

