/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render.worldevent;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.client.ModKeyMappings;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.configuration.ClientConfiguration;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.core.client.render.worldevent.WorldEventContext;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.core.colony.workorders.view.WorkOrderBuildingView;
import com.minecolonies.core.items.ItemAssistantHammer;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.concurrent.UncheckedExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyBlueprintRenderer {
    private static final BlockPos INVALID_POS = BlockPos.ZERO.below(500);
    private static final double CACHE_RESET_RANGE = 12.5;
    private static Map<BlueprintCacheKey, List<BlockPos>> blueprintRenderCache = new HashMap<BlueprintCacheKey, List<BlockPos>>();
    private static Map<BlockPos, BoxRenderData> boxRenderCache = new HashMap<BlockPos, BoxRenderData>();
    private static final Cache<BlueprintCacheKey, BlueprintPreviewData> blueprintDataCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(2L)).softValues().build();
    private static BlockPos lastCacheRebuild = null;
    private static boolean shouldRenderBlueprints = true;
    private static final Map<BlockPos, PendingRenderData> pendingBoxes = new HashMap<BlockPos, PendingRenderData>();
    private static final List<IRenderBlueprintRule> renderRules = new ArrayList<IRenderBlueprintRule>();

    public static void invalidateCache() {
        lastCacheRebuild = null;
    }

    public static boolean willRenderBlueprints() {
        return shouldRenderBlueprints;
    }

    static void renderBlueprints(WorldEventContext ctx) {
        if (((KeyMapping)ModKeyMappings.TOGGLE_GOGGLES.get()).consumeClick()) {
            shouldRenderBlueprints = !shouldRenderBlueprints;
            ctx.clientPlayer.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value(), SoundSource.NEUTRAL, 1.0f, shouldRenderBlueprints ? 0.75f : 0.25f);
        }
        if (!ctx.hasNearestColony()) {
            blueprintRenderCache.clear();
            boxRenderCache.clear();
            lastCacheRebuild = null;
            return;
        }
        ArrayList<IRenderBlueprintRule> activeRules = new ArrayList<IRenderBlueprintRule>();
        for (IRenderBlueprintRule rule : renderRules) {
            if (!rule.isEnabled(ctx)) continue;
            activeRules.add(rule);
        }
        if (activeRules.isEmpty()) {
            blueprintRenderCache.clear();
            boxRenderCache.clear();
            lastCacheRebuild = null;
            return;
        }
        BlockPos activePosition = ctx.clientPlayer.blockPosition();
        if (lastCacheRebuild == null || !lastCacheRebuild.closerThan((Vec3i)activePosition, 12.5)) {
            ColonyBlueprintRenderer.rebuildCache(ctx, activeRules);
            lastCacheRebuild = activePosition;
        }
        if (ctx.clientLevel.getGameTime() % 20L == 0L) {
            ColonyBlueprintRenderer.processPendingBlueprints((HolderLookup.Provider)ctx.clientLevel.registryAccess());
        }
        if (shouldRenderBlueprints) {
            for (Map.Entry<BlueprintCacheKey, List<BlockPos>> entry : blueprintRenderCache.entrySet()) {
                BlueprintPreviewData data = ColonyBlueprintRenderer.getCached(entry.getKey(), (HolderLookup.Provider)ctx.clientLevel.registryAccess());
                ctx.renderBlueprint(data, entry.getValue());
            }
        }
    }

    static void renderBoxes(WorldEventContext ctx) {
        for (Map.Entry<BlockPos, BoxRenderData> entry : boxRenderCache.entrySet()) {
            BlockPos pos2;
            ICitizenDataView citizen;
            BoxRenderData buildingData = entry.getValue();
            BlockPos root = buildingData.box().pos1();
            if (root != INVALID_POS) {
                ctx.pushPoseCameraToPos(root);
                ctx.renderLineBox(WorldEventContext.LINES_WITH_WIDTH, BlockPos.ZERO, buildingData.box().pos2().subtract((Vec3i)root), -16776961, 0.075f);
                ctx.popPose();
            }
            buildingData.box().anchor().ifPresent(pos -> {
                if (ctx.clientPlayer.isShiftKeyDown()) {
                    ctx.pushPoseCameraToPos((BlockPos)pos);
                    ctx.renderLineBoxWithShadow(BlockPos.ZERO, -65536, 0.025f);
                    ctx.popPose();
                }
            });
            if (ctx.nearestColony == null || buildingData.builder() == 0 || !ctx.clientPlayer.isShiftKeyDown() || (citizen = ctx.nearestColony.getCitizen(buildingData.builder())) == null || (pos2 = citizen.getStatusPosition()) == null) continue;
            ctx.pushPoseCameraToPos(pos2);
            ctx.renderLineBoxWithShadow(BlockPos.ZERO, -16711936, 0.025f);
            ctx.popPose();
        }
    }

    private static void rebuildCache(WorldEventContext ctx, List<IRenderBlueprintRule> rules) {
        Collections.reverse(rules);
        HashMap<BlockPos, PendingRenderData> desired = new HashMap<BlockPos, PendingRenderData>();
        for (IRenderBlueprintRule rule : rules) {
            desired.putAll(rule.getDesiredBlueprints(ctx));
        }
        HashMap<BlueprintCacheKey, List<BlockPos>> newBlueprints = new HashMap<BlueprintCacheKey, List<BlockPos>>();
        HashMap<BlockPos, BoxRenderData> newBoxes = new HashMap<BlockPos, BoxRenderData>();
        for (Map.Entry entry : desired.entrySet()) {
            BoxRenderData newBox;
            if (((PendingRenderData)entry.getValue()).blueprint() != null && !((PendingRenderData)entry.getValue()).boxOnly()) {
                List posList = newBlueprints.computeIfAbsent(((PendingRenderData)entry.getValue()).blueprint(), k -> new ArrayList());
                posList.add((BlockPos)entry.getKey());
            }
            if ((newBox = ColonyBlueprintRenderer.tryLoadBox((PendingRenderData)entry.getValue(), (HolderLookup.Provider)ctx.clientLevel.registryAccess())) != null) {
                newBoxes.put((BlockPos)entry.getKey(), newBox);
                continue;
            }
            pendingBoxes.put((BlockPos)entry.getKey(), (PendingRenderData)entry.getValue());
            BoxRenderData oldBox = boxRenderCache.getOrDefault(entry.getKey(), null);
            if (oldBox == null) continue;
            newBoxes.put((BlockPos)entry.getKey(), oldBox);
        }
        blueprintRenderCache = newBlueprints;
        boxRenderCache = newBoxes;
    }

    @Nullable
    private static BoxRenderData tryLoadBox(@NotNull PendingRenderData data, HolderLookup.Provider provider) {
        if (data.blueprint() == null) {
            if (data.boxOnly() && data.hasAnchor()) {
                BoxPreviewData box = new BoxPreviewData(INVALID_POS, INVALID_POS, Optional.of(data.pos()));
                return new BoxRenderData(box, 0);
            }
            return new BoxRenderData(null, 0);
        }
        BlueprintPreviewData blueprintData = ColonyBlueprintRenderer.getCached(data.blueprint(), provider);
        Blueprint localBlueprint = blueprintData.getBlueprint();
        if (localBlueprint == null) {
            return null;
        }
        if (blueprintData.isEmpty()) {
            return new BoxRenderData(null, 0);
        }
        BlockPos primaryOffset = localBlueprint.getPrimaryBlockOffset();
        BlockPos boxStartPos = data.pos().subtract((Vec3i)primaryOffset);
        BlockPos boxEndPos = boxStartPos.offset(localBlueprint.getSizeX() - 1, localBlueprint.getSizeY() - 1, localBlueprint.getSizeZ() - 1);
        BoxPreviewData box = new BoxPreviewData(boxStartPos, boxEndPos, data.hasAnchor() ? Optional.of(data.pos()) : Optional.empty());
        return new BoxRenderData(box, data.builder());
    }

    private static void processPendingBlueprints(HolderLookup.Provider provider) {
        Iterator<Map.Entry<BlockPos, PendingRenderData>> iterator = pendingBoxes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, PendingRenderData> entry = iterator.next();
            BoxRenderData box = ColonyBlueprintRenderer.tryLoadBox(entry.getValue(), provider);
            if (box == null) continue;
            if (box.box() != null || box.builder() != 0) {
                boxRenderCache.put(entry.getKey(), box);
            }
            iterator.remove();
        }
    }

    private static BlueprintPreviewData getCached(BlueprintCacheKey key, HolderLookup.Provider provider) {
        try {
            return (BlueprintPreviewData)blueprintDataCache.get((Object)key, () -> ColonyBlueprintRenderer.makeBlueprintPreview(key, provider));
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    @NotNull
    private static BlueprintPreviewData makeBlueprintPreview(@NotNull BlueprintCacheKey key, HolderLookup.Provider provider) {
        CompletableFuture blueprintFuture = StructurePacks.getBlueprintFuture((String)key.packName(), (String)key.path(), (HolderLookup.Provider)provider);
        BlueprintPreviewData blueprintPreviewData = new BlueprintPreviewData(false);
        blueprintPreviewData.setBlueprintFuture((Future)blueprintFuture);
        blueprintPreviewData.setPos(BlockPos.ZERO);
        blueprintPreviewData.setRotationMirror(key.orientation());
        return blueprintPreviewData;
    }

    static {
        renderRules.add(new NearBuildPreview());
        renderRules.add(new BuildGoggles());
        renderRules.add(new AssistantHammerPreview());
    }

    private static interface IRenderBlueprintRule {
        public boolean isEnabled(WorldEventContext var1);

        public Map<BlockPos, PendingRenderData> getDesiredBlueprints(WorldEventContext var1);
    }

    private record BlueprintCacheKey(@NotNull String packName, @NotNull String path, RotationMirror orientation) {
    }

    private record BoxRenderData(@Nullable BoxPreviewData box, int builder) {
    }

    private record PendingRenderData(@Nullable BlueprintCacheKey blueprint, @NotNull BlockPos pos, int builder, boolean boxOnly, boolean hasAnchor) {
    }

    private static class NearBuildPreview
    implements IRenderBlueprintRule {
        private NearBuildPreview() {
        }

        @Override
        public boolean isEnabled(WorldEventContext ctx) {
            return RenderingCache.hasBlueprint((String)"blueprint") && (Boolean)((ClientConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getClient()).neighborbuildingrendering.get() != false && ctx.mainHandItem.getItem() == ModItems.buildTool.get();
        }

        @Override
        public Map<BlockPos, PendingRenderData> getDesiredBlueprints(WorldEventContext ctx) {
            HashMap<BlockPos, PendingRenderData> desired = new HashMap<BlockPos, PendingRenderData>();
            if (!RenderingCache.hasBlueprint((String)"blueprint")) {
                return desired;
            }
            BlockPos activePosition = RenderingCache.getOrCreateBlueprintPreviewData((String)"blueprint").getPos();
            Blueprint blueprint = RenderingCache.getOrCreateBlueprintPreviewData((String)"blueprint").getBlueprint();
            if (blueprint == null) {
                return desired;
            }
            BlockPos zeroPos = activePosition.subtract((Vec3i)blueprint.getPrimaryBlockOffset());
            AABB blueprintAABB = AABB.encapsulatingFullBlocks((BlockPos)zeroPos, (BlockPos)zeroPos.offset(blueprint.getSizeX() - 1, blueprint.getSizeY() - 1, blueprint.getSizeZ() - 1)).inflate((double)(2 + (Integer)((ClientConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getClient()).neighborbuildingrange.get()));
            for (IBuildingView buildingView : ctx.nearestColony.getBuildings()) {
                BlockPos cornerB;
                TileEntityColonyBuilding tileEntityColonyBuilding;
                Tuple corners;
                BlockPos cornerA;
                BlockPos currentPosition = buildingView.getPosition();
                BlockEntity blockEntity = ctx.clientLevel.getBlockEntity(currentPosition);
                if (!(blockEntity instanceof TileEntityColonyBuilding) || !blueprintAABB.intersects(AABB.encapsulatingFullBlocks((BlockPos)(cornerA = (BlockPos)(corners = (tileEntityColonyBuilding = (TileEntityColonyBuilding)blockEntity).getInWorldCorners()).getA()), (BlockPos)(cornerB = (BlockPos)corners.getB())))) continue;
                Object schemPath = buildingView.getStructurePath();
                if (((String)(schemPath = ((String)schemPath).replace(".blueprint", ""))).isEmpty()) continue;
                schemPath = ((String)schemPath).substring(0, ((String)schemPath).length() - 1) + buildingView.getBuildingMaxLevel() + ".blueprint";
                String structurePack = buildingView.getStructurePack();
                BlueprintCacheKey key = new BlueprintCacheKey(structurePack, (String)schemPath, buildingView.getRotationMirror());
                desired.put(currentPosition, new PendingRenderData(key, currentPosition, 0, buildingView.getBuildingLevel() >= buildingView.getBuildingMaxLevel(), true));
            }
            return desired;
        }
    }

    private static class BuildGoggles
    implements IRenderBlueprintRule {
        private BuildGoggles() {
        }

        @Override
        public boolean isEnabled(WorldEventContext ctx) {
            return ctx.clientPlayer.getItemBySlot(EquipmentSlot.HEAD).is(com.minecolonies.api.items.ModItems.buildGoggles);
        }

        @Override
        public Map<BlockPos, PendingRenderData> getDesiredBlueprints(WorldEventContext ctx) {
            double range = MathUtils.square(((Integer)((ClientConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getClient()).buildgogglerange.get()).intValue());
            HashMap<BlockPos, PendingRenderData> desired = new HashMap<BlockPos, PendingRenderData>();
            for (IWorkOrderView workOrder : ctx.nearestColony.getWorkOrders()) {
                if (!(workOrder.getLocation().distSqr((Vec3i)ctx.clientPlayer.blockPosition()) < range)) continue;
                int builder = this.getBuilderId(ctx.nearestColony, workOrder.getClaimedBy());
                BlueprintCacheKey key = new BlueprintCacheKey(workOrder.getStructurePack(), workOrder.getStructurePath(), workOrder.getRotationMirror());
                desired.put(workOrder.getLocation(), new PendingRenderData(key, workOrder.getLocation(), builder, workOrder.getWorkOrderType() == WorkOrderType.REMOVE, workOrder instanceof WorkOrderBuildingView));
            }
            for (IBuildingView building : ctx.nearestColony.getBuildings()) {
                if (desired.containsKey(building.getPosition()) || building.getBuildingLevel() != 0 || building.getBuildingMaxLevel() <= 0 || !(building.getPosition().distSqr((Vec3i)ctx.clientPlayer.blockPosition()) < range)) continue;
                desired.put(building.getPosition(), new PendingRenderData(null, building.getPosition(), 0, true, true));
            }
            return desired;
        }

        private int getBuilderId(IColonyView colony, BlockPos builderPos) {
            Set<Integer> builders;
            IBuildingView builderView;
            if (builderPos != null && !builderPos.equals((Object)BlockPos.ZERO) && (builderView = colony.getBuilding(builderPos)) != null && !(builders = builderView.getAllAssignedCitizens()).isEmpty()) {
                return builders.iterator().next();
            }
            return 0;
        }
    }

    private static class AssistantHammerPreview
    implements IRenderBlueprintRule {
        private AssistantHammerPreview() {
        }

        @Override
        public boolean isEnabled(WorldEventContext ctx) {
            return ctx.clientPlayer.getMainHandItem().getItem() instanceof ItemAssistantHammer;
        }

        @Override
        public Map<BlockPos, PendingRenderData> getDesiredBlueprints(WorldEventContext ctx) {
            HashMap<BlockPos, PendingRenderData> desired = new HashMap<BlockPos, PendingRenderData>();
            for (IWorkOrderView workOrder : ctx.nearestColony.getWorkOrders()) {
                if (!workOrder.getBoundingBox().inflate(8.0).contains(ctx.clientPlayer.position())) continue;
                BlueprintCacheKey key = new BlueprintCacheKey(workOrder.getStructurePack(), workOrder.getStructurePath(), workOrder.getRotationMirror());
                desired.put(workOrder.getLocation(), new PendingRenderData(key, workOrder.getLocation(), -1, false, true));
                workOrder.loadBlueprint((Level)ctx.clientLevel, blueprint -> {
                    IBuildingView building;
                    if (blueprint == null) {
                        return;
                    }
                    BlueprintPreviewData blueprintPreviewData = new BlueprintPreviewData(false);
                    blueprintPreviewData.setPos(workOrder.getLocation());
                    blueprintPreviewData.setRotationMirror(blueprint.getRotationMirror());
                    blueprintPreviewData.setBlueprint(blueprint);
                    blueprintPreviewData.setOverridePreviewTransparency(0.4f);
                    BlockPos workerPos = workOrder.getClaimedBy();
                    if (!workerPos.equals((Object)BlockPos.ZERO) && (building = ctx.nearestColony.getBuilding(workerPos)) != null && building.getModuleView(BuildingModules.BUILDER_SETTINGS) != null) {
                        blueprintPreviewData.setSolidSubstitutionOverride(building.getModuleView(BuildingModules.BUILDER_SETTINGS).getSetting(BuildingMiner.FILL_BLOCK).getValue().getBlock().defaultBlockState());
                    }
                    blueprintDataCache.put((Object)key, (Object)blueprintPreviewData);
                });
            }
            return desired;
        }
    }
}

