/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render;

import com.ldtteam.structurize.blocks.ModBlocks;
import com.minecolonies.core.blocks.decorative.BlockColonyFlagBanner;
import com.minecolonies.core.blocks.decorative.BlockColonyFlagWallBanner;
import com.minecolonies.core.tileentities.TileEntityColonyFlag;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TileEntityColonyFlagRenderer
implements BlockEntityRenderer<TileEntityColonyFlag> {
    private final ModelPart cloth;
    private final ModelPart standPost;
    private final ModelPart crossbar;

    public TileEntityColonyFlagRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.bakeLayer(ModelLayers.BANNER);
        this.cloth = modelpart.getChild("flag");
        this.standPost = modelpart.getChild("pole");
        this.crossbar = modelpart.getChild("bar");
    }

    public void render(TileEntityColonyFlag flagIn, float partialTicks, PoseStack transform, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        long i;
        BannerPatternLayers list = flagIn.getPatterns();
        boolean noWorld = flagIn.getLevel() == null;
        transform.pushPose();
        if (noWorld) {
            i = 0L;
            transform.translate(0.5, 0.5, 0.5);
            this.standPost.visible = true;
        } else {
            i = flagIn.getLevel().getGameTime();
            BlockState blockstate = flagIn.getBlockState();
            if (blockstate.getBlock() instanceof BlockColonyFlagBanner) {
                transform.translate(0.5, 0.5, 0.5);
                float f1 = (float)(-((Integer)blockstate.getValue((Property)BlockColonyFlagBanner.ROTATION)).intValue() * 360) / 16.0f;
                transform.mulPose(Axis.YP.rotationDegrees(f1));
                this.standPost.visible = true;
            } else if (blockstate.getBlock() instanceof BlockColonyFlagWallBanner) {
                transform.translate(0.5, -0.1666666716337204, 0.5);
                float f3 = -((Direction)blockstate.getValue((Property)BlockColonyFlagWallBanner.HORIZONTAL_FACING)).toYRot();
                transform.mulPose(Axis.YP.rotationDegrees(f3));
                transform.translate(0.0, -0.3125, -0.4375);
                this.standPost.visible = false;
            }
            Minecraft mc = Minecraft.getInstance();
            if (mc.player.getMainHandItem().getItem() instanceof BannerItem && mc.gameMode.getPlayerMode() == GameType.CREATIVE) {
                transform.pushPose();
                ItemStack placeholder = new ItemStack((ItemLike)ModBlocks.blockSubstitution.get());
                transform.translate(0.0, 0.5, 0.0);
                transform.scale(0.75f, 0.75f, 0.75f);
                Minecraft.getInstance().getItemRenderer().renderStatic(placeholder, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, transform, bufferIn, (Level)mc.level, OverlayTexture.NO_OVERLAY);
                transform.popPose();
            }
        }
        transform.pushPose();
        transform.scale(0.6666667f, -0.6666667f, -0.6666667f);
        VertexConsumer ivertexbuilder = ModelBakery.BANNER_BASE.buffer(bufferIn, RenderType::entitySolid);
        this.standPost.render(transform, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        this.crossbar.render(transform, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        BlockPos blockpos = flagIn.getBlockPos();
        float f2 = ((float)Math.floorMod((long)(blockpos.getX() * 7 + blockpos.getY() * 9 + blockpos.getZ() * 13) + i, 100L) + partialTicks) / 100.0f;
        this.cloth.xRot = (-0.0125f + 0.01f * Mth.cos((float)((float)Math.PI * 2 * f2))) * (float)Math.PI;
        this.cloth.y = -32.0f;
        BannerRenderer.renderPatterns((PoseStack)transform, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn, (ModelPart)this.cloth, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)DyeColor.WHITE, (BannerPatternLayers)list);
        transform.popPose();
        transform.popPose();
    }
}

