/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render;

import com.minecolonies.api.client.render.modeltype.CitizenModel;
import com.minecolonies.api.client.render.modeltype.IModelType;
import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.client.render.modeltype.registry.IModelTypeRegistry;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.apiimp.initializer.ModModelTypeInitializer;
import com.minecolonies.core.client.render.CitizenArmorLayer;
import com.minecolonies.core.client.render.RenderUtils;
import com.minecolonies.core.client.render.worldevent.RenderTypes;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class RenderBipedCitizen
extends MobRenderer<AbstractEntityCitizen, CitizenModel<AbstractEntityCitizen>> {
    private static final double SHADOW_SIZE = 0.5;
    public static boolean isItGhostTime = false;

    public RenderBipedCitizen(EntityRendererProvider.Context context) {
        super(context, new CitizenModel(context.bakeLayer(ModelLayers.PLAYER)), 0.5f);
        this.addLayer((RenderLayer)new CitizenArmorLayer(this, new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager(), context.getModelSet()));
        super.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        ModModelTypeInitializer.init(context);
    }

    public void render(@NotNull AbstractEntityCitizen citizen, float limbSwing, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource renderTypeBuffer, int light) {
        this.setupMainModelFrom(citizen);
        CitizenModel citizenModel = (CitizenModel)this.model;
        citizenModel.rightArmPose = RenderUtils.getArmPose((Mob)citizen, InteractionHand.MAIN_HAND);
        citizenModel.leftArmPose = RenderUtils.getArmPose((Mob)citizen, InteractionHand.OFF_HAND);
        if (isItGhostTime) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            super.render((LivingEntity)citizen, limbSwing, partialTicks, matrixStack, renderTypeBuffer, light);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        } else {
            super.render((LivingEntity)citizen, limbSwing, partialTicks, matrixStack, renderTypeBuffer, light);
        }
    }

    private void setupMainModelFrom(@NotNull AbstractEntityCitizen citizen) {
        IModelType modelType = IModelTypeRegistry.getInstance().getModelType(citizen.getModelType());
        Object object = this.model = citizen.isFemale() ? modelType.getFemaleModel() : modelType.getMaleModel();
        if (this.model == null) {
            Object object2 = this.model = citizen.isFemale() ? modelType.getFemaleModel() : modelType.getMaleModel();
        }
        if (citizen.getCitizenDataView() != null && citizen.getCitizenDataView().getCustomTexture() != null) {
            this.model = IModelTypeRegistry.getInstance().getModelType(ModModelTypes.CUSTOM_ID).getMaleModel();
        }
        ((CitizenModel)this.model).young = citizen.isBaby();
        ((CitizenModel)this.model).riding = citizen.getVehicle() != null;
        ((CitizenModel)this.model).attackTime = citizen.attackAnim;
    }

    protected void renderNameTag(@NotNull AbstractEntityCitizen entityIn, @NotNull Component str, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int packedLight, float partialTick) {
        double distance;
        super.renderNameTag((Entity)entityIn, str, matrixStack, buffer, packedLight, partialTick);
        if (entityIn.getCitizenDataView() != null && entityIn.getCitizenDataView().hasVisibleStatus() && (distance = this.entityRenderDispatcher.distanceToSqr(entityIn.getX(), entityIn.getY(), entityIn.getZ())) <= 4096.0) {
            Vec3 vec3 = entityIn.getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, entityIn.getViewYRot(partialTick));
            matrixStack.pushPose();
            matrixStack.translate(vec3.x, vec3.y + 0.9, vec3.z);
            matrixStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            matrixStack.scale(0.025f, -0.025f, 0.025f);
            Matrix4f pose = matrixStack.last().pose();
            VertexConsumer r = buffer.getBuffer(RenderTypes.worldEntityIcon(entityIn.getCitizenDataView().getStatusIcon()));
            r.addVertex(pose, -5.0f, 0.0f, 0.0f).setUv(0.0f, 0.0f);
            r.addVertex(pose, -5.0f, 10.0f, 0.0f).setUv(0.0f, 1.0f);
            r.addVertex(pose, 5.0f, 10.0f, 0.0f).setUv(1.0f, 1.0f);
            r.addVertex(pose, 5.0f, 0.0f, 0.0f).setUv(1.0f, 0.0f);
            matrixStack.popPose();
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(AbstractEntityCitizen entity) {
        if (entity.getCitizenDataView() != null && entity.getCitizenDataView().getCustomTexture() != null) {
            return entity.getCitizenDataView().getCustomTexture();
        }
        return entity.getTexture();
    }
}

