/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.townhall;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonHandler;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.core.colony.CitizenData;
import com.minecolonies.core.network.messages.server.colony.HireMercenaryMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public class WindowTownHallMercenary
extends BOWindow
implements ButtonHandler {
    private static final String TOWNHALL_NAME_RESOURCE_SUFFIX = ":gui/townhall/windowtownhallmercenary.xml";
    private final IColonyView colony;

    public WindowTownHallMercenary(IColonyView c) {
        super(ResourceLocation.parse((String)"minecolonies:gui/townhall/windowtownhallmercenary.xml"));
        this.colony = c;
        int amountOfMercenaries = this.colony.getCitizenCount();
        amountOfMercenaries /= 10;
        amountOfMercenaries += 3;
        int startX = 160;
        int startY = 40;
        for (int i = 0; i < Math.min(amountOfMercenaries, 9); ++i) {
            Image newImage = new Image();
            newImage.setImage(new ResourceLocation("minecolonies", "textures/entity_icon/citizen/default/citizenmale3" + CitizenData.SUFFIXES.get(ColonyConstants.rand.nextInt(CitizenData.SUFFIXES.size())) + ".png"), false);
            newImage.setSize(10, 10);
            newImage.setPosition(startX, 40);
            this.addChild((Pane)newImage);
            startX += 15;
        }
    }

    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals("done")) {
            this.colony.usedMercenaries();
            new HireMercenaryMessage(this.colony).sendToServer();
            Minecraft.getInstance().player.playSound(SoundEvents.LIGHTNING_BOLT_THUNDER, 1.0f, 1.0f);
        }
        this.close();
    }
}

