/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Gradient;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.core.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import com.minecolonies.core.network.messages.server.colony.building.worker.ChangeRecipePriorityMessage;
import com.minecolonies.core.network.messages.server.colony.building.worker.ToggleRecipeMessage;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class WindowListRecipes
extends AbstractModuleWindow {
    private static final String RECIPE_LIST = "recipes";
    private static final String RECIPE_STATUS = "recipestatus";
    private static final String OUTPUT_ICON = "output";
    private static final String RESOURCE = "res%d";
    private final CraftingModuleView module;
    private final ScrollingList recipeList;
    private static final String BUTTON_CRAFTING = "crafting";
    private final Text recipeStatus;
    private int lifeCount = 0;

    public WindowListRecipes(IBuildingView view, String name, CraftingModuleView module) {
        super(view, name);
        this.module = module;
        this.recipeList = (ScrollingList)this.findPaneOfTypeByID(RECIPE_LIST, ScrollingList.class);
        this.recipeStatus = (Text)this.findPaneOfTypeByID(RECIPE_STATUS, Text.class);
        ((ButtonImage)this.findPaneOfTypeByID(BUTTON_CRAFTING, ButtonImage.class)).setVisible(module.isRecipeAlterationAllowed());
        ((Text)this.findPaneOfTypeByID(RECIPE_STATUS, Text.class)).setVisible(module.isRecipeAlterationAllowed());
        super.registerButton(BUTTON_CRAFTING, this::craftingClicked);
        super.registerButton("remove", this::removeClicked);
        super.registerButton("up", this::forwardClicked);
        super.registerButton("down", this::backwardClicked);
        super.registerButton("toggle", this::toggleRecipe);
    }

    private void toggleRecipe(Button button) {
        int row = this.recipeList.getListElementIndexByPane((Pane)button);
        this.module.toggle(row);
        new ToggleRecipeMessage(this.buildingView, row, this.module.getProducer().getRuntimeID()).sendToServer();
    }

    private void backwardClicked(Button button) {
        boolean shift = InputConstants.isKeyDown((long)this.mc.getWindow().getWindow(), (int)340);
        int row = this.recipeList.getListElementIndexByPane((Pane)button);
        this.module.switchOrder(row, row + 1, shift);
        new ChangeRecipePriorityMessage(this.buildingView, row, false, this.module.getProducer().getRuntimeID(), shift).sendToServer();
        this.recipeList.refreshElementPanes();
    }

    private void forwardClicked(Button button) {
        boolean shift = InputConstants.isKeyDown((long)this.mc.getWindow().getWindow(), (int)340);
        int row = this.recipeList.getListElementIndexByPane((Pane)button);
        this.module.switchOrder(row, row - 1, shift);
        new ChangeRecipePriorityMessage(this.buildingView, row, true, this.module.getProducer().getRuntimeID(), shift).sendToServer();
        this.recipeList.refreshElementPanes();
    }

    private void removeClicked(Button button) {
        int row = this.recipeList.getListElementIndexByPane((Pane)button);
        IRecipeStorage data = this.module.getRecipes().get(row);
        new AddRemoveRecipeMessage(this.buildingView, true, data, this.module.getProducer().getRuntimeID()).sendToServer();
    }

    public void craftingClicked() {
        if (!this.module.isRecipeAlterationAllowed()) {
            return;
        }
        this.module.openCraftingGUI();
    }

    public void onOpened() {
        this.recipeList.enable();
        this.recipeList.show();
        this.recipeList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowListRecipes.this.module.getRecipes().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                Button removeButton;
                @NotNull IRecipeStorage recipe = WindowListRecipes.this.module.getRecipes().get(index);
                ItemIcon icon = (ItemIcon)rowPane.findPaneOfTypeByID(WindowListRecipes.OUTPUT_ICON, ItemIcon.class);
                List<ItemStack> displayStacks = recipe.getRecipeType().getOutputDisplayStacks();
                icon.setItem(displayStacks.get(WindowListRecipes.this.lifeCount / 30 % displayStacks.size()));
                if (!WindowListRecipes.this.module.isRecipeAlterationAllowed() && (removeButton = (Button)rowPane.findPaneOfTypeByID("remove", Button.class)) != null) {
                    removeButton.setVisible(false);
                }
                Text intermediate = (Text)rowPane.findPaneOfTypeByID("intermediate", Text.class);
                intermediate.setVisible(false);
                if (recipe.getRequiredTool() != ModEquipmentTypes.none.get()) {
                    intermediate.setText(recipe.getRequiredTool().getDisplayName());
                    intermediate.setVisible(true);
                } else if (recipe.getIntermediate() != Blocks.AIR) {
                    intermediate.setText(recipe.getIntermediate().getName());
                }
                if (WindowListRecipes.this.module.isDisabled(recipe)) {
                    ((Gradient)rowPane.findPaneOfTypeByID("gradient", Gradient.class)).setVisible(true);
                    ((Button)rowPane.findPaneOfTypeByID("toggle", Button.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.recipe.enable", (Object[])new Object[0]));
                } else {
                    ((Gradient)rowPane.findPaneOfTypeByID("gradient", Gradient.class)).setVisible(false);
                    ((Button)rowPane.findPaneOfTypeByID("toggle", Button.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.recipe.disable", (Object[])new Object[0]));
                }
                if (recipe.getInput().size() < 4) {
                    for (int i = 0; i < 9; ++i) {
                        if (i < recipe.getInput().size()) {
                            ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, i + 1), ItemIcon.class)).setItem(WindowListRecipes.this.getStackWithCount(recipe.getInput().get(i)));
                            continue;
                        }
                        ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, i + 1), ItemIcon.class)).setItem(ItemStack.EMPTY);
                    }
                } else if (recipe.getInput().size() == 4) {
                    ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, 1), ItemIcon.class)).setItem(WindowListRecipes.this.getStackWithCount(recipe.getInput().get(0)));
                    ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, 2), ItemIcon.class)).setItem(WindowListRecipes.this.getStackWithCount(recipe.getInput().get(1)));
                    ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, 3), ItemIcon.class)).setItem(ItemStack.EMPTY);
                    ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, 4), ItemIcon.class)).setItem(WindowListRecipes.this.getStackWithCount(recipe.getInput().get(2)));
                    ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, 5), ItemIcon.class)).setItem(WindowListRecipes.this.getStackWithCount(recipe.getInput().get(3)));
                    for (int i = 6; i < 9; ++i) {
                        ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, i + 1), ItemIcon.class)).setItem(ItemStack.EMPTY);
                    }
                } else {
                    for (int i = 0; i < Math.min(9, recipe.getInput().size()); ++i) {
                        ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, i + 1), ItemIcon.class)).setItem(WindowListRecipes.this.getStackWithCount(recipe.getInput().get(i)));
                    }
                }
            }
        });
    }

    private ItemStack getStackWithCount(ItemStorage storage) {
        ItemStack displayItem = storage.getItemStack();
        displayItem.setCount(storage.getAmount());
        return displayItem;
    }

    public void onUpdate() {
        super.onUpdate();
        if (!Screen.hasShiftDown()) {
            ++this.lifeCount;
        }
        this.recipeStatus.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.recipestatus", (Object[])new Object[]{this.module.getRecipes().size(), this.module.getMaxRecipes()}));
        ((ScrollingList)this.window.findPaneOfTypeByID(RECIPE_LIST, ScrollingList.class)).refreshElementPanes();
    }
}

