/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IStackBasedTask;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.IDeliverymanRequestable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildings.moduleviews.RequestTaskModuleView;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WindowHutRequestTaskModule
extends AbstractModuleWindow {
    private static final String LIST_TASKS = "tasks";

    public WindowHutRequestTaskModule(IBuildingView view, String name) {
        super(view, name);
    }

    public void onOpened() {
        super.onOpened();
        final List<IToken<?>> tasks = this.buildingView.getModuleViewByType(RequestTaskModuleView.class).getTasks();
        ((ScrollingList)this.findPaneOfTypeByID(LIST_TASKS, ScrollingList.class)).setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                tasks.removeIf(token -> WindowHutRequestTaskModule.this.buildingView.getColony().getRequestManager().getRequestForToken((IToken<?>)token) == null);
                return tasks.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                IRequest<?> tempParent;
                IRequest<?> request = WindowHutRequestTaskModule.this.buildingView.getColony().getRequestManager().getRequestForToken((IToken)tasks.get(index));
                IRequest<?> parent = WindowHutRequestTaskModule.this.buildingView.getColony().getRequestManager().getRequestForToken((IToken<?>)request.getParent());
                while (parent != null && parent.getRequester().getLocation().equals(request.getRequester().getLocation()) && (tempParent = WindowHutRequestTaskModule.this.buildingView.getColony().getRequestManager().getRequestForToken((IToken<?>)parent.getParent())) != null) {
                    parent = tempParent;
                }
                if (parent == null) {
                    ((Text)rowPane.findPaneOfTypeByID("requester", Text.class)).setText(request.getRequester().getRequesterDisplayName(WindowHutRequestTaskModule.this.buildingView.getColony().getRequestManager(), request));
                } else {
                    ((Text)rowPane.findPaneOfTypeByID("requester", Text.class)).setText(Component.literal((String)(request.getRequester().getRequesterDisplayName(WindowHutRequestTaskModule.this.buildingView.getColony().getRequestManager(), request).getString() + " -> " + parent.getRequester().getRequesterDisplayName(WindowHutRequestTaskModule.this.buildingView.getColony().getRequestManager(), parent).getString())));
                    PaneBuilders.tooltipBuilder().hoverPane(rowPane.findPaneOfTypeByID("requester", Text.class)).build().setText(Component.literal((String)(request.getRequester().getLocation().getInDimensionLocation().toShortString() + " -> " + parent.getRequester().getLocation().getInDimensionLocation().toShortString())));
                }
                if (request instanceof IStackBasedTask) {
                    ItemIcon icon = (ItemIcon)rowPane.findPaneOfTypeByID("detailIcon", ItemIcon.class);
                    ItemStack copyStack = ((IStackBasedTask)((Object)request)).getTaskStack().copy();
                    copyStack.setCount(((IStackBasedTask)((Object)request)).getDisplayCount());
                    icon.setItem(copyStack);
                    icon.setVisible(true);
                    ((Text)rowPane.findPaneOfTypeByID("shortDetail", Text.class)).setText(((IStackBasedTask)((Object)request)).getDisplayPrefix().withStyle(request.getState() == RequestState.IN_PROGRESS ? ChatFormatting.DARK_GREEN : ChatFormatting.BLACK));
                } else {
                    ((ItemIcon)rowPane.findPaneOfTypeByID("detailIcon", ItemIcon.class)).setVisible(false);
                    ((Text)rowPane.findPaneOfTypeByID("shortDetail", Text.class)).setText(Component.literal((String)request.getShortDisplayString().getString().replace("\u00a7f", "")).withStyle(request.getState() == RequestState.IN_PROGRESS ? ChatFormatting.DARK_GREEN : ChatFormatting.BLACK));
                }
                if (request.getRequest() instanceof IDeliverymanRequestable) {
                    ((Text)rowPane.findPaneOfTypeByID("priority", Text.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.deliveryman.priority", (Object[])new Object[0]).append(String.valueOf(((IDeliverymanRequestable)request.getRequest()).getPriority())));
                }
                Image logo = (Image)rowPane.findPaneOfTypeByID("deliveryImage", Image.class);
                logo.setImage(request.getDisplayIcon(), false);
            }
        });
    }
}

