/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildings.moduleviews.MinerLevelManagementModuleView;
import com.minecolonies.core.network.messages.server.colony.building.miner.MinerRepairLevelMessage;
import com.minecolonies.core.network.messages.server.colony.building.miner.MinerSetLevelMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class WindowHutMinerModule
extends AbstractModuleWindow {
    private static final String LIST_LEVELS = "levels";
    private static final String TEXT_LEVEL = "level";
    private static final String BUTTON_MINE_LEVEL = "mine";
    private static final String BUTTON_REPAIR = "repair";
    private static final String TEXT_DEPTH = "depth";
    private static final String TEXT_NODE_COUNT = "nodes";
    private static final String HUT_MINER_RESOURCE_SUFFIX = ":gui/layouthuts/layoutminermodule.xml";
    private final MinerLevelManagementModuleView miner;
    private ScrollingList levelList;

    public WindowHutMinerModule(IBuildingView building, MinerLevelManagementModuleView moduleView) {
        super(building, "minecolonies:gui/layouthuts/layoutminermodule.xml");
        this.miner = moduleView;
        this.registerButton(BUTTON_REPAIR, this::repairClicked);
        this.registerButton(BUTTON_MINE_LEVEL, this::mineLevelClicked);
    }

    private void repairClicked(Button button) {
        int row = this.levelList.getListElementIndexByPane((Pane)button);
        new MinerRepairLevelMessage(this.buildingView, row).sendToServer();
        MessageUtils.format("com.minecolonies.coremod.gui.workerhuts.miner.repair.enqueued", new Object[0]).sendTo(new Player[]{Minecraft.getInstance().player});
    }

    private void mineLevelClicked(Button button) {
        int row = this.levelList.getListElementIndexByPane((Pane)button);
        if (row != this.miner.current && row >= 0 && row < this.miner.levelsInfo.size()) {
            this.miner.current = row;
            new MinerSetLevelMessage(this.buildingView, row).sendToServer();
        }
    }

    public void onOpened() {
        super.onOpened();
        this.levelList = (ScrollingList)this.findPaneOfTypeByID(LIST_LEVELS, ScrollingList.class);
        this.levelList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowHutMinerModule.this.miner.levelsInfo.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                boolean isCurrentLevel = index == WindowHutMinerModule.this.miner.current;
                ((Text)rowPane.findPaneOfTypeByID(WindowHutMinerModule.TEXT_LEVEL, Text.class)).setText(Component.literal((String)String.format("%02d", index + 1)));
                ((Button)rowPane.findPaneOfTypeByID(WindowHutMinerModule.BUTTON_REPAIR, Button.class)).setEnabled(!WindowHutMinerModule.this.miner.doesWorkOrderExist(index));
                ((Button)rowPane.findPaneOfTypeByID(WindowHutMinerModule.BUTTON_MINE_LEVEL, Button.class)).setEnabled(!isCurrentLevel);
                ((Text)rowPane.findPaneOfTypeByID(WindowHutMinerModule.TEXT_DEPTH, Text.class)).setText(Component.translatable((String)"com.minecolonies.coremod.gui.workerhuts.minerleveldepth").append((Component)Component.literal((String)": ")).append((Component)Component.literal((String)String.valueOf((Integer)WindowHutMinerModule.this.miner.levelsInfo.get(index).getB() + 1))));
                ((Text)rowPane.findPaneOfTypeByID(WindowHutMinerModule.TEXT_NODE_COUNT, Text.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.minernode", (Object[])new Object[0]).append(": ").append(String.valueOf(WindowHutMinerModule.this.miner.levelsInfo.get(index).getA())));
            }
        });
    }
}

