/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.client.gui.WindowResearchTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class UniversityModuleWindow
extends AbstractModuleWindow {
    public UniversityModuleWindow(IBuildingView building) {
        super(building, "minecolonies:gui/layouthuts/layoutuniversity.xml");
        List<ResourceLocation> inputBranches = IGlobalResearchTree.getInstance().getBranches();
        inputBranches.sort(Comparator.comparingInt(branchId -> IGlobalResearchTree.getInstance().getBranchData((ResourceLocation)branchId).getSortOrder()));
        ArrayList<ResourceLocation> visibleBranches = new ArrayList<ResourceLocation>();
        ArrayList<List<MutableComponent>> allReqs = new ArrayList<List<MutableComponent>>();
        for (ResourceLocation branch : inputBranches) {
            List<MutableComponent> requirements = this.getHidingRequirementDesc(branch);
            if (!requirements.isEmpty() && IGlobalResearchTree.getInstance().getBranchData(branch).getHidden()) continue;
            visibleBranches.add(branch);
            allReqs.add(requirements);
        }
        ScrollingList researchList = (ScrollingList)this.findPaneOfTypeByID("researches", ScrollingList.class);
        researchList.setDataProvider((ScrollingList.DataProvider)new ResearchListProvider(visibleBranches, allReqs));
        this.updateResearchCount(0);
    }

    public List<MutableComponent> getHidingRequirementDesc(ResourceLocation branch) {
        ArrayList<MutableComponent> requirements = new ArrayList<MutableComponent>();
        for (ResourceLocation primary : IGlobalResearchTree.getInstance().getPrimaryResearch(branch)) {
            if (!IGlobalResearchTree.getInstance().getResearch(branch, primary).isHidden() || IGlobalResearchTree.getInstance().isResearchRequirementsFulfilled(IGlobalResearchTree.getInstance().getResearch(branch, primary).getResearchRequirements(), this.buildingView.getColony())) {
                return Collections.EMPTY_LIST;
            }
            if (requirements.isEmpty()) {
                requirements.add(Component.translatableEscape((String)"com.minecolonies.coremod.research.locked", (Object[])new Object[0]));
            } else {
                requirements.add(Component.translatableEscape((String)"Or", (Object[])new Object[0]).setStyle(Style.EMPTY.withColor(ChatFormatting.BLUE)));
            }
            for (IResearchRequirement req : IGlobalResearchTree.getInstance().getResearch(branch, primary).getResearchRequirements()) {
                if (!req.isFulfilled(this.buildingView.getColony())) {
                    requirements.add(Component.literal((String)"-").append((Component)req.getDesc().setStyle(Style.EMPTY.withColor(ChatFormatting.RED))));
                    continue;
                }
                requirements.add(Component.literal((String)"-").append((Component)req.getDesc().setStyle(Style.EMPTY.withColor(ChatFormatting.AQUA))));
            }
        }
        return requirements;
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        ResourceLocation id;
        super.onButtonClicked(button);
        ResourceLocation resourceLocation = id = button.getParent() == null ? null : ResourceLocation.tryParse((String)button.getParent().getID());
        if (id != null && IGlobalResearchTree.getInstance().getBranches().contains(id)) {
            new WindowResearchTree(id, this.buildingView, this).open();
        }
    }

    public void updateResearchCount(int offset) {
        ((Text)this.findPaneOfTypeByID("maxresearchwarn", Text.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.research.countinprogress", (Object[])new Object[]{this.buildingView.getColony().getResearchManager().getResearchTree().getResearchInProgress().size() + offset, this.buildingView.getBuildingLevel()}));
        if (this.buildingView.getBuildingLevel() <= this.buildingView.getColony().getResearchManager().getResearchTree().getResearchInProgress().size() + offset) {
            ((Text)this.findPaneOfTypeByID("maxresearchwarn", Text.class)).setColors(Color.getByName((String)"red", (int)0));
        } else {
            ((Text)this.findPaneOfTypeByID("maxresearchwarn", Text.class)).setColors(Color.getByName((String)"black", (int)0));
        }
    }

    private static class ResearchListProvider
    implements ScrollingList.DataProvider {
        private final List<ResourceLocation> branches;
        private final List<List<MutableComponent>> requirements;

        ResearchListProvider(List<ResourceLocation> branches, List<List<MutableComponent>> requirements) {
            this.branches = branches;
            this.requirements = requirements;
        }

        public int getElementCount() {
            return this.branches.size();
        }

        public void updateElement(int index, Pane rowPane) {
            ButtonImage button = (ButtonImage)rowPane.findPaneOfTypeByID("name", ButtonImage.class);
            button.getParent().setID(this.branches.get(index).toString());
            if (this.requirements.get(index).isEmpty()) {
                button.setText(MutableComponent.create((ComponentContents)IGlobalResearchTree.getInstance().getBranchData(this.branches.get(index)).getName()));
            } else {
                button.setText(Component.translatableEscape((String)"----------", (Object[])new Object[0]));
                button.disable();
            }
            if (!(button.getHoverPane() != null || this.requirements.get(index).isEmpty() && IGlobalResearchTree.getInstance().getBranchData(this.branches.get(index)).getSubtitle().getKey().isEmpty())) {
                AbstractTextBuilder.TooltipBuilder hoverText = PaneBuilders.tooltipBuilder().hoverPane((Pane)button);
                if (!IGlobalResearchTree.getInstance().getBranchData(this.branches.get(index)).getSubtitle().getKey().isEmpty()) {
                    ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverText.append(MutableComponent.create((ComponentContents)IGlobalResearchTree.getInstance().getBranchData(this.branches.get(index)).getSubtitle()))).colorName("GRAY")).paragraphBreak();
                }
                if (!this.requirements.get(index).isEmpty()) {
                    for (MutableComponent req : this.requirements.get(index)) {
                        ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverText.append(req)).color(ResearchConstants.COLOR_TEXT_UNFULFILLED)).paragraphBreak();
                    }
                }
                hoverText.build();
            }
        }
    }
}

