/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildings.moduleviews.EnchanterStationsModuleView;
import com.minecolonies.core.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.NotNull;

public class EnchanterStationModuleWindow
extends AbstractModuleWindow {
    private static final String RESOURCE_STRING = ":gui/layouthuts/layoutenchanter.xml";
    private static final String LIST_WORKERS = "gatherWorkers";
    private static final String WORKER_NAME = "workerName";
    private final EnchanterStationsModuleView module;
    private ScrollingList workerList;
    private List<BlockPos> selectedBuildings;
    private List<IBuildingView> allBuildings;

    public EnchanterStationModuleWindow(IBuildingView building, EnchanterStationsModuleView module) {
        super(building, "minecolonies:gui/layouthuts/layoutenchanter.xml");
        super.registerButton("switch", this::switchClicked);
        this.module = module;
    }

    public void onOpened() {
        super.onOpened();
        this.selectedBuildings = this.module.getBuildingsToGatherFrom();
        this.allBuildings = this.buildingView.getColony().getBuildings().stream().filter(b -> b instanceof AbstractBuildingView && !b.getModuleViews(WorkerBuildingModuleView.class).isEmpty() && b.getBuildingType() != ModBuildings.enchanter.get()).sorted((b1, b2) -> (int)(BlockPosUtil.getDistance2D(this.buildingView.getPosition(), b1.getPosition()) - BlockPosUtil.getDistance2D(this.buildingView.getPosition(), b2.getPosition()))).collect(Collectors.toList());
        this.workerList = (ScrollingList)this.findPaneOfTypeByID(LIST_WORKERS, ScrollingList.class);
        this.workerList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return EnchanterStationModuleWindow.this.allBuildings.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                IBuildingView bView = EnchanterStationModuleWindow.this.allBuildings.get(index);
                Object text = "";
                if (bView instanceof AbstractBuildingView) {
                    text = (String)text + (bView.getCustomName().isEmpty() ? Component.translatableEscape((String)bView.getBuildingType().getTranslationKey(), (Object[])new Object[0]).getString() : bView.getCustomName());
                    text = (String)text + " " + BlockPosUtil.getDistance2D(EnchanterStationModuleWindow.this.buildingView.getPosition(), bView.getPosition()) + "m";
                    ((Text)rowPane.findPaneOfTypeByID(EnchanterStationModuleWindow.WORKER_NAME, Text.class)).setText(Component.literal((String)text));
                    Button switchButton = (Button)rowPane.findPaneOfTypeByID("switch", Button.class);
                    if (EnchanterStationModuleWindow.this.selectedBuildings.contains(bView.getID())) {
                        switchButton.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon", (Object[])new Object[0]));
                    } else {
                        switchButton.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.retrieveoff", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    private void switchClicked(@NotNull Button button) {
        String buttonText;
        int row = this.workerList.getListElementIndexByPane((Pane)button);
        String string = buttonText = button.getText().getContents() instanceof TranslatableContents ? ((TranslatableContents)button.getText().getContents()).getKey() : button.getTextAsString();
        if (buttonText.equals("com.minecolonies.coremod.gui.workerhuts.retrieveoff")) {
            button.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon", (Object[])new Object[0]));
            this.module.addWorker(this.allBuildings.get(row).getID());
        } else {
            button.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.retrieveoff", (Object[])new Object[0]));
            this.module.removeWorker(this.allBuildings.get(row).getID());
        }
        this.selectedBuildings = this.module.getBuildingsToGatherFrom();
        this.workerList.refreshElementPanes();
    }
}

