/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.containers;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesRack;
import com.minecolonies.api.blocks.types.RackType;
import com.minecolonies.api.inventory.container.ContainerRack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WindowRack
extends AbstractContainerScreen<ContainerRack> {
    private static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("minecolonies", "textures/gui/generic_108.png");
    private static final String LOCATION = "textures/gui/gui%s.png";
    private static final int TEXTURE_SIZE = 350;
    private static final int GOOD_SIZE = 8;
    private static final int Y_OFFSET = 114;
    private static final int TEXTURE_HEIGHT = 96;
    private static final int TEXTURE_OFFSET = 235;
    private final IItemHandler jointChestInventory;
    private final int inventoryRows;

    public WindowRack(ContainerRack container, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)container, playerInventory, iTextComponent);
        this.jointChestInventory = container.neighborRack != null ? (container.rack.getBlockState().getValue(AbstractBlockMinecoloniesRack.VARIANT) != RackType.NO_RENDER ? new CombinedInvWrapper(new IItemHandlerModifiable[]{container.rack.getInventory(), container.neighborRack.getInventory()}) : new CombinedInvWrapper(new IItemHandlerModifiable[]{container.neighborRack.getInventory(), container.rack.getInventory()})) : container.rack.getInventory();
        int size = this.jointChestInventory.getSlots();
        this.inventoryRows = size / 9;
        int rows = Math.min(this.inventoryRows, 8);
        int columns = this.inventoryRows <= 8 ? 9 : size / 8 + 1;
        this.imageHeight = 114 + rows * 18;
        if (columns > 9) {
            this.imageWidth += (columns - 9) * 18;
        }
    }

    protected void renderLabels(@NotNull GuiGraphics stack, int mouseX, int mouseY) {
        stack.drawString(this.font, this.title.getString(), 8, 6, 0x404040, false);
        stack.drawString(this.font, this.playerInventoryTitle.getString(), 8, this.imageHeight - 94, 0x404040, false);
    }

    protected void renderBg(@NotNull GuiGraphics stack, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation loc = WindowRack.getCorrectTextureForSlots(this.inventoryRows);
        if (this.inventoryRows <= 8) {
            int rowsHeight = this.inventoryRows * 18 + 18 - 1;
            stack.blit(loc, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, rowsHeight, 350, 350);
            stack.blit(loc, this.leftPos, this.topPos + rowsHeight, 0.0f, 235.0f, this.imageWidth, 96, 350, 350);
        } else {
            stack.blit(loc, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 350, 350);
        }
    }

    private static ResourceLocation getCorrectTextureForSlots(int inventoryRows) {
        if (inventoryRows <= 8) {
            return CHEST_GUI_TEXTURE;
        }
        return new ResourceLocation("minecolonies", String.format(LOCATION, inventoryRows * 9));
    }

    public void render(@NotNull GuiGraphics stack, int x, int y, float z) {
        super.render(stack, x, y, z);
        this.renderTooltip(stack, x, y);
    }
}

