/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.containers;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.inventory.container.ContainerCraftingBrewingstand;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.core.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class WindowBrewingstandCrafting
extends AbstractContainerScreen<ContainerCraftingBrewingstand> {
    private static final ResourceLocation BREWING_STAND_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/brewing_stand.png");
    private static final int BUTTON_X_OFFSET = 1;
    private static final int BUTTON_Y_POS = 170;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 20;
    private final ContainerCraftingBrewingstand container;
    private final AbstractBuildingView building;
    private final CraftingModuleView module;

    public WindowBrewingstandCrafting(ContainerCraftingBrewingstand container, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)container, playerInventory, iTextComponent);
        this.container = container;
        this.building = (AbstractBuildingView)IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)playerInventory.player.level().dimension(), container.getPos());
        this.module = (CraftingModuleView)this.building.getModuleView(container.getModuleId());
    }

    @NotNull
    public AbstractBuildingView getBuildingView() {
        return this.building;
    }

    protected void init() {
        super.init();
        MutableComponent buttonDisplay = Component.translatableEscape((String)(this.module.canLearn((CraftingType)ModCraftingTypes.BREWING.get()) ? "gui.done" : "com.minecolonies.coremod.gui.recipe.full"), (Object[])new Object[0]);
        Button doneButton = new Button.Builder((Component)buttonDisplay, (Button.OnPress)new OnButtonPress()).pos(this.leftPos + 1, this.topPos + 170).size(150, 20).build();
        this.addRenderableWidget((GuiEventListener)doneButton);
        if (!this.module.canLearn((CraftingType)ModCraftingTypes.BREWING.get())) {
            doneButton.active = false;
        }
    }

    public void render(@NotNull GuiGraphics stack, int x, int y, float z) {
        super.render(stack, x, y, z);
        this.renderTooltip(stack, x, y);
    }

    protected void renderBg(@NotNull GuiGraphics stack, float partialTicks, int mouseX, int mouseY) {
        stack.blit(BREWING_STAND_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int l = Mth.clamp((int)0, (int)0, (int)18);
        if (l > 0) {
            stack.blit(BREWING_STAND_LOCATION, mouseX + 60, mouseY + 44, 176, 29, l, 4);
        }
    }

    public class OnButtonPress
    implements Button.OnPress {
        public void onPress(@NotNull Button button) {
            if (WindowBrewingstandCrafting.this.module.canLearn((CraftingType)ModCraftingTypes.BREWING.get())) {
                ItemStack potion = WindowBrewingstandCrafting.this.container.getSlot(0).getItem();
                ItemStack ingredient = WindowBrewingstandCrafting.this.container.getSlot(3).getItem();
                ArrayList<ItemStorage> input = new ArrayList<ItemStorage>();
                input.add(new ItemStorage(potion, 3, false));
                input.add(new ItemStorage(ingredient));
                ItemStack primaryOutput = Minecraft.getInstance().level.potionBrewing().mix(ingredient, potion);
                if (!ItemStackUtils.isEmpty(primaryOutput) && primaryOutput != potion) {
                    new AddRemoveRecipeMessage((IBuildingView)WindowBrewingstandCrafting.this.building, input, 1, primaryOutput.copyWithCount(3), false, Blocks.BREWING_STAND, WindowBrewingstandCrafting.this.module.getProducer().getRuntimeID()).sendToServer();
                }
            }
        }
    }
}

