/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.controls.Text;
import com.ldtteam.structurize.client.gui.AbstractBlueprintManipulationWindow;
import com.ldtteam.structurize.client.gui.WindowSwitchPack;
import com.ldtteam.structurize.network.messages.BuildToolPlacementMessage;
import com.ldtteam.structurize.placement.handlers.placement.PlacementError;
import com.ldtteam.structurize.storage.ClientFutureProcessor;
import com.ldtteam.structurize.storage.StructurePackMeta;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.client.render.worldevent.HighlightManager;
import com.minecolonies.core.client.render.worldevent.highlightmanager.TimedBoxRenderData;
import com.minecolonies.core.items.ItemSupplyCampDeployer;
import com.minecolonies.core.items.ItemSupplyChestDeployer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.Future;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WindowSupplies
extends AbstractBlueprintManipulationWindow {
    private static final String RENDER_BOX_CATEGORY = "placement";
    private static String type;
    private static StructurePackMeta structurePack;

    public WindowSupplies(@Nullable BlockPos pos, String type) {
        super("minecolonies:gui/windowsupplies.xml", pos, type.equals("supplycamp") ? 2 : 3, "supplies");
        this.registerButton("switch", this::switchPackClicked);
        if (!type.equals(WindowSupplies.type)) {
            HighlightManager.clearHighlightsForKey(RENDER_BOX_CATEGORY);
            RenderingCache.removeBlueprint((String)"supplies");
        }
        WindowSupplies.type = type;
        if (pos != null) {
            RenderingCache.getOrCreateBlueprintPreviewData((String)"supplies").setPos(pos);
        }
        if (RenderingCache.getOrCreateBlueprintPreviewData((String)"supplies").getBlueprint() == null) {
            this.loadBlueprint();
        }
    }

    private void switchPackClicked() {
        new WindowSwitchPack(() -> {
            BlueprintPreviewData previewData = RenderingCache.getOrCreateBlueprintPreviewData((String)"supplies");
            previewData.setBlueprint(null);
            return new WindowSupplies(previewData.getPos(), type);
        }, pack -> Files.exists(pack.getPath().resolve("decorations/supplies/" + type + ".blueprint"), new LinkOption[0])).open();
    }

    private void loadBlueprint() {
        RenderingCache.getOrCreateBlueprintPreviewData((String)"supplies").setBlueprint(null);
        structurePack = StructurePacks.selectedPack;
        ClientFutureProcessor.queueBlueprint((ClientFutureProcessor.BlueprintProcessingData)new ClientFutureProcessor.BlueprintProcessingData((Future)StructurePacks.getBlueprintFuture((String)structurePack.getName(), (String)("decorations/supplies/" + type + ".blueprint"), (HolderLookup.Provider)this.mc.level.registryAccess()), blueprint -> {
            if (blueprint == null) {
                return;
            }
            RenderingCache.getOrCreateBlueprintPreviewData((String)"supplies").setBlueprint(blueprint);
            this.adjustToGroundOffset();
            ((Text)this.findPaneOfTypeByID("tip", Text.class)).setVisible(false);
        }));
    }

    protected void cancelClicked() {
        HighlightManager.clearHighlightsForKey(RENDER_BOX_CATEGORY);
        RenderingCache.removeBlueprint((String)"supplies");
        this.close();
    }

    protected void confirmClicked() {
        this.handlePlacement(BuildToolPlacementMessage.HandlerType.Survival, "minecolonies:supplies");
    }

    protected void handlePlacement(BuildToolPlacementMessage.HandlerType handlerType, String handlerId) {
        BlueprintPreviewData previewData = RenderingCache.getOrCreateBlueprintPreviewData((String)"supplies");
        if (structurePack == null || previewData.getBlueprint() == null) {
            return;
        }
        ArrayList<PlacementError> placementErrorList = new ArrayList<PlacementError>();
        if (type.equals("supplycamp")) {
            if (ItemSupplyCampDeployer.canCampBePlaced((Level)Minecraft.getInstance().level, RenderingCache.getOrCreateBlueprintPreviewData((String)"supplies").getPos(), placementErrorList, (Player)Minecraft.getInstance().player)) {
                new BuildToolPlacementMessage(handlerType, handlerId, structurePack.getName(), structurePack.getSubPath(previewData.getBlueprint().getFilePath().resolve(previewData.getBlueprint().getFileName() + ".blueprint")), previewData.getPos(), previewData.getRotationMirror()).sendToServer();
                this.cancelClicked();
                return;
            }
        } else if (ItemSupplyChestDeployer.canShipBePlaced((Level)Minecraft.getInstance().level, RenderingCache.getOrCreateBlueprintPreviewData((String)"supplies").getPos(), previewData.getBlueprint(), placementErrorList, (Player)Minecraft.getInstance().player)) {
            new BuildToolPlacementMessage(handlerType, handlerId, structurePack.getName(), structurePack.getSubPath(previewData.getBlueprint().getFilePath().resolve(previewData.getBlueprint().getFileName() + ".blueprint")), previewData.getPos(), previewData.getRotationMirror()).sendToServer();
            this.cancelClicked();
            return;
        }
        HighlightManager.clearHighlightsForKey(RENDER_BOX_CATEGORY);
        if (!placementErrorList.isEmpty()) {
            MessageUtils.format("item.supply.badblocks", new Object[0]).sendTo(new Player[]{Minecraft.getInstance().player});
            int i = 0;
            for (PlacementError error : placementErrorList) {
                HighlightManager.addHighlight(RENDER_BOX_CATEGORY, String.valueOf(i++), new TimedBoxRenderData(error.getPos()).addText(Component.translatableEscape((String)("item.supply.error." + error.getType().toString().toLowerCase()), (Object[])new Object[0]).getString()).setColor(-2130771968).setDuration(Duration.ofSeconds(60L)));
            }
        }
    }

    static {
        structurePack = null;
    }
}

