/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Delivery;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.modules.WindowBuilderResModule;
import com.minecolonies.core.colony.buildings.moduleviews.BuildingResourcesModuleView;
import com.minecolonies.core.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.core.network.messages.server.colony.building.MarkBuildingDirtyMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class WindowResourceList
extends AbstractWindowSkeleton {
    @NotNull
    private final BuildingBuilder.View builder;
    @NotNull
    private final List<BuildingBuilderResource> resources = new ArrayList<BuildingBuilderResource>();
    @NotNull
    private final Map<String, Integer> warehouseSnapshot;

    public WindowResourceList(@NotNull BuildingBuilder.View builderView, @NotNull Map<String, Integer> warehouseSnapshot) {
        super("minecolonies:gui/windowresourcescroll.xml");
        this.builder = builderView;
        this.warehouseSnapshot = warehouseSnapshot;
    }

    private void pullResourcesFromHut() {
        BuildingResourcesModuleView moduleView = this.builder.getModuleViewByType(BuildingResourcesModuleView.class);
        Inventory inventory = this.mc.player.getInventory();
        boolean isCreative = this.mc.player.isCreative();
        ArrayList<Delivery> deliveries = new ArrayList<Delivery>();
        for (Map.Entry<Integer, Collection<IToken<?>>> entry : this.builder.getOpenRequestsByCitizen().entrySet()) {
            this.addDeliveryRequestsToList((List<Delivery>)deliveries, (ImmutableCollection<IToken<?>>)ImmutableList.copyOf(entry.getValue()));
        }
        this.resources.clear();
        this.resources.addAll(moduleView.getResources().values());
        double supplied = 0.0;
        double total = 0.0;
        for (BuildingBuilderResource resource : this.resources) {
            int amountToSet = isCreative ? resource.getAmount() : InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((Container)inventory), stack -> !ItemStackUtils.isEmpty(stack) && ItemStackUtils.compareItemStacksIgnoreStackSize(stack, resource.getItemStack()) != false);
            resource.setPlayerAmount(amountToSet);
            resource.setAmountInDelivery(0);
            for (Delivery delivery : deliveries) {
                if (!ItemStackUtils.compareItemStacksIgnoreStackSize(resource.getItemStack(), delivery.getStack(), false, true)) continue;
                resource.setAmountInDelivery(resource.getAmountInDelivery() + delivery.getStack().getCount());
            }
            supplied += (double)Math.min(resource.getAvailable(), resource.getAmount());
            total += (double)resource.getAmount();
        }
        if (total > 0.0) {
            ((Text)this.findPaneOfTypeByID("progress", Text.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.progress.res", (Object[])new Object[]{(int)(supplied / total * 100.0) + "%", moduleView.getProgress() + "%"}));
        }
        this.resources.sort(new BuildingBuilderResource.ResourceComparator(BuildingBuilderResource.RessourceAvailability.NOT_NEEDED, BuildingBuilderResource.RessourceAvailability.HAVE_ENOUGH, BuildingBuilderResource.RessourceAvailability.IN_DELIVERY, BuildingBuilderResource.RessourceAvailability.NEED_MORE, BuildingBuilderResource.RessourceAvailability.DONT_HAVE));
    }

    private void addDeliveryRequestsToList(List<Delivery> requestList, ImmutableCollection<IToken<?>> tokensToCheck) {
        for (IToken token : tokensToCheck) {
            IRequest<?> request = this.builder.getColony().getRequestManager().getRequestForToken(token);
            if (request == null) continue;
            if (request.getRequest() instanceof Delivery && ((Delivery)request.getRequest()).getTarget().getInDimensionLocation().equals((Object)this.builder.getID())) {
                requestList.add((Delivery)request.getRequest());
            }
            if (!request.hasChildren()) continue;
            this.addDeliveryRequestsToList(requestList, request.getChildren());
        }
    }

    public void onOpened() {
        IWorkOrderView workOrderView;
        super.onOpened();
        this.pullResourcesFromHut();
        ScrollingList resourceList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowResourceList.this.resources.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                WindowResourceList.this.updateResourcePane(index, rowPane);
            }
        });
        BuildingResourcesModuleView moduleView = this.builder.getModuleViewByType(BuildingResourcesModuleView.class);
        new MarkBuildingDirtyMessage(this.builder).sendToServer();
        ((Text)this.findPaneOfTypeByID("workerName", Text.class)).setText(Component.literal((String)this.builder.getWorkerName()));
        if (moduleView.getWorkOrderId() > -1 && (workOrderView = moduleView.getBuildingView().getColony().getWorkOrder(moduleView.getWorkOrderId())) != null) {
            Text pane = (Text)this.findPaneOfTypeByID("constructionName", Text.class);
            MutableComponent text = Component.literal((String)workOrderView.getDisplayName().getString().replace("\n", " "));
            pane.setText((Component)text);
            PaneBuilders.tooltipBuilder().hoverPane((Pane)pane).build().setText((Component)text);
        }
    }

    private void updateResourcePane(int index, @NotNull Pane rowPane) {
        BuildingBuilderResource resource = this.resources.get(index);
        Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
        Text resourceMissingLabel = (Text)rowPane.findPaneOfTypeByID("resourceMissing", Text.class);
        Text neededLabel = (Text)rowPane.findPaneOfTypeByID("resourceAvailableNeeded", Text.class);
        ((Image)rowPane.findPaneOfTypeByID("indeliveryicon", Image.class)).setVisible(false);
        ((Text)rowPane.findPaneOfTypeByID("indeliveryamount", Text.class)).clearText();
        ((Image)rowPane.findPaneOfTypeByID("inWarehouseIcon", Image.class)).setVisible(false);
        ((Text)rowPane.findPaneOfTypeByID("inWarehouseAmount", Text.class)).clearText();
        int resourceHashcode = resource.getItemStack().getComponentsPatch().hashCode();
        int warehouseAmount = this.warehouseSnapshot.getOrDefault(resource.getItem().getDescriptionId() + "-" + resourceHashcode, 0);
        if (resource.getAmountInDelivery() > 0) {
            ((Image)rowPane.findPaneOfTypeByID("indeliveryicon", Image.class)).setVisible(true);
            ((Text)rowPane.findPaneOfTypeByID("indeliveryamount", Text.class)).setText(Component.literal((String)String.valueOf(resource.getAmountInDelivery())));
        } else if (warehouseAmount > 0) {
            ((Image)rowPane.findPaneOfTypeByID("inWarehouseIcon", Image.class)).setVisible(true);
            ((Text)rowPane.findPaneOfTypeByID("indeliveryamount", Text.class)).setText(Component.literal((String)String.valueOf(warehouseAmount)));
        }
        switch (resource.getAvailabilityStatus()) {
            case DONT_HAVE: {
                resourceLabel.setColors(WindowBuilderResModule.RED);
                resourceMissingLabel.setColors(WindowBuilderResModule.RED);
                neededLabel.setColors(WindowBuilderResModule.RED);
                break;
            }
            case NEED_MORE: {
                resourceLabel.setColors(WindowBuilderResModule.ORANGE);
                resourceMissingLabel.setColors(WindowBuilderResModule.ORANGE);
                neededLabel.setColors(WindowBuilderResModule.ORANGE);
                break;
            }
            case HAVE_ENOUGH: {
                resourceLabel.setColors(WindowBuilderResModule.DARKGREEN);
                resourceMissingLabel.setColors(WindowBuilderResModule.DARKGREEN);
                neededLabel.setColors(WindowBuilderResModule.DARKGREEN);
                break;
            }
            default: {
                resourceLabel.setColors(WindowBuilderResModule.BLACK);
                resourceMissingLabel.setColors(WindowBuilderResModule.BLACK);
                neededLabel.setColors(WindowBuilderResModule.BLACK);
            }
        }
        resourceLabel.setText(Component.literal((String)resource.getName()));
        int missing = resource.getMissingFromPlayer();
        if (missing < 0) {
            resourceMissingLabel.setText(Component.literal((String)Integer.toString(missing)));
        } else {
            resourceMissingLabel.clearText();
        }
        neededLabel.setText(Component.literal((String)(resource.getAvailable() + " / " + resource.getAmount())));
        ((Text)rowPane.findPaneOfTypeByID("resourceId", Text.class)).setText(Component.literal((String)Integer.toString(index)));
        ((Text)rowPane.findPaneOfTypeByID("resourceQuantity", Text.class)).setText(Component.literal((String)Integer.toString(resource.getAmount() - resource.getAvailable())));
        ItemStack stack = resource.getItemStack().copy();
        stack.setCount(1);
        ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(stack);
    }

    public void onUpdate() {
        super.onUpdate();
        this.pullResourcesFromHut();
        ((ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class)).refreshElementPanes();
    }
}

