/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonHandler;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.MessageUtils;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class WindowHutNameEntry
extends BOWindow
implements ButtonHandler {
    private static final int MAX_NAME_LENGTH = 15;
    private static final String HUT_NAME_RESOURCE_SUFFIX = ":gui/windowhutnameentry.xml";
    private final IBuildingView building;

    public WindowHutNameEntry(IBuildingView b) {
        super(ResourceLocation.parse((String)"minecolonies:gui/windowhutnameentry.xml"));
        this.building = b;
    }

    public void onOpened() {
        ((TextField)this.findPaneOfTypeByID("name", TextField.class)).setText(Component.translatable((String)this.building.getCustomName().toLowerCase(Locale.US)).getString());
    }

    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals("done")) {
            String name = ((TextField)this.findPaneOfTypeByID("name", TextField.class)).getText();
            if (name.length() > 15) {
                name = name.substring(0, 15);
                MessageUtils.format("com.minecolonies.coremod.gui.name.toolong", name).sendTo(new Player[]{Minecraft.getInstance().player});
            }
            this.building.setCustomName(name);
        } else if (!button.getID().equals("cancel")) {
            return;
        }
        if (this.building != null) {
            this.building.openGui(false);
        }
    }
}

