/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.ClientFutureProcessor;
import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.IOPool;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.claim.IChunkClaimData;
import com.minecolonies.api.util.ChunkCapData;
import com.minecolonies.api.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColonyUtils {
    private ColonyUtils() {
    }

    public static CompletableFuture<Blueprint> queueBlueprintLoad(Level world, String structurePack, String structurePath, Consumer<Blueprint> afterLoad) {
        return ColonyUtils.queueBlueprintLoad(world, structurePack, structurePath, afterLoad, e -> Log.getLogger().warn(e));
    }

    public static CompletableFuture<Blueprint> queueBlueprintLoad(Level world, String structurePack, String structurePath, Consumer<Blueprint> afterLoad, Consumer<String> errorHandler) {
        CompletableFuture<Blueprint> future = CompletableFuture.supplyAsync(() -> StructurePacks.getBlueprint((String)structurePack, (String)structurePath, (boolean)FMLEnvironment.production, (HolderLookup.Provider)world.registryAccess()), IOPool.getExecutor());
        if (world.isClientSide) {
            ClientFutureProcessor.queueBlueprint((ClientFutureProcessor.BlueprintProcessingData)new ClientFutureProcessor.BlueprintProcessingData(future, blueprint -> {
                if (blueprint == null) {
                    errorHandler.accept("Couldn't find structure with name: " + structurePack + " in: " + structurePath + ". Aborting loading procedure");
                } else {
                    afterLoad.accept((Blueprint)blueprint);
                }
            }));
            return future;
        }
        ServerFutureProcessor.queueBlueprint((ServerFutureProcessor.BlueprintProcessingData)new ServerFutureProcessor.BlueprintProcessingData(future, world, blueprint -> {
            if (blueprint == null) {
                errorHandler.accept("Couldn't find structure with name: " + structurePack + " in: " + structurePath + ". Aborting loading procedure");
            } else {
                afterLoad.accept((Blueprint)blueprint);
            }
        }));
        return future;
    }

    public static Tuple<BlockPos, BlockPos> calculateCorners(BlockPos pos, Level world, Blueprint blueprint, RotationMirror rotMir) {
        if (blueprint == null) {
            return new Tuple((Object)pos, (Object)pos);
        }
        blueprint.setRotationMirror(rotMir, world);
        BlockPos zeroPos = pos.subtract((Vec3i)blueprint.getPrimaryBlockOffset());
        BlockPos pos1 = new BlockPos(zeroPos.getX(), zeroPos.getY(), zeroPos.getZ());
        BlockPos pos2 = new BlockPos(zeroPos.getX() + blueprint.getSizeX() - 1, zeroPos.getY() + blueprint.getSizeY() - 1, zeroPos.getZ() + blueprint.getSizeZ() - 1);
        return new Tuple((Object)pos1, (Object)pos2);
    }

    public static Tuple<BlockPos, BlockPos> calculateCorners(@NotNull AABB box) {
        BlockPos min = BlockPos.containing((double)box.minX, (double)box.minY, (double)box.minZ);
        BlockPos max = BlockPos.containing((double)box.maxX, (double)box.maxY, (double)box.maxZ);
        return new Tuple((Object)min, (Object)max);
    }

    public static int getOwningColony(ChunkAccess chunk) {
        IChunkClaimData cap = IColonyManager.getInstance().getClaimData((ResourceKey<Level>)chunk.getLevel().dimension(), chunk.getPos());
        return cap == null ? 0 : cap.getOwningColony();
    }

    public static Map<Integer, Set<BlockPos>> getAllClaimingBuildings(ChunkAccess chunk) {
        IChunkClaimData cap = IColonyManager.getInstance().getClaimData((ResourceKey<Level>)chunk.getLevel().dimension(), chunk.getPos());
        return cap == null ? new HashMap() : cap.getAllClaimingBuildings();
    }

    public static List<Integer> getStaticClaims(ChunkAccess chunk) {
        IChunkClaimData cap = IColonyManager.getInstance().getClaimData((ResourceKey<Level>)chunk.getLevel().dimension(), chunk.getPos());
        return cap == null ? new ArrayList() : cap.getStaticClaimColonies();
    }

    @Nullable
    public static ChunkCapData getChunkCapData(ChunkAccess chunk) {
        IChunkClaimData cap = IColonyManager.getInstance().getClaimData((ResourceKey<Level>)chunk.getLevel().dimension(), chunk.getPos());
        return cap == null ? new ChunkCapData(chunk.getPos().x, chunk.getPos().z) : new ChunkCapData(chunk.getPos().x, chunk.getPos().z, cap.getOwningColony(), cap.getStaticClaimColonies(), cap.getAllClaimingBuildings());
    }
}

