/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.level.ChunkPos;
import org.slf4j.Logger;

public class CodecUtil {
    public static final Codec<ChunkPos> CHUNK_POS = Codec.INT_STREAM.comapFlatMap(stream -> Util.fixedSize((IntStream)stream, (int)2).map(arr -> new ChunkPos(arr[0], arr[1])), pos -> IntStream.of(pos.x, pos.z)).stable();

    private CodecUtil() {
        throw new UnsupportedOperationException("utility class");
    }

    public static <T> Function<CompoundTag, T> nbtDecoder(Codec<T> codec, Logger logger, Supplier<T> instanceIfErrored) {
        return nbt -> codec.decode((DynamicOps)NbtOps.INSTANCE, nbt).resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).map(Pair::getFirst).orElseGet(instanceIfErrored);
    }

    public static <T> Function<T, CompoundTag> nbtEncoder(Codec<T> codec, Logger logger, Supplier<CompoundTag> instanceIfErrored) {
        return data -> codec.encodeStart((DynamicOps)NbtOps.INSTANCE, data).resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).map(t -> {
            CompoundTag c;
            return t instanceof CompoundTag ? (c = (CompoundTag)t) : null;
        }).orElseGet(instanceIfErrored);
    }

    public static <T> Codec<Set<T>> set(Codec<T> codec, Function<Collection<T>, Set<T>> setFactory) {
        return codec.listOf().xmap(setFactory, List::copyOf);
    }
}

