/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.mobs;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.ai.combat.CombatAIStates;
import com.minecolonies.api.entity.ai.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.ai.combat.threat.ThreatTable;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.entity.mobs.RaiderType;
import com.minecolonies.api.entity.other.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.entity.pathfinding.registry.IPathNavigateRegistry;
import com.minecolonies.api.sounds.RaiderSounds;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.core.entity.pathfinding.navigation.AbstractAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.navigation.PathingStuckHandler;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityMinecoloniesMonster
extends AbstractFastMinecoloniesEntity
implements IThreatTableEntity,
Enemy {
    protected AbstractAdvancedPathNavigate newNavigator;
    private int invulTime = 40;
    private int textureId;
    private int collisionCounter = 0;
    private static final int COLL_THRESHOLD = 50;
    private ThreatTable threatTable = new ThreatTable<AbstractEntityMinecoloniesMonster>(this);
    private ITickRateStateMachine<IState> ai = new TickRateStateMachine<CombatAIStates>(CombatAIStates.NO_TARGET, e -> Log.getLogger().warn(e), 5);
    private BlockPos spawnPos = null;

    public AbstractEntityMinecoloniesMonster(EntityType<? extends AbstractEntityMinecoloniesMonster> type, Level world) {
        super(type, world);
        this.setPersistenceRequired();
        this.xpReward = 5;
        IMinecoloniesAPI.getInstance().getMobAIRegistry().applyToMob(this);
        RaiderMobUtils.setEquipment(this);
    }

    public AbstractEntityMinecoloniesMonster(EntityType<? extends AbstractEntityMinecoloniesMonster> type, Level world, int textureCount) {
        this(type, world);
        this.textureId = MathUtils.RANDOM.nextInt(textureCount);
    }

    @Override
    public void pushEntities() {
        if (this.collisionCounter > 50) {
            return;
        }
        super.pushEntities();
    }

    public void push(@NotNull Entity entityIn) {
        if (this.invulTime > 0) {
            return;
        }
        if ((this.collisionCounter += 3) > 50) {
            if (this.collisionCounter > 150) {
                this.collisionCounter = 0;
            }
            return;
        }
        super.push(entityIn);
    }

    public void playAmbientSound() {
        super.playAmbientSound();
        SoundEvent soundevent = this.getAmbientSound();
        if (soundevent != null && this.level().random.nextInt(100) <= 1) {
            this.playSound(soundevent, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    public abstract RaiderType getRaiderType();

    @NotNull
    public AbstractAdvancedPathNavigate getNavigation() {
        if (this.newNavigator == null) {
            this.newNavigator = IPathNavigateRegistry.getInstance().getNavigateFor((Mob)this);
            this.navigation = this.newNavigator;
            this.newNavigator.setCanFloat(true);
            this.newNavigator.setSwimSpeedFactor(this.getSwimSpeedFactor());
            this.newNavigator.getPathingOptions().setEnterDoors(true);
            this.newNavigator.getPathingOptions().setCanOpenDoors(true);
            this.newNavigator.getPathingOptions().withDropCost(1.0);
            this.newNavigator.getPathingOptions().withJumpCost(1.0);
            this.newNavigator.getPathingOptions().setPassDanger(true);
            PathingStuckHandler stuckHandler = PathingStuckHandler.createStuckHandler();
            if (((Boolean)((ServerConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getServer()).raidersbreakblocks.get()).booleanValue()) {
                stuckHandler.withBlockBreaks();
                stuckHandler.withCompleteStuckBlockBreak(6);
            }
            this.newNavigator.setStuckHandler(stuckHandler);
        }
        return this.newNavigator;
    }

    public abstract double getSwimSpeedFactor();

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return RaiderSounds.raiderSounds.get((Object)this.getRaiderType()).get((Object)RaiderSounds.RaiderSoundTypes.HURT);
    }

    protected SoundEvent getDeathSound() {
        return RaiderSounds.raiderSounds.get((Object)this.getRaiderType()).get((Object)RaiderSounds.RaiderSoundTypes.DEATH);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return RaiderSounds.raiderSounds.get((Object)this.getRaiderType()).get((Object)RaiderSounds.RaiderSoundTypes.SAY);
    }

    public void initStatsFor(double baseHealth, double difficulty, double baseDamage) {
        this.getAttribute((Holder)RaiderMobUtils.MOB_ATTACK_DAMAGE).setBaseValue(baseDamage);
        double armor = difficulty * 1.0;
        this.getAttribute(Attributes.ARMOR).setBaseValue(armor);
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(baseHealth);
        this.setHealth(this.getMaxHealth());
    }

    public void aiStep() {
        if (!this.isAlive()) {
            return;
        }
        if (this.spawnPos == null && this.blockPosition() != BlockPos.ZERO) {
            this.spawnPos = this.blockPosition();
        }
        this.updateSwingTime();
        if (this.collisionCounter > 0) {
            --this.collisionCounter;
        }
        if (this.level().isClientSide) {
            super.aiStep();
            return;
        }
        if (this.tickCount % 5 == 0) {
            this.ai.tick();
        }
        super.aiStep();
    }

    @Override
    public boolean hurt(@NotNull DamageSource damageSource, float damage) {
        if (damageSource.getEntity() instanceof AbstractEntityMinecoloniesMonster) {
            return false;
        }
        Entity entity = damageSource.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (this.threatTable.getThreatFor(attacker) == -1) {
                for (AbstractEntityMinecoloniesMonster monster : this.level().getEntitiesOfClass(AbstractEntityMinecoloniesMonster.class, AABB.ofSize((Vec3)this.position(), (double)20.0, (double)5.0, (double)20.0))) {
                    monster.threatTable.addThreat(attacker, 0);
                }
            }
            this.threatTable.addThreat(attacker, (int)damage);
        }
        return super.hurt(damageSource, damage);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return LivingEntity.createLivingAttributes().add(RaiderMobUtils.MOB_ATTACK_DAMAGE).add(Attributes.MAX_HEALTH).add(Attributes.ARMOR).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 70.0).add(Attributes.ATTACK_DAMAGE, ((Attribute)Attributes.ATTACK_DAMAGE.value()).getDefaultValue());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        if (this.spawnPos != null) {
            compound.putLong("spawnPos", this.spawnPos.asLong());
        }
        super.addAdditionalSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("spawnPos")) {
            this.spawnPos = BlockPos.of((long)compound.getLong("spawnPos"));
        }
        super.readAdditionalSaveData(compound);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    @Override
    public ThreatTable getThreatTable() {
        return this.threatTable;
    }

    public ITickRateStateMachine<IState> getAI() {
        return this.ai;
    }

    @Override
    public int getTeamId() {
        return -1;
    }

    public int getTextureId() {
        return this.textureId;
    }

    public BlockPos getSpawnPos() {
        return this.spawnPos;
    }

    public double getDifficulty() {
        return 1.0;
    }
}

