/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen.happiness;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.happiness.IHappinessModifier;
import com.minecolonies.api.util.Log;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class HappinessRegistry {
    public static ResourceLocation STATIC_MODIFIER = new ResourceLocation("minecolonies", "static");
    public static ResourceLocation EXPIRATION_MODIFIER = new ResourceLocation("minecolonies", "expiration");
    public static ResourceLocation TIME_PERIOD_MODIFIER = new ResourceLocation("minecolonies", "time");
    public static ResourceLocation SCHOOL_FUNCTION = new ResourceLocation("minecolonies", "school");
    public static ResourceLocation SECURITY_FUNCTION = new ResourceLocation("minecolonies", "security");
    public static ResourceLocation SOCIAL_FUNCTION = new ResourceLocation("minecolonies", "social");
    public static ResourceLocation MYSTICAL_SITE_FUNCTION = new ResourceLocation("minecolonies", "mystical");
    public static ResourceLocation HOUSING_FUNCTION = new ResourceLocation("minecolonies", "housing");
    public static ResourceLocation UNEMPLOYMENT_FUNCTION = new ResourceLocation("minecolonies", "unemployment");
    public static ResourceLocation HEALTH_FUNCTION = new ResourceLocation("minecolonies", "health");
    public static ResourceLocation IDLEATJOB_FUNCTION = new ResourceLocation("minecolonies", "idleatjob");
    public static ResourceLocation SLEPTTONIGHT_FUNCTION = new ResourceLocation("minecolonies", "slepttonight");
    public static ResourceLocation FOOD_FUNCTION = new ResourceLocation("minecolonies", "food");
    public static DeferredHolder<HappinessFactorTypeEntry, HappinessFactorTypeEntry> staticHappinessModifier;
    public static DeferredHolder<HappinessFactorTypeEntry, HappinessFactorTypeEntry> expirationBasedHappinessModifier;
    public static DeferredHolder<HappinessFactorTypeEntry, HappinessFactorTypeEntry> timeBasedHappinessModifier;
    public static DeferredHolder<HappinessFunctionEntry, HappinessFunctionEntry> schoolFunction;
    public static DeferredHolder<HappinessFunctionEntry, HappinessFunctionEntry> securityFunction;
    public static DeferredHolder<HappinessFunctionEntry, HappinessFunctionEntry> socialFunction;
    public static DeferredHolder<HappinessFunctionEntry, HappinessFunctionEntry> mysticalSiteFunction;
    public static DeferredHolder<HappinessFunctionEntry, HappinessFunctionEntry> housingFunction;
    public static DeferredHolder<HappinessFunctionEntry, HappinessFunctionEntry> unemploymentFunction;
    public static DeferredHolder<HappinessFunctionEntry, HappinessFunctionEntry> healthFunction;
    public static DeferredHolder<HappinessFunctionEntry, HappinessFunctionEntry> idleatjobFunction;
    public static DeferredHolder<HappinessFunctionEntry, HappinessFunctionEntry> sleptTonightFunction;
    public static DeferredHolder<HappinessFunctionEntry, HappinessFunctionEntry> foodFunction;
    public static DeferredHolder<HappinessFunctionEntry, HappinessFunctionEntry> greatFoodFunction;

    static Registry<HappinessFactorTypeEntry> getHappinessTypeRegistry() {
        return IMinecoloniesAPI.getInstance().getHappinessTypeRegistry();
    }

    static Registry<HappinessFunctionEntry> getHappinessFunctionRegistry() {
        return IMinecoloniesAPI.getInstance().getHappinessFunctionRegistry();
    }

    public static IHappinessModifier loadFrom(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound, boolean persist) {
        ResourceLocation modifierType = compound.contains("modifier") ? ResourceLocation.parse((String)compound.getString("modifier")) : new ResourceLocation("minecolonies", "null");
        IHappinessModifier modifier = ((HappinessFactorTypeEntry)HappinessRegistry.getHappinessTypeRegistry().get(modifierType)).create();
        if (modifier != null) {
            try {
                modifier.read(provider, compound, persist);
            }
            catch (RuntimeException ex) {
                Log.getLogger().error(String.format("A Happiness Modifier %s has thrown an exception during loading, its state cannot be restored. Report this to the mod author", modifierType), (Throwable)ex);
                return null;
            }
        } else {
            Log.getLogger().warn(String.format("Unknown Happiness Modifier type '%s' or missing constructor of proper format.", modifierType));
        }
        return modifier;
    }

    public static class HappinessFactorTypeEntry {
        private final Supplier<IHappinessModifier> supplier;

        public HappinessFactorTypeEntry(Supplier<IHappinessModifier> productionFunction) {
            this.supplier = productionFunction;
        }

        public IHappinessModifier create() {
            return this.supplier.get();
        }
    }

    public static class HappinessFunctionEntry {
        private final Function<ICitizenData, Double> doubleSupplier;

        public HappinessFunctionEntry(Function<ICitizenData, Double> doubleSupplier) {
            this.doubleSupplier = doubleSupplier;
        }

        public Function<ICitizenData, Double> getDoubleSupplier() {
            return this.doubleSupplier;
        }
    }
}

