/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.savedata;

import com.google.common.collect.ArrayListMultimap;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.savedata.IServerColonySaveData;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.ColonyList;
import com.minecolonies.core.util.BackUpHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class ServerColonySaveData
extends SavedData
implements IServerColonySaveData {
    public static final String NAME = new ResourceLocation("minecolonies", "colony_manager").toDebugFileName();
    public static final SavedData.Factory<ServerColonySaveData> FACTORY = new SavedData.Factory(ServerColonySaveData::new, (d, a) -> {
        ServerColonySaveData colonyManagerData = new ServerColonySaveData();
        colonyManagerData.readNBT((HolderLookup.Provider)a, (CompoundTag)d);
        return colonyManagerData;
    });
    @NotNull
    private final ColonyList<IColony> colonies = new ColonyList();
    private boolean overworld;

    private ServerColonySaveData() {
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        return this.writeNBT(provider, tag);
    }

    @Override
    public IColony createColony(@NotNull ServerLevel w, @NotNull String name, @NotNull BlockPos pos) {
        return this.colonies.create(w, name, pos);
    }

    @Override
    public void deleteColony(int id) {
        this.colonies.remove(id);
    }

    @Override
    public IColony getColony(int id) {
        return this.colonies.get(id);
    }

    @Override
    public List<IColony> getColonies() {
        return this.colonies.getCopyAsList();
    }

    @Override
    public void addColony(IColony colony) {
        this.colonies.add(colony);
    }

    @Override
    public int getTopID() {
        return this.colonies.getTopID();
    }

    public boolean isDirty() {
        return true;
    }

    private CompoundTag writeNBT(@NotNull HolderLookup.Provider provider, CompoundTag inputTag) {
        CompoundTag compound = new CompoundTag();
        ListTag colonyTag = new ListTag();
        for (IColony colony : this.colonies) {
            try {
                colonyTag.add((Object)colony.getColonyTag());
            }
            catch (Exception e) {
                Log.getLogger().error("Colony: " + colony.getName() + " id:" + colony.getID() + " owner:" + colony.getPermissions().getOwnerName() + " could not be saved! Error:", (Throwable)e);
            }
        }
        compound.put("colonies", (Tag)colonyTag);
        if (this.overworld) {
            CompoundTag managerCompound = new CompoundTag();
            IColonyManager.getInstance().write(provider, managerCompound);
            compound.put("colonymanager", (Tag)managerCompound);
        }
        inputTag.put("minecolonies", (Tag)compound);
        return inputTag;
    }

    @Override
    public IServerColonySaveData setOverworld(boolean overworld) {
        this.overworld = overworld;
        return this;
    }

    private void readNBT(@NotNull HolderLookup.Provider provider, CompoundTag inputTag) {
        CompoundTag compound = inputTag.getCompound("minecolonies");
        if (!compound.contains("colonies")) {
            BackUpHelper.loadManagerBackup(provider);
            return;
        }
        ArrayListMultimap tempColonies = ArrayListMultimap.create();
        for (Tag tag : compound.getList("colonies", 10)) {
            Colony colony = Colony.loadColony((CompoundTag)tag, null, provider);
            if (colony == null) continue;
            tempColonies.put((Object)colony.getCenter(), (Object)colony);
            this.colonies.add(colony);
        }
        if (compound.contains("colonymanager")) {
            IColonyManager.getInstance().read(provider, compound.getCompound("colonymanager"));
            this.overworld = true;
        }
        for (BlockPos pos : tempColonies.keySet()) {
            if (tempColonies.get((Object)pos).size() <= 1) continue;
            Log.getLogger().warn("Detected duplicate colonies which are at the same position:");
            for (IColony colony : tempColonies.get((Object)pos)) {
                Log.getLogger().warn("ID: " + colony.getID() + " name:" + colony.getName() + " citizens:" + colony.getCitizenManager().getCitizens().size() + " building count:" + colony.getBuildingManager().getBuildings().size());
            }
            Log.getLogger().warn("Check and remove all except one of the duplicated colonies above!");
        }
    }
}

