/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable.deliveryman;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.AbstractDeliverymanRequestable;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class Pickup
extends AbstractDeliverymanRequestable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(Pickup.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());

    public Pickup(int priority) {
        super(priority);
    }

    @NotNull
    public static CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, Pickup pickup) {
        CompoundTag compound = new CompoundTag();
        compound.put("Priority", (Tag)controller.serializeTag(provider, pickup.getPriority()));
        return compound;
    }

    @NotNull
    public static Pickup deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag compound) {
        int priority = (Integer)controller.deserializeTag(provider, compound.getCompound("Priority"));
        return new Pickup(priority);
    }

    public static void serialize(IFactoryController controller, RegistryFriendlyByteBuf buffer, Pickup input) {
        buffer.writeInt(input.getPriority());
    }

    public static Pickup deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) {
        int priority = buffer.readInt();
        return new Pickup(priority);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        return o instanceof Pickup;
    }

    public String toString() {
        return "Pickup{priority=" + this.priority + "}";
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

