/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.interactionhandling.registry;

import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;

public final class InteractionResponseHandlerEntry {
    private final Function<ICitizen, IInteractionResponseHandler> responseHandlerProducer;
    private ResourceLocation registryName;

    public Function<ICitizen, IInteractionResponseHandler> getProducer() {
        return this.responseHandlerProducer;
    }

    private InteractionResponseHandlerEntry(Function<ICitizen, IInteractionResponseHandler> producer, ResourceLocation registryName) {
        this.responseHandlerProducer = producer;
        this.registryName = registryName;
    }

    public static final class Builder {
        private Function<ICitizen, IInteractionResponseHandler> responseHandlerProducer;
        private ResourceLocation registryName;

        public Builder setResponseHandlerProducer(Function<ICitizen, IInteractionResponseHandler> responseHandlerProducer) {
            this.responseHandlerProducer = responseHandlerProducer;
            return this;
        }

        public Builder setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public InteractionResponseHandlerEntry createEntry() {
            Objects.requireNonNull(this.responseHandlerProducer);
            Objects.requireNonNull(this.registryName);
            return new InteractionResponseHandlerEntry(this.responseHandlerProducer, this.registryName);
        }
    }
}

