/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.connections;

import com.minecolonies.api.colony.connections.DiplomacyStatus;
import com.minecolonies.api.util.BlockPosUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class ColonyConnection {
    public DiplomacyStatus diplomacyStatus;
    public int id;
    public String name;
    public BlockPos pos;

    public ColonyConnection(int id, String name, BlockPos pos, DiplomacyStatus diplomacyStatus) {
        this.id = id;
        this.name = name;
        this.pos = pos;
        this.diplomacyStatus = diplomacyStatus;
    }

    public ColonyConnection() {
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putInt("id", this.id);
        compoundTag.putString("name", this.name);
        BlockPosUtil.write(compoundTag, "pos", this.pos);
        compoundTag.putInt("status", this.diplomacyStatus.ordinal());
        return compoundTag;
    }

    public ColonyConnection deserializeNBT(CompoundTag compoundTag) {
        this.id = compoundTag.getInt("id");
        this.name = compoundTag.getString("name");
        this.pos = BlockPosUtil.read(compoundTag, "pos");
        this.diplomacyStatus = DiplomacyStatus.values()[compoundTag.getInt("status")];
        return this;
    }

    public void serializeByteBuf(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeUtf(this.name);
        buf.writeBlockPos(this.pos);
        buf.writeInt(this.diplomacyStatus.ordinal());
    }

    public ColonyConnection deserializeByteBuf(FriendlyByteBuf buf) {
        this.id = buf.readInt();
        this.name = buf.readUtf();
        this.pos = buf.readBlockPos();
        this.diplomacyStatus = DiplomacyStatus.values()[buf.readInt()];
        return this;
    }
}

