/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.claim.ChunkClaimData;
import com.minecolonies.api.colony.claim.IChunkClaimData;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.crafting.IRecipeManager;
import com.minecolonies.core.colony.Colony;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IColonyManager {
    public static IColonyManager getInstance() {
        return IMinecoloniesAPI.getInstance().getColonyManager();
    }

    @Nullable
    public IColony createColony(@NotNull ServerLevel var1, BlockPos var2, @NotNull Player var3, @NotNull String var4, @NotNull String var5);

    public void deleteColonyByWorld(int var1, boolean var2, ServerLevel var3);

    public void deleteColonyByDimension(int var1, boolean var2, ResourceKey<Level> var3);

    public void removeColonyView(int var1, ResourceKey<Level> var2);

    @Nullable
    public IColony getColonyByWorld(int var1, Level var2);

    @Nullable
    public IColony getColonyByDimension(int var1, ResourceKey<Level> var2);

    public IBuilding getBuilding(@NotNull Level var1, @NotNull BlockPos var2);

    @Nullable
    public IColony getColonyByPosFromWorld(@NotNull Level var1, @NotNull BlockPos var2);

    public IColony getColonyByPosFromDim(ResourceKey<Level> var1, @NotNull BlockPos var2);

    public boolean isFarEnoughFromColonies(@NotNull Level var1, @NotNull BlockPos var2);

    @NotNull
    public List<IColony> getColonies(@NotNull Level var1);

    @NotNull
    public List<IColony> getAllColonies();

    @NotNull
    public List<IColony> getColoniesAbandonedSince(int var1);

    public IBuildingView getBuildingView(ResourceKey<Level> var1, BlockPos var2);

    @Nullable
    public IColony getIColony(@NotNull Level var1, @NotNull BlockPos var2);

    public IColonyView getColonyView(@NotNull Level var1, @NotNull BlockPos var2);

    @Nullable
    public IColony getClosestIColony(@NotNull Level var1, @NotNull BlockPos var2);

    @Nullable
    public IColonyView getClosestColonyView(@Nullable Level var1, @Nullable BlockPos var2);

    public IColony getClosestColony(@NotNull Level var1, @NotNull BlockPos var2);

    @Nullable
    public IColony getIColonyByOwner(@NotNull Level var1, @NotNull Player var2);

    @Nullable
    public IColony getIColonyByOwner(@NotNull Level var1, UUID var2);

    public int getMinimumDistanceBetweenTownHalls();

    public void onServerTick(@NotNull ServerTickEvent.Pre var1);

    public void write(HolderLookup.Provider var1, @NotNull CompoundTag var2);

    public void read(HolderLookup.Provider var1, @NotNull CompoundTag var2);

    public void onClientTick(@NotNull ClientTickEvent.Pre var1);

    public void onWorldTick(@NotNull LevelTickEvent.Pre var1);

    public void onWorldLoad(@NotNull Level var1);

    public void onWorldUnload(@NotNull Level var1);

    public void handleColonyViewMessage(int var1, @NotNull RegistryFriendlyByteBuf var2, boolean var3, ResourceKey<Level> var4);

    public IColonyView getColonyView(int var1, ResourceKey<Level> var2);

    public void handlePermissionsViewMessage(int var1, @NotNull RegistryFriendlyByteBuf var2, ResourceKey<Level> var3);

    public void handleColonyViewCitizensMessage(int var1, int var2, RegistryFriendlyByteBuf var3, ResourceKey<Level> var4);

    public void handleColonyViewWorkOrderMessage(int var1, RegistryFriendlyByteBuf var2, ResourceKey<Level> var3);

    public void handleColonyViewRemoveCitizenMessage(int var1, int var2, ResourceKey<Level> var3);

    public void handleColonyBuildingViewMessage(int var1, BlockPos var2, @NotNull RegistryFriendlyByteBuf var3, ResourceKey<Level> var4);

    public void handleColonyViewRemoveBuildingMessage(int var1, BlockPos var2, ResourceKey<Level> var3);

    public void handleColonyViewRemoveWorkOrderMessage(int var1, int var2, ResourceKey<Level> var3);

    public boolean isSchematicDownloaded();

    public void setSchematicDownloaded(boolean var1);

    public boolean isCoordinateInAnyColony(@NotNull Level var1, BlockPos var2);

    public ICompatibilityManager getCompatibilityManager();

    public IRecipeManager getRecipeManager();

    public int getTopColonyId();

    public void resetColonyViews();

    public void openReactivationWindow(BlockPos var1);

    public void addColonyDirect(IColony var1, ServerLevel var2);

    public void addClaimData(IColony var1, Long2ObjectMap<ChunkClaimData> var2);

    public Map<ChunkPos, IChunkClaimData> getClaimData(ResourceKey<Level> var1);

    public IChunkClaimData getClaimData(ResourceKey<Level> var1, ChunkPos var2);

    public void addNewChunk(Colony var1, ChunkPos var2, ChunkClaimData var3);
}

