/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.advancements;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;

public class ColonyPopulationTrigger
extends SimpleCriterionTrigger<ColonyPopulationTriggerInstance> {
    public void trigger(ServerPlayer player, int populationCount) {
        this.trigger(player, trigger -> trigger.test(populationCount));
    }

    public Codec<ColonyPopulationTriggerInstance> codec() {
        return ColonyPopulationTriggerInstance.CODEC;
    }

    public record ColonyPopulationTriggerInstance(Optional<ContextAwarePredicate> player, int populationCount) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<ColonyPopulationTriggerInstance> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(ColonyPopulationTriggerInstance::player), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("population_count").forGetter(ColonyPopulationTriggerInstance::populationCount)).apply((Applicative)builder, ColonyPopulationTriggerInstance::new));

        public static Criterion<ColonyPopulationTriggerInstance> colonyPopulation(int populationCount) {
            return ((ColonyPopulationTrigger)((Object)AdvancementTriggers.COLONY_POPULATION.get())).createCriterion((CriterionTriggerInstance)new ColonyPopulationTriggerInstance(Optional.empty(), populationCount));
        }

        public boolean test(int populationCount) {
            return this.populationCount <= populationCount;
        }
    }
}

