/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.util;

import com.github.L_Ender.cataclysm.entity.projectile.Flame_Jet_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Phantom_Halberd_Entity;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.message.MessageParticle;
import net.acetheeldritchking.cataclysm_spellbooks.registries.ItemRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;

public class CSUtils {
    public static double getEyeHeight(LivingEntity entity) {
        return entity.getY() + (double)entity.getEyeHeight() - 0.2;
    }

    public static void spawnHalberdWindmill(int numofBranches, int particlesPerBranch, double initialRadius, double radiusIncrement, double curveFactor, int delay, LivingEntity caster, Level level, float damage, int spellLevel) {
        float angleIncrement = (float)(Math.PI * 2 / (double)numofBranches);
        for (int branch = 0; branch < numofBranches; ++branch) {
            float baseAngle = angleIncrement * (float)branch;
            for (int i = 0; i < particlesPerBranch; ++i) {
                double currentRadius = initialRadius + (double)i * radiusIncrement;
                float currentAngle = (float)((double)baseAngle + (double)((float)i * angleIncrement) / initialRadius + (double)i * curveFactor);
                double offsetX = currentRadius * Math.cos(currentAngle);
                double offsetZ = currentRadius * Math.sin(currentAngle);
                double spawnX = caster.getX() + offsetX;
                double spawnY = caster.getY() + 0.3;
                double spawnZ = caster.getZ() + offsetZ;
                int d1 = delay * (i + 1);
                double deltaX = level.random.nextGaussian() * 0.007;
                double deltaY = level.random.nextGaussian() * 0.007;
                double deltaZ = level.random.nextGaussian() * 0.007;
                if (!level.isClientSide()) {
                    level.addParticle((ParticleOptions)ModParticle.PHANTOM_WING_FLAME.get(), spawnX, spawnY, spawnZ, deltaX, deltaY, deltaZ);
                }
                CSUtils.spawnHalberds(spawnX, spawnZ, caster.getY() - 5.0, caster.getY() + 3.0, currentAngle, d1, damage, caster, level, spellLevel);
            }
        }
    }

    public static void spawnHalberds(double x, double z, double minY, double maxY, float rotation, int delay, float damage, LivingEntity caster, Level level, int spellLevel) {
        BlockPos pos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        int maxIterations = Mth.clamp((int)(spellLevel * 4), (int)1, (int)25);
        int iterationCount = 0;
        do {
            BlockState blockState1;
            VoxelShape shape;
            BlockPos pos1;
            BlockState blockState;
            if (!(blockState = level.getBlockState(pos1 = pos.below())).isFaceSturdy((BlockGetter)level, pos1, Direction.UP)) continue;
            if (!level.isEmptyBlock(pos) && !(shape = (blockState1 = level.getBlockState(pos)).getCollisionShape((BlockGetter)level, pos)).isEmpty()) {
                d0 = shape.max(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((pos = pos.below()).getY() >= Mth.floor((double)minY) && ++iterationCount < maxIterations);
        if (flag) {
            Phantom_Halberd_Entity phantomHalberd = new Phantom_Halberd_Entity(level, x, (double)pos.getY() + d0, z, rotation, delay, caster, damage);
            level.addFreshEntity((Entity)phantomHalberd);
        }
    }

    public static boolean tryCurisumChestplateRebirth(LivingEntity livingEntity) {
        ItemStack chestplate = livingEntity.getItemBySlot(EquipmentSlot.CHEST);
        if (!(chestplate.getItem() != ItemRegistries.CURSIUM_MAGE_CHESTPLATE.get() && chestplate.getItem() != ItemRegistries.CURSIUM_MAGE_CHESTPLATE_ELYTRA.get() || livingEntity.hasEffect((Holder)ModEffect.EFFECTGHOST_SICKNESS) || livingEntity.hasEffect((Holder)ModEffect.EFFECTGHOST_FORM))) {
            livingEntity.setHealth(5.0f);
            livingEntity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 200, 0));
            livingEntity.addEffect(new MobEffectInstance((Holder)ModEffect.EFFECTGHOST_FORM, 100, 0));
            double x = livingEntity.getX();
            double y = livingEntity.getY() + (double)0.3f;
            double z = livingEntity.getZ();
            float size = 3.0f;
            for (ServerPlayer serverPlayer : ((ServerLevel)livingEntity.level()).players()) {
                if (!(serverPlayer.distanceToSqr(Vec3.atCenterOf((Vec3i)livingEntity.blockPosition())) < 1024.0)) continue;
                MessageParticle particle = new MessageParticle();
                for (float i = -size; i <= size; i += 1.0f) {
                    for (float j = -size; j <= size; j += 1.0f) {
                        for (float k = -size; k <= size; k += 1.0f) {
                            double d3 = (double)i + (livingEntity.getRandom().nextDouble() - livingEntity.getRandom().nextDouble()) * 0.5;
                            double d4 = (double)j + (livingEntity.getRandom().nextDouble() - livingEntity.getRandom().nextDouble()) * 0.5;
                            double d5 = (double)k + (livingEntity.getRandom().nextDouble() - livingEntity.getRandom().nextDouble()) * 0.5;
                            double d6 = (double)Mth.sqrt((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / 0.5 + livingEntity.getRandom().nextGaussian() * 0.05;
                            particle.queueParticle((ParticleOptions)ModParticle.CURSED_FLAME.get(), false, x, y, z, d3 / d6, d4 / d6, d5 / d6);
                            if (i == -size || i == size || j == -size || j == size) continue;
                            k += size * 2.0f - 1.0f;
                        }
                    }
                }
                PacketDistributor.sendToPlayersTrackingEntity((Entity)serverPlayer, (CustomPacketPayload)particle, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return true;
        }
        return false;
    }

    public static void spawnFlameJets(Level level, double x, double z, double minY, double maxY, float rotation, int delay, LivingEntity caster, float damage) {
        BlockPos pos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockState1;
            VoxelShape shape;
            BlockPos pos1;
            BlockState blockState;
            if (!(blockState = level.getBlockState(pos1 = pos.below())).isFaceSturdy((BlockGetter)level, pos1, Direction.UP)) continue;
            if (!level.isEmptyBlock(pos) && !(shape = (blockState1 = level.getBlockState(pos)).getCollisionShape((BlockGetter)level, pos)).isEmpty()) {
                d0 = shape.max(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((pos = pos.below()).getY() >= Mth.floor((double)minY) - 1);
        if (flag) {
            Flame_Jet_Entity flameJet = new Flame_Jet_Entity(level, x, (double)pos.getY() + d0, z, rotation, delay, damage, caster);
            level.addFreshEntity((Entity)flameJet);
        }
    }

    public static void spawnCircularFlameJets(float vec3, float math, int vertex, int rune, double time, Level level, LivingEntity caster, float damage) {
        float cos = Mth.cos((float)((float)((double)caster.yBodyRot + Math.PI / 180)));
        float sin = Mth.sin((float)((float)((double)caster.yBodyRot + Math.PI / 180)));
        double theta = (double)caster.yBodyRot * (Math.PI / 180);
        double vecX = Math.cos(theta);
        double vecZ = Math.sin(theta);
        for (int i = 0; i < vertex; ++i) {
            float angle = (float)((double)i * Math.PI / ((double)vertex / 2.0));
            for (int k = 0; k < rune; ++k) {
                double d2 = 1.1 * (double)(k + 1);
                int d3 = (int)(time * (double)(k + 1));
                CSUtils.spawnFlameJets(level, caster.getX() + (double)vec3 * vecX + (double)(cos * math) + (double)Mth.cos((float)angle) * 1.25 * d2, caster.getZ() + (double)vec3 * vecZ + (double)(sin * math) + (double)Mth.sin((float)angle) * 1.25 * d2, caster.getY() - 2.0, caster.getY() + 2.0, angle, d3, caster, damage);
            }
        }
    }

    public static void spawnFlameJetWindmill(int numofBranches, int particlesPerBranch, double initialRadius, double radiusIncrement, double curveFactor, int delay, LivingEntity caster, Level level, float damage) {
        float angleIncrement = (float)(Math.PI * 2 / (double)numofBranches);
        for (int branch = 0; branch < numofBranches; ++branch) {
            float baseAngle = angleIncrement * (float)branch;
            for (int i = 0; i < particlesPerBranch; ++i) {
                double currentRadius = initialRadius + (double)i * radiusIncrement;
                float currentAngle = (float)((double)baseAngle + (double)((float)i * angleIncrement) / initialRadius + (double)i * curveFactor);
                double offsetX = currentRadius * Math.cos(currentAngle);
                double offsetZ = currentRadius * Math.sin(currentAngle);
                double spawnX = caster.getX() + offsetX;
                double spawnY = caster.getY() + 0.3;
                double spawnZ = caster.getZ() + offsetZ;
                int d1 = delay * (i + 1);
                double deltaX = level.random.nextGaussian() * 0.007;
                double deltaY = level.random.nextGaussian() * 0.007;
                double deltaZ = level.random.nextGaussian() * 0.007;
                if (!level.isClientSide()) {
                    level.addParticle((ParticleOptions)ModParticle.PHANTOM_WING_FLAME.get(), spawnX, spawnY, spawnZ, deltaX, deltaY, deltaZ);
                }
                CSUtils.spawnFlameJets(level, spawnX, spawnZ, caster.getY() - 5.0, caster.getY() + 3.0, currentAngle, d1, caster, damage);
            }
        }
    }
}

