/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.evocation;

import com.github.L_Ender.cataclysm.init.ModTag;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class PilferSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"pilfer");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.EVOCATION_RESOURCE).setMaxLevel(3).setCooldownSeconds(100.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.cataclysm_spellbooks.pilfer_priority"));
    }

    public PilferSpell() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 0;
        this.castTime = 20;
        this.baseManaCost = 110;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.ONE_HANDED_HORIZONTAL_SWING_ANIMATION;
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.PLAYER_ATTACK_SWEEP);
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        return Utils.preCastTargetHelper((Level)level, (LivingEntity)entity, (MagicData)playerMagicData, (AbstractSpell)this, (int)(spellLevel * 2), (float)0.15f);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        TargetEntityCastData targetEntityCastData;
        LivingEntity targetEntity;
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData && (targetEntity = (targetEntityCastData = (TargetEntityCastData)iCastData).getTarget((ServerLevel)level)) != null) {
            ItemStack offhandItem = targetEntity.getOffhandItem();
            ItemStack mainhandItem = targetEntity.getMainHandItem();
            if (!offhandItem.isEmpty()) {
                if (!offhandItem.is(ModTag.STICKY_ITEM)) {
                    int i = offhandItem.getCount();
                    ItemStack offhandCopyItem = offhandItem.copy();
                    offhandCopyItem.setCount(1);
                    this.stealItemDrop(offhandCopyItem, targetEntity);
                    targetEntity.setItemSlot(EquipmentSlot.OFFHAND, offhandItem.split(i - 1));
                }
            } else if (!mainhandItem.isEmpty() && !offhandItem.is(ModTag.STICKY_ITEM)) {
                int i = mainhandItem.getCount();
                ItemStack offhandCopyItem = mainhandItem.copy();
                offhandCopyItem.setCount(1);
                this.stealItemDrop(offhandCopyItem, targetEntity);
                targetEntity.setItemSlot(EquipmentSlot.MAINHAND, mainhandItem.split(i - 1));
            }
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private ItemEntity stealItemDrop(ItemStack itemStack, LivingEntity target) {
        if (itemStack.isEmpty()) {
            return null;
        }
        if (target.level().isClientSide) {
            return null;
        }
        double d0 = target.getEyeY() - (double)0.3f;
        ItemEntity itemEntity = new ItemEntity(target.level(), target.getX(), d0, target.getZ(), itemStack);
        itemEntity.setDefaultPickUpDelay();
        itemEntity.setExtendedLifetime();
        float targetSinX = Mth.sin((float)((float)((double)target.getXRot() * (Math.PI / 180))));
        float targetCosX = Mth.cos((float)((float)((double)target.getXRot() * (Math.PI / 180))));
        float targetSinY = Mth.sin((float)((float)((double)target.getYRot() * (Math.PI / 180))));
        float targetCosY = Mth.cos((float)((float)((double)target.getYRot() * (Math.PI / 180))));
        float f5 = (float)((double)target.getRandom().nextFloat() * (Math.PI * 2));
        float f6 = 0.02f * target.getRandom().nextFloat();
        itemEntity.setDeltaMovement((double)(-targetSinY * targetCosX * 0.3f) + Math.cos(f5) * (double)f6, (double)(-targetSinX * 0.3f + 0.1f + (target.getRandom().nextFloat() - target.getRandom().nextFloat()) * 0.1f), (double)(targetCosY * targetCosX * 0.3f) + Math.sin(f5) * (double)f6);
        target.level().addFreshEntity((Entity)itemEntity);
        return itemEntity;
    }
}

