/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.events;

import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.lionfishapi.server.event.StandOnFluidEvent;
import io.redspace.ironsspellbooks.api.events.ModifySpellLevelEvent;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.effects.potion.CursedFrenzyEffect;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSAttributeRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSPotionEffectRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.ItemRegistries;
import net.acetheeldritchking.cataclysm_spellbooks.util.CSUtils;
import net.minecraft.core.Holder;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber
public class ServerEvents {
    @SubscribeEvent
    public static void onLivingPreDamageEvent(LivingDamageEvent.Pre event) {
        Entity attacker;
        LivingEntity livingEntity;
        ItemStack legEquipment;
        LivingEntity attacker2;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity && (attacker2 = (LivingEntity)entity).hasEffect(CSPotionEffectRegistry.ABYSSAL_PREDATOR_EFFECT)) {
            int effectLevel = attacker2.getEffect(CSPotionEffectRegistry.ABYSSAL_PREDATOR_EFFECT).getAmplifier() + 1;
            float baseAmount = event.getOriginalDamage();
            float damageBonusPerLevel = 0.1f * (float)effectLevel;
            float bonusDamage = baseAmount * damageBonusPerLevel;
            float totalDamage = baseAmount + bonusDamage;
            if (attacker2.isInWaterOrRain()) {
                event.setNewDamage(totalDamage);
            }
        }
        if (!(legEquipment = (livingEntity = event.getEntity()).getItemBySlot(EquipmentSlot.LEGS)).isEmpty() && event.getEntity() != null && event.getSource().getEntity() != null && legEquipment.getItem() == ItemRegistries.IGNITIUM_WIZARD_LEGGINGS.get() && (attacker = event.getSource().getEntity()) instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            if (attacker != event.getEntity() && event.getEntity().getRandom().nextFloat() < 0.5f) {
                MobEffectInstance mobEffectInstance = livingAttacker.getEffect((Holder)ModEffect.EFFECTBLAZING_BRAND);
                int i = 1;
                if (mobEffectInstance != null) {
                    i += mobEffectInstance.getAmplifier();
                    livingAttacker.removeEffectNoUpdate((Holder)ModEffect.EFFECTBLAZING_BRAND);
                } else {
                    ++i;
                }
                i = Mth.clamp((int)i, (int)0, (int)2);
                MobEffectInstance effectInstance = new MobEffectInstance((Holder)ModEffect.EFFECTBLAZING_BRAND, 100, i, false, false, true);
                livingAttacker.addEffect(effectInstance);
                if (!attacker.isOnFire()) {
                    attacker.setRemainingFireTicks(5);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTickEvent(EntityTickEvent.Pre event) {
        LivingEntity livingEntity;
        Entity entity = event.getEntity();
        Level level = entity.level();
        if (!level.isClientSide && entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).hasEffect(CSPotionEffectRegistry.ABYSSAL_PREDATOR_EFFECT)) {
            int effectLevel = livingEntity.getEffect(CSPotionEffectRegistry.ABYSSAL_PREDATOR_EFFECT).getAmplifier() + 1;
            float baseMovementSpeed = livingEntity.getSpeed();
            float speedBonusPerLevel = 0.1f * (float)effectLevel;
            float bonusSpeed = baseMovementSpeed * speedBonusPerLevel;
            float totalSpeed = baseMovementSpeed + bonusSpeed;
            if (livingEntity.isInWaterOrRain()) {
                livingEntity.setSpeed(totalSpeed);
            } else {
                livingEntity.setSpeed(baseMovementSpeed);
            }
        }
    }

    @SubscribeEvent
    public static void handleResistanceAttributeSpawn(FinalizeSpawnEvent event) {
        Mob mob = event.getEntity();
        if (mob.getType() == ModEntities.IGNIS.get()) {
            ServerEvents.setIfNonNull((LivingEntity)mob, CSAttributeRegistry.ABYSSAL_MAGIC_RESIST, 0.5);
            ServerEvents.setIfNonNull((LivingEntity)mob, (Holder<Attribute>)AttributeRegistry.FIRE_MAGIC_RESIST, 1.5);
        }
        if (mob.getType() == ModEntities.THE_LEVIATHAN.get()) {
            ServerEvents.setIfNonNull((LivingEntity)mob, (Holder<Attribute>)AttributeRegistry.LIGHTNING_MAGIC_RESIST, 0.5);
            ServerEvents.setIfNonNull((LivingEntity)mob, CSAttributeRegistry.ABYSSAL_MAGIC_RESIST, 1.5);
        }
        if (mob.getType() == ModEntities.ENDER_GUARDIAN.get()) {
            ServerEvents.setIfNonNull((LivingEntity)mob, (Holder<Attribute>)AttributeRegistry.ICE_MAGIC_RESIST, 0.5);
            ServerEvents.setIfNonNull((LivingEntity)mob, (Holder<Attribute>)AttributeRegistry.ENDER_MAGIC_RESIST, 1.5);
        }
        if (mob.getType() == ModEntities.THE_HARBINGER.get()) {
            ServerEvents.setIfNonNull((LivingEntity)mob, (Holder<Attribute>)AttributeRegistry.LIGHTNING_MAGIC_RESIST, 0.5);
            ServerEvents.setIfNonNull((LivingEntity)mob, (Holder<Attribute>)AttributeRegistry.BLOOD_MAGIC_RESIST, 1.5);
        }
        if (mob.getType() == ModEntities.ANCIENT_REMNANT.get()) {
            ServerEvents.setIfNonNull((LivingEntity)mob, (Holder<Attribute>)AttributeRegistry.HOLY_MAGIC_RESIST, 0.5);
            ServerEvents.setIfNonNull((LivingEntity)mob, (Holder<Attribute>)AttributeRegistry.FIRE_MAGIC_RESIST, 1.5);
        }
        if (mob.getType() == ModEntities.NETHERITE_MONSTROSITY.get()) {
            ServerEvents.setIfNonNull((LivingEntity)mob, (Holder<Attribute>)AttributeRegistry.ICE_MAGIC_RESIST, 0.5);
            ServerEvents.setIfNonNull((LivingEntity)mob, (Holder<Attribute>)AttributeRegistry.FIRE_MAGIC_RESIST, 1.5);
        }
        if (mob.getType() == ModEntities.MALEDICTUS.get()) {
            ServerEvents.setIfNonNull((LivingEntity)mob, (Holder<Attribute>)AttributeRegistry.ELDRITCH_MAGIC_RESIST, 0.5);
            ServerEvents.setIfNonNull((LivingEntity)mob, (Holder<Attribute>)AttributeRegistry.ICE_MAGIC_RESIST, 1.5);
        }
    }

    @SubscribeEvent
    public static void standOnFluidEvent(StandOnFluidEvent event) {
        LivingEntity entity = event.getEntity();
        ItemStack bootEquipment = entity.getItemBySlot(EquipmentSlot.FEET);
        if (!bootEquipment.isEmpty() && bootEquipment.getItem() == ItemRegistries.IGNITIUM_WIZARD_BOOTS.get() && !entity.isShiftKeyDown() && (event.getFluidState().is((Fluid)Fluids.LAVA) || event.getFluidState().is((Fluid)Fluids.FLOWING_LAVA))) {
            event.setCanceled(true);
        }
    }

    private static void setIfNonNull(LivingEntity entity, Holder<Attribute> attribute, double value) {
        AttributeInstance instance = entity.getAttributes().getInstance(attribute);
        if (instance != null) {
            instance.setBaseValue(value);
        }
    }

    @SubscribeEvent
    public static void onSpellModifyEvent(ModifySpellLevelEvent event) {
    }

    @SubscribeEvent
    public static void onEffectRemove(MobEffectEvent.Remove event) {
    }

    @SubscribeEvent
    public static void onEffectExpire(MobEffectEvent.Expired event) {
        LivingEntity entity = event.getEntity();
        Holder effect = event.getEffectInstance().getEffect();
        if (effect instanceof CursedFrenzyEffect && !entity.level().isClientSide()) {
            System.out.println("Potion Effect!");
            CSUtils.spawnHalberdWindmill(5, 5, 1.0, 0.5, 0.5, 1, entity, entity.level(), 5.0f, 1);
        }
    }

    @SubscribeEvent
    public static void onFallEvent(LivingFallEvent event) {
        LivingEntity livingEntity;
        LivingEntity entity = event.getEntity();
        if (entity instanceof LivingEntity && !(livingEntity = entity).getItemBySlot(EquipmentSlot.FEET).isEmpty() && livingEntity.getItemBySlot(EquipmentSlot.FEET).getItem() == ItemRegistries.CURSIUM_MAGE_BOOTS.get()) {
            event.setDistance(event.getDistance() * 0.3f);
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        DamageSource damageSource = event.getSource();
        LivingEntity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = entity;
            if (!livingEntity.level().isClientSide && !damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && CSUtils.tryCurisumChestplateRebirth(livingEntity)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity;
        LivingEntity entity = event.getEntity();
        if (entity instanceof LivingEntity && !(livingEntity = entity).getItemBySlot(EquipmentSlot.LEGS).isEmpty() && livingEntity.getItemBySlot(EquipmentSlot.LEGS).getItem() == ItemRegistries.CURSIUM_MAGE_LEGGINGS.get()) {
            if (event.getSource().is(DamageTypeTags.IS_PROJECTILE)) {
                if (livingEntity.getRandom().nextFloat() < 0.15f) {
                    event.setCanceled(true);
                }
            } else if (!event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY) && livingEntity.getRandom().nextFloat() < 0.08f) {
                event.setCanceled(true);
            }
        }
    }
}

